/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ClusterSchedulerConfigSummary;
import software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsResponse;

public class ListClusterSchedulerConfigsPublisher
implements SdkPublisher<ListClusterSchedulerConfigsResponse> {
    private final SageMakerAsyncClient client;
    private final ListClusterSchedulerConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListClusterSchedulerConfigsPublisher(SageMakerAsyncClient client, ListClusterSchedulerConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListClusterSchedulerConfigsPublisher(SageMakerAsyncClient client, ListClusterSchedulerConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListClusterSchedulerConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListClusterSchedulerConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClusterSchedulerConfigSummary> clusterSchedulerConfigSummaries() {
        Function<ListClusterSchedulerConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterSchedulerConfigSummaries() != null) {
                return response.clusterSchedulerConfigSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListClusterSchedulerConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListClusterSchedulerConfigsResponseFetcher
    implements AsyncPageFetcher<ListClusterSchedulerConfigsResponse> {
        private ListClusterSchedulerConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterSchedulerConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListClusterSchedulerConfigsResponse> nextPage(ListClusterSchedulerConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListClusterSchedulerConfigsPublisher.this.client.listClusterSchedulerConfigs(ListClusterSchedulerConfigsPublisher.this.firstRequest);
            }
            return ListClusterSchedulerConfigsPublisher.this.client.listClusterSchedulerConfigs((ListClusterSchedulerConfigsRequest)((Object)ListClusterSchedulerConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

