/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListProjectsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListProjectsResponse;

public class ListProjectsPublisher
implements SdkPublisher<ListProjectsResponse> {
    private final SageMakerAsyncClient client;
    private final ListProjectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProjectsPublisher(SageMakerAsyncClient client, ListProjectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProjectsPublisher(SageMakerAsyncClient client, ListProjectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProjectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProjectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListProjectsResponseFetcher
    implements AsyncPageFetcher<ListProjectsResponse> {
        private ListProjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListProjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProjectsResponse> nextPage(ListProjectsResponse previousPage) {
            if (previousPage == null) {
                return ListProjectsPublisher.this.client.listProjects(ListProjectsPublisher.this.firstRequest);
            }
            return ListProjectsPublisher.this.client.listProjects((ListProjectsRequest)((Object)ListProjectsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

