/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ContainerArgumentsCopier;
import software.amazon.awssdk.services.sagemaker.model.ContainerEntrypointCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppSpecification> {
    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageUri").getter(AppSpecification.getter(AppSpecification::imageUri)).setter(AppSpecification.setter(Builder::imageUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUri").build()}).build();
    private static final SdkField<List<String>> CONTAINER_ENTRYPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerEntrypoint").getter(AppSpecification.getter(AppSpecification::containerEntrypoint)).setter(AppSpecification.setter(Builder::containerEntrypoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerEntrypoint").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONTAINER_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerArguments").getter(AppSpecification.getter(AppSpecification::containerArguments)).setter(AppSpecification.setter(Builder::containerArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerArguments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_URI_FIELD, CONTAINER_ENTRYPOINT_FIELD, CONTAINER_ARGUMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ImageUri", IMAGE_URI_FIELD);
            this.put("ContainerEntrypoint", CONTAINER_ENTRYPOINT_FIELD);
            this.put("ContainerArguments", CONTAINER_ARGUMENTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String imageUri;
    private final List<String> containerEntrypoint;
    private final List<String> containerArguments;

    private AppSpecification(BuilderImpl builder) {
        this.imageUri = builder.imageUri;
        this.containerEntrypoint = builder.containerEntrypoint;
        this.containerArguments = builder.containerArguments;
    }

    public final String imageUri() {
        return this.imageUri;
    }

    public final boolean hasContainerEntrypoint() {
        return this.containerEntrypoint != null && !(this.containerEntrypoint instanceof SdkAutoConstructList);
    }

    public final List<String> containerEntrypoint() {
        return this.containerEntrypoint;
    }

    public final boolean hasContainerArguments() {
        return this.containerArguments != null && !(this.containerArguments instanceof SdkAutoConstructList);
    }

    public final List<String> containerArguments() {
        return this.containerArguments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerEntrypoint() ? this.containerEntrypoint() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerArguments() ? this.containerArguments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppSpecification)) {
            return false;
        }
        AppSpecification other = (AppSpecification)obj;
        return Objects.equals(this.imageUri(), other.imageUri()) && this.hasContainerEntrypoint() == other.hasContainerEntrypoint() && Objects.equals(this.containerEntrypoint(), other.containerEntrypoint()) && this.hasContainerArguments() == other.hasContainerArguments() && Objects.equals(this.containerArguments(), other.containerArguments());
    }

    public final String toString() {
        return ToString.builder((String)"AppSpecification").add("ImageUri", (Object)this.imageUri()).add("ContainerEntrypoint", this.hasContainerEntrypoint() ? this.containerEntrypoint() : null).add("ContainerArguments", this.hasContainerArguments() ? this.containerArguments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageUri": {
                return Optional.ofNullable(clazz.cast(this.imageUri()));
            }
            case "ContainerEntrypoint": {
                return Optional.ofNullable(clazz.cast(this.containerEntrypoint()));
            }
            case "ContainerArguments": {
                return Optional.ofNullable(clazz.cast(this.containerArguments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AppSpecification, T> g) {
        return obj -> g.apply((AppSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageUri;
        private List<String> containerEntrypoint = DefaultSdkAutoConstructList.getInstance();
        private List<String> containerArguments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppSpecification model) {
            this.imageUri(model.imageUri);
            this.containerEntrypoint(model.containerEntrypoint);
            this.containerArguments(model.containerArguments);
        }

        public final String getImageUri() {
            return this.imageUri;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public final Collection<String> getContainerEntrypoint() {
            if (this.containerEntrypoint instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containerEntrypoint;
        }

        public final void setContainerEntrypoint(Collection<String> containerEntrypoint) {
            this.containerEntrypoint = ContainerEntrypointCopier.copy(containerEntrypoint);
        }

        @Override
        public final Builder containerEntrypoint(Collection<String> containerEntrypoint) {
            this.containerEntrypoint = ContainerEntrypointCopier.copy(containerEntrypoint);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerEntrypoint(String ... containerEntrypoint) {
            this.containerEntrypoint(Arrays.asList(containerEntrypoint));
            return this;
        }

        public final Collection<String> getContainerArguments() {
            if (this.containerArguments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containerArguments;
        }

        public final void setContainerArguments(Collection<String> containerArguments) {
            this.containerArguments = ContainerArgumentsCopier.copy(containerArguments);
        }

        @Override
        public final Builder containerArguments(Collection<String> containerArguments) {
            this.containerArguments = ContainerArgumentsCopier.copy(containerArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerArguments(String ... containerArguments) {
            this.containerArguments(Arrays.asList(containerArguments));
            return this;
        }

        public AppSpecification build() {
            return new AppSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppSpecification> {
        public Builder imageUri(String var1);

        public Builder containerEntrypoint(Collection<String> var1);

        public Builder containerEntrypoint(String ... var1);

        public Builder containerArguments(Collection<String> var1);

        public Builder containerArguments(String ... var1);
    }
}

