/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageError;
import software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageErrorMapCopier;
import software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageSummary;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDescribeModelPackageResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, BatchDescribeModelPackageResponse> {
    private static final SdkField<Map<String, BatchDescribeModelPackageSummary>> MODEL_PACKAGE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ModelPackageSummaries").getter(BatchDescribeModelPackageResponse.getter(BatchDescribeModelPackageResponse::modelPackageSummaries)).setter(BatchDescribeModelPackageResponse.setter(Builder::modelPackageSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageSummaries").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDescribeModelPackageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, BatchDescribeModelPackageError>> BATCH_DESCRIBE_MODEL_PACKAGE_ERROR_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("BatchDescribeModelPackageErrorMap").getter(BatchDescribeModelPackageResponse.getter(BatchDescribeModelPackageResponse::batchDescribeModelPackageErrorMap)).setter(BatchDescribeModelPackageResponse.setter(Builder::batchDescribeModelPackageErrorMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchDescribeModelPackageErrorMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDescribeModelPackageError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_SUMMARIES_FIELD, BATCH_DESCRIBE_MODEL_PACKAGE_ERROR_MAP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ModelPackageSummaries", MODEL_PACKAGE_SUMMARIES_FIELD);
            this.put("BatchDescribeModelPackageErrorMap", BATCH_DESCRIBE_MODEL_PACKAGE_ERROR_MAP_FIELD);
        }
    });
    private final Map<String, BatchDescribeModelPackageSummary> modelPackageSummaries;
    private final Map<String, BatchDescribeModelPackageError> batchDescribeModelPackageErrorMap;

    private BatchDescribeModelPackageResponse(BuilderImpl builder) {
        super(builder);
        this.modelPackageSummaries = builder.modelPackageSummaries;
        this.batchDescribeModelPackageErrorMap = builder.batchDescribeModelPackageErrorMap;
    }

    public final boolean hasModelPackageSummaries() {
        return this.modelPackageSummaries != null && !(this.modelPackageSummaries instanceof SdkAutoConstructMap);
    }

    public final Map<String, BatchDescribeModelPackageSummary> modelPackageSummaries() {
        return this.modelPackageSummaries;
    }

    public final boolean hasBatchDescribeModelPackageErrorMap() {
        return this.batchDescribeModelPackageErrorMap != null && !(this.batchDescribeModelPackageErrorMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, BatchDescribeModelPackageError> batchDescribeModelPackageErrorMap() {
        return this.batchDescribeModelPackageErrorMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelPackageSummaries() ? this.modelPackageSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBatchDescribeModelPackageErrorMap() ? this.batchDescribeModelPackageErrorMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeModelPackageResponse)) {
            return false;
        }
        BatchDescribeModelPackageResponse other = (BatchDescribeModelPackageResponse)((Object)obj);
        return this.hasModelPackageSummaries() == other.hasModelPackageSummaries() && Objects.equals(this.modelPackageSummaries(), other.modelPackageSummaries()) && this.hasBatchDescribeModelPackageErrorMap() == other.hasBatchDescribeModelPackageErrorMap() && Objects.equals(this.batchDescribeModelPackageErrorMap(), other.batchDescribeModelPackageErrorMap());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDescribeModelPackageResponse").add("ModelPackageSummaries", this.hasModelPackageSummaries() ? this.modelPackageSummaries() : null).add("BatchDescribeModelPackageErrorMap", this.hasBatchDescribeModelPackageErrorMap() ? this.batchDescribeModelPackageErrorMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageSummaries": {
                return Optional.ofNullable(clazz.cast(this.modelPackageSummaries()));
            }
            case "BatchDescribeModelPackageErrorMap": {
                return Optional.ofNullable(clazz.cast(this.batchDescribeModelPackageErrorMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeModelPackageResponse, T> g) {
        return obj -> g.apply((BatchDescribeModelPackageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private Map<String, BatchDescribeModelPackageSummary> modelPackageSummaries = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, BatchDescribeModelPackageError> batchDescribeModelPackageErrorMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeModelPackageResponse model) {
            super(model);
            this.modelPackageSummaries(model.modelPackageSummaries);
            this.batchDescribeModelPackageErrorMap(model.batchDescribeModelPackageErrorMap);
        }

        public final Map<String, BatchDescribeModelPackageSummary.Builder> getModelPackageSummaries() {
            Map<String, BatchDescribeModelPackageSummary.Builder> result = ModelPackageSummariesCopier.copyToBuilder(this.modelPackageSummaries);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setModelPackageSummaries(Map<String, BatchDescribeModelPackageSummary.BuilderImpl> modelPackageSummaries) {
            this.modelPackageSummaries = ModelPackageSummariesCopier.copyFromBuilder(modelPackageSummaries);
        }

        @Override
        public final Builder modelPackageSummaries(Map<String, BatchDescribeModelPackageSummary> modelPackageSummaries) {
            this.modelPackageSummaries = ModelPackageSummariesCopier.copy(modelPackageSummaries);
            return this;
        }

        public final Map<String, BatchDescribeModelPackageError.Builder> getBatchDescribeModelPackageErrorMap() {
            Map<String, BatchDescribeModelPackageError.Builder> result = BatchDescribeModelPackageErrorMapCopier.copyToBuilder(this.batchDescribeModelPackageErrorMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBatchDescribeModelPackageErrorMap(Map<String, BatchDescribeModelPackageError.BuilderImpl> batchDescribeModelPackageErrorMap) {
            this.batchDescribeModelPackageErrorMap = BatchDescribeModelPackageErrorMapCopier.copyFromBuilder(batchDescribeModelPackageErrorMap);
        }

        @Override
        public final Builder batchDescribeModelPackageErrorMap(Map<String, BatchDescribeModelPackageError> batchDescribeModelPackageErrorMap) {
            this.batchDescribeModelPackageErrorMap = BatchDescribeModelPackageErrorMapCopier.copy(batchDescribeModelPackageErrorMap);
            return this;
        }

        @Override
        public BatchDescribeModelPackageResponse build() {
            return new BatchDescribeModelPackageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDescribeModelPackageResponse> {
        public Builder modelPackageSummaries(Map<String, BatchDescribeModelPackageSummary> var1);

        public Builder batchDescribeModelPackageErrorMap(Map<String, BatchDescribeModelPackageError> var1);
    }
}

