/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.MetadataProperties;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentSimpleSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentSimpleSummary;
import software.amazon.awssdk.services.sagemaker.model.TrialSource;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Trial
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Trial> {
    private static final SdkField<String> TRIAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrialName").getter(Trial.getter(Trial::trialName)).setter(Trial.setter(Builder::trialName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialName").build()}).build();
    private static final SdkField<String> TRIAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrialArn").getter(Trial.getter(Trial::trialArn)).setter(Trial.setter(Builder::trialArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialArn").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(Trial.getter(Trial::displayName)).setter(Trial.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> EXPERIMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExperimentName").getter(Trial.getter(Trial::experimentName)).setter(Trial.setter(Builder::experimentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentName").build()}).build();
    private static final SdkField<TrialSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(Trial.getter(Trial::source)).setter(Trial.setter(Builder::source)).constructor(TrialSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Trial.getter(Trial::creationTime)).setter(Trial.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(Trial.getter(Trial::createdBy)).setter(Trial.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(Trial.getter(Trial::lastModifiedTime)).setter(Trial.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedBy").getter(Trial.getter(Trial::lastModifiedBy)).setter(Trial.setter(Builder::lastModifiedBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<MetadataProperties> METADATA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataProperties").getter(Trial.getter(Trial::metadataProperties)).setter(Trial.setter(Builder::metadataProperties)).constructor(MetadataProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProperties").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Trial.getter(Trial::tags)).setter(Trial.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TrialComponentSimpleSummary>> TRIAL_COMPONENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrialComponentSummaries").getter(Trial.getter(Trial::trialComponentSummaries)).setter(Trial.setter(Builder::trialComponentSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentSimpleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_NAME_FIELD, TRIAL_ARN_FIELD, DISPLAY_NAME_FIELD, EXPERIMENT_NAME_FIELD, SOURCE_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, METADATA_PROPERTIES_FIELD, TAGS_FIELD, TRIAL_COMPONENT_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Trial.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String trialName;
    private final String trialArn;
    private final String displayName;
    private final String experimentName;
    private final TrialSource source;
    private final Instant creationTime;
    private final UserContext createdBy;
    private final Instant lastModifiedTime;
    private final UserContext lastModifiedBy;
    private final MetadataProperties metadataProperties;
    private final List<Tag> tags;
    private final List<TrialComponentSimpleSummary> trialComponentSummaries;

    private Trial(BuilderImpl builder) {
        this.trialName = builder.trialName;
        this.trialArn = builder.trialArn;
        this.displayName = builder.displayName;
        this.experimentName = builder.experimentName;
        this.source = builder.source;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.metadataProperties = builder.metadataProperties;
        this.tags = builder.tags;
        this.trialComponentSummaries = builder.trialComponentSummaries;
    }

    public final String trialName() {
        return this.trialName;
    }

    public final String trialArn() {
        return this.trialArn;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String experimentName() {
        return this.experimentName;
    }

    public final TrialSource source() {
        return this.source;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final UserContext lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final MetadataProperties metadataProperties() {
        return this.metadataProperties;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasTrialComponentSummaries() {
        return this.trialComponentSummaries != null && !(this.trialComponentSummaries instanceof SdkAutoConstructList);
    }

    public final List<TrialComponentSimpleSummary> trialComponentSummaries() {
        return this.trialComponentSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trialName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrialComponentSummaries() ? this.trialComponentSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trial)) {
            return false;
        }
        Trial other = (Trial)obj;
        return Objects.equals(this.trialName(), other.trialName()) && Objects.equals(this.trialArn(), other.trialArn()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.experimentName(), other.experimentName()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.metadataProperties(), other.metadataProperties()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasTrialComponentSummaries() == other.hasTrialComponentSummaries() && Objects.equals(this.trialComponentSummaries(), other.trialComponentSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"Trial").add("TrialName", (Object)this.trialName()).add("TrialArn", (Object)this.trialArn()).add("DisplayName", (Object)this.displayName()).add("ExperimentName", (Object)this.experimentName()).add("Source", (Object)this.source()).add("CreationTime", (Object)this.creationTime()).add("CreatedBy", (Object)this.createdBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("MetadataProperties", (Object)this.metadataProperties()).add("Tags", this.hasTags() ? this.tags() : null).add("TrialComponentSummaries", this.hasTrialComponentSummaries() ? this.trialComponentSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrialName": {
                return Optional.ofNullable(clazz.cast(this.trialName()));
            }
            case "TrialArn": {
                return Optional.ofNullable(clazz.cast(this.trialArn()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "ExperimentName": {
                return Optional.ofNullable(clazz.cast(this.experimentName()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "MetadataProperties": {
                return Optional.ofNullable(clazz.cast(this.metadataProperties()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TrialComponentSummaries": {
                return Optional.ofNullable(clazz.cast(this.trialComponentSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrialName", TRIAL_NAME_FIELD);
        map.put("TrialArn", TRIAL_ARN_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("ExperimentName", EXPERIMENT_NAME_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("MetadataProperties", METADATA_PROPERTIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("TrialComponentSummaries", TRIAL_COMPONENT_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Trial, T> g) {
        return obj -> g.apply((Trial)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trialName;
        private String trialArn;
        private String displayName;
        private String experimentName;
        private TrialSource source;
        private Instant creationTime;
        private UserContext createdBy;
        private Instant lastModifiedTime;
        private UserContext lastModifiedBy;
        private MetadataProperties metadataProperties;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<TrialComponentSimpleSummary> trialComponentSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Trial model) {
            this.trialName(model.trialName);
            this.trialArn(model.trialArn);
            this.displayName(model.displayName);
            this.experimentName(model.experimentName);
            this.source(model.source);
            this.creationTime(model.creationTime);
            this.createdBy(model.createdBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedBy(model.lastModifiedBy);
            this.metadataProperties(model.metadataProperties);
            this.tags(model.tags);
            this.trialComponentSummaries(model.trialComponentSummaries);
        }

        public final String getTrialName() {
            return this.trialName;
        }

        public final void setTrialName(String trialName) {
            this.trialName = trialName;
        }

        @Override
        public final Builder trialName(String trialName) {
            this.trialName = trialName;
            return this;
        }

        public final String getTrialArn() {
            return this.trialArn;
        }

        public final void setTrialArn(String trialArn) {
            this.trialArn = trialArn;
        }

        @Override
        public final Builder trialArn(String trialArn) {
            this.trialArn = trialArn;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getExperimentName() {
            return this.experimentName;
        }

        public final void setExperimentName(String experimentName) {
            this.experimentName = experimentName;
        }

        @Override
        public final Builder experimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        public final TrialSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(TrialSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TrialSource source) {
            this.source = source;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return this.lastModifiedBy != null ? this.lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final MetadataProperties.Builder getMetadataProperties() {
            return this.metadataProperties != null ? this.metadataProperties.toBuilder() : null;
        }

        public final void setMetadataProperties(MetadataProperties.BuilderImpl metadataProperties) {
            this.metadataProperties = metadataProperties != null ? metadataProperties.build() : null;
        }

        @Override
        public final Builder metadataProperties(MetadataProperties metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TrialComponentSimpleSummary.Builder> getTrialComponentSummaries() {
            List<TrialComponentSimpleSummary.Builder> result = TrialComponentSimpleSummariesCopier.copyToBuilder(this.trialComponentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrialComponentSummaries(Collection<TrialComponentSimpleSummary.BuilderImpl> trialComponentSummaries) {
            this.trialComponentSummaries = TrialComponentSimpleSummariesCopier.copyFromBuilder(trialComponentSummaries);
        }

        @Override
        public final Builder trialComponentSummaries(Collection<TrialComponentSimpleSummary> trialComponentSummaries) {
            this.trialComponentSummaries = TrialComponentSimpleSummariesCopier.copy(trialComponentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialComponentSummaries(TrialComponentSimpleSummary ... trialComponentSummaries) {
            this.trialComponentSummaries(Arrays.asList(trialComponentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialComponentSummaries(Consumer<TrialComponentSimpleSummary.Builder> ... trialComponentSummaries) {
            this.trialComponentSummaries(Stream.of(trialComponentSummaries).map(c -> (TrialComponentSimpleSummary)((TrialComponentSimpleSummary.Builder)TrialComponentSimpleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Trial build() {
            return new Trial(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Trial> {
        public Builder trialName(String var1);

        public Builder trialArn(String var1);

        public Builder displayName(String var1);

        public Builder experimentName(String var1);

        public Builder source(TrialSource var1);

        default public Builder source(Consumer<TrialSource.Builder> source) {
            return this.source((TrialSource)((TrialSource.Builder)TrialSource.builder().applyMutation(source)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedBy(UserContext var1);

        default public Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return this.lastModifiedBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(lastModifiedBy)).build());
        }

        public Builder metadataProperties(MetadataProperties var1);

        default public Builder metadataProperties(Consumer<MetadataProperties.Builder> metadataProperties) {
            return this.metadataProperties((MetadataProperties)((MetadataProperties.Builder)MetadataProperties.builder().applyMutation(metadataProperties)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder trialComponentSummaries(Collection<TrialComponentSimpleSummary> var1);

        public Builder trialComponentSummaries(TrialComponentSimpleSummary ... var1);

        public Builder trialComponentSummaries(Consumer<TrialComponentSimpleSummary.Builder> ... var1);
    }
}

