/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ClusterNodeSummary;
import software.amazon.awssdk.services.sagemaker.model.ListClusterNodesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClusterNodesResponse;

public class ListClusterNodesPublisher
implements SdkPublisher<ListClusterNodesResponse> {
    private final SageMakerAsyncClient client;
    private final ListClusterNodesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListClusterNodesPublisher(SageMakerAsyncClient client, ListClusterNodesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListClusterNodesPublisher(SageMakerAsyncClient client, ListClusterNodesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListClusterNodesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListClusterNodesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClusterNodeSummary> clusterNodeSummaries() {
        Function<ListClusterNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterNodeSummaries() != null) {
                return response.clusterNodeSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListClusterNodesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListClusterNodesResponseFetcher
    implements AsyncPageFetcher<ListClusterNodesResponse> {
        private ListClusterNodesResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListClusterNodesResponse> nextPage(ListClusterNodesResponse previousPage) {
            if (previousPage == null) {
                return ListClusterNodesPublisher.this.client.listClusterNodes(ListClusterNodesPublisher.this.firstRequest);
            }
            return ListClusterNodesPublisher.this.client.listClusterNodes((ListClusterNodesRequest)((Object)ListClusterNodesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

