/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinition;
import software.amazon.awssdk.services.sagemaker.model.MonitoringType;
import software.amazon.awssdk.services.sagemaker.model.ScheduleConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringScheduleConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringScheduleConfig> {
    private static final SdkField<ScheduleConfig> SCHEDULE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduleConfig").getter(MonitoringScheduleConfig.getter(MonitoringScheduleConfig::scheduleConfig)).setter(MonitoringScheduleConfig.setter(Builder::scheduleConfig)).constructor(ScheduleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfig").build()}).build();
    private static final SdkField<MonitoringJobDefinition> MONITORING_JOB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitoringJobDefinition").getter(MonitoringScheduleConfig.getter(MonitoringScheduleConfig::monitoringJobDefinition)).setter(MonitoringScheduleConfig.setter(Builder::monitoringJobDefinition)).constructor(MonitoringJobDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringJobDefinition").build()}).build();
    private static final SdkField<String> MONITORING_JOB_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringJobDefinitionName").getter(MonitoringScheduleConfig.getter(MonitoringScheduleConfig::monitoringJobDefinitionName)).setter(MonitoringScheduleConfig.setter(Builder::monitoringJobDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringJobDefinitionName").build()}).build();
    private static final SdkField<String> MONITORING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringType").getter(MonitoringScheduleConfig.getter(MonitoringScheduleConfig::monitoringTypeAsString)).setter(MonitoringScheduleConfig.setter(Builder::monitoringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_CONFIG_FIELD, MONITORING_JOB_DEFINITION_FIELD, MONITORING_JOB_DEFINITION_NAME_FIELD, MONITORING_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MonitoringScheduleConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ScheduleConfig scheduleConfig;
    private final MonitoringJobDefinition monitoringJobDefinition;
    private final String monitoringJobDefinitionName;
    private final String monitoringType;

    private MonitoringScheduleConfig(BuilderImpl builder) {
        this.scheduleConfig = builder.scheduleConfig;
        this.monitoringJobDefinition = builder.monitoringJobDefinition;
        this.monitoringJobDefinitionName = builder.monitoringJobDefinitionName;
        this.monitoringType = builder.monitoringType;
    }

    public final ScheduleConfig scheduleConfig() {
        return this.scheduleConfig;
    }

    public final MonitoringJobDefinition monitoringJobDefinition() {
        return this.monitoringJobDefinition;
    }

    public final String monitoringJobDefinitionName() {
        return this.monitoringJobDefinitionName;
    }

    public final MonitoringType monitoringType() {
        return MonitoringType.fromValue(this.monitoringType);
    }

    public final String monitoringTypeAsString() {
        return this.monitoringType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringJobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringJobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringScheduleConfig)) {
            return false;
        }
        MonitoringScheduleConfig other = (MonitoringScheduleConfig)obj;
        return Objects.equals(this.scheduleConfig(), other.scheduleConfig()) && Objects.equals(this.monitoringJobDefinition(), other.monitoringJobDefinition()) && Objects.equals(this.monitoringJobDefinitionName(), other.monitoringJobDefinitionName()) && Objects.equals(this.monitoringTypeAsString(), other.monitoringTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoringScheduleConfig").add("ScheduleConfig", (Object)this.scheduleConfig()).add("MonitoringJobDefinition", (Object)this.monitoringJobDefinition()).add("MonitoringJobDefinitionName", (Object)this.monitoringJobDefinitionName()).add("MonitoringType", (Object)this.monitoringTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduleConfig": {
                return Optional.ofNullable(clazz.cast(this.scheduleConfig()));
            }
            case "MonitoringJobDefinition": {
                return Optional.ofNullable(clazz.cast(this.monitoringJobDefinition()));
            }
            case "MonitoringJobDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.monitoringJobDefinitionName()));
            }
            case "MonitoringType": {
                return Optional.ofNullable(clazz.cast(this.monitoringTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScheduleConfig", SCHEDULE_CONFIG_FIELD);
        map.put("MonitoringJobDefinition", MONITORING_JOB_DEFINITION_FIELD);
        map.put("MonitoringJobDefinitionName", MONITORING_JOB_DEFINITION_NAME_FIELD);
        map.put("MonitoringType", MONITORING_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoringScheduleConfig, T> g) {
        return obj -> g.apply((MonitoringScheduleConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ScheduleConfig scheduleConfig;
        private MonitoringJobDefinition monitoringJobDefinition;
        private String monitoringJobDefinitionName;
        private String monitoringType;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringScheduleConfig model) {
            this.scheduleConfig(model.scheduleConfig);
            this.monitoringJobDefinition(model.monitoringJobDefinition);
            this.monitoringJobDefinitionName(model.monitoringJobDefinitionName);
            this.monitoringType(model.monitoringType);
        }

        public final ScheduleConfig.Builder getScheduleConfig() {
            return this.scheduleConfig != null ? this.scheduleConfig.toBuilder() : null;
        }

        public final void setScheduleConfig(ScheduleConfig.BuilderImpl scheduleConfig) {
            this.scheduleConfig = scheduleConfig != null ? scheduleConfig.build() : null;
        }

        @Override
        public final Builder scheduleConfig(ScheduleConfig scheduleConfig) {
            this.scheduleConfig = scheduleConfig;
            return this;
        }

        public final MonitoringJobDefinition.Builder getMonitoringJobDefinition() {
            return this.monitoringJobDefinition != null ? this.monitoringJobDefinition.toBuilder() : null;
        }

        public final void setMonitoringJobDefinition(MonitoringJobDefinition.BuilderImpl monitoringJobDefinition) {
            this.monitoringJobDefinition = monitoringJobDefinition != null ? monitoringJobDefinition.build() : null;
        }

        @Override
        public final Builder monitoringJobDefinition(MonitoringJobDefinition monitoringJobDefinition) {
            this.monitoringJobDefinition = monitoringJobDefinition;
            return this;
        }

        public final String getMonitoringJobDefinitionName() {
            return this.monitoringJobDefinitionName;
        }

        public final void setMonitoringJobDefinitionName(String monitoringJobDefinitionName) {
            this.monitoringJobDefinitionName = monitoringJobDefinitionName;
        }

        @Override
        public final Builder monitoringJobDefinitionName(String monitoringJobDefinitionName) {
            this.monitoringJobDefinitionName = monitoringJobDefinitionName;
            return this;
        }

        public final String getMonitoringType() {
            return this.monitoringType;
        }

        public final void setMonitoringType(String monitoringType) {
            this.monitoringType = monitoringType;
        }

        @Override
        public final Builder monitoringType(String monitoringType) {
            this.monitoringType = monitoringType;
            return this;
        }

        @Override
        public final Builder monitoringType(MonitoringType monitoringType) {
            this.monitoringType(monitoringType == null ? null : monitoringType.toString());
            return this;
        }

        public MonitoringScheduleConfig build() {
            return new MonitoringScheduleConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringScheduleConfig> {
        public Builder scheduleConfig(ScheduleConfig var1);

        default public Builder scheduleConfig(Consumer<ScheduleConfig.Builder> scheduleConfig) {
            return this.scheduleConfig((ScheduleConfig)((ScheduleConfig.Builder)ScheduleConfig.builder().applyMutation(scheduleConfig)).build());
        }

        public Builder monitoringJobDefinition(MonitoringJobDefinition var1);

        default public Builder monitoringJobDefinition(Consumer<MonitoringJobDefinition.Builder> monitoringJobDefinition) {
            return this.monitoringJobDefinition((MonitoringJobDefinition)((MonitoringJobDefinition.Builder)MonitoringJobDefinition.builder().applyMutation(monitoringJobDefinition)).build());
        }

        public Builder monitoringJobDefinitionName(String var1);

        public Builder monitoringType(String var1);

        public Builder monitoringType(MonitoringType var1);
    }
}

