/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.InferenceExperimentDataStorageConfig;
import software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSchedule;
import software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelVariantConfigListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.ShadowModeConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInferenceExperimentRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateInferenceExperimentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateInferenceExperimentRequest.getter(UpdateInferenceExperimentRequest::name)).setter(UpdateInferenceExperimentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<InferenceExperimentSchedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schedule").getter(UpdateInferenceExperimentRequest.getter(UpdateInferenceExperimentRequest::schedule)).setter(UpdateInferenceExperimentRequest.setter(Builder::schedule)).constructor(InferenceExperimentSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateInferenceExperimentRequest.getter(UpdateInferenceExperimentRequest::description)).setter(UpdateInferenceExperimentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<ModelVariantConfig>> MODEL_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelVariants").getter(UpdateInferenceExperimentRequest.getter(UpdateInferenceExperimentRequest::modelVariants)).setter(UpdateInferenceExperimentRequest.setter(Builder::modelVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelVariantConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InferenceExperimentDataStorageConfig> DATA_STORAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataStorageConfig").getter(UpdateInferenceExperimentRequest.getter(UpdateInferenceExperimentRequest::dataStorageConfig)).setter(UpdateInferenceExperimentRequest.setter(Builder::dataStorageConfig)).constructor(InferenceExperimentDataStorageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStorageConfig").build()}).build();
    private static final SdkField<ShadowModeConfig> SHADOW_MODE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShadowModeConfig").getter(UpdateInferenceExperimentRequest.getter(UpdateInferenceExperimentRequest::shadowModeConfig)).setter(UpdateInferenceExperimentRequest.setter(Builder::shadowModeConfig)).constructor(ShadowModeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShadowModeConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCHEDULE_FIELD, DESCRIPTION_FIELD, MODEL_VARIANTS_FIELD, DATA_STORAGE_CONFIG_FIELD, SHADOW_MODE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Schedule", SCHEDULE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("ModelVariants", MODEL_VARIANTS_FIELD);
            this.put("DataStorageConfig", DATA_STORAGE_CONFIG_FIELD);
            this.put("ShadowModeConfig", SHADOW_MODE_CONFIG_FIELD);
        }
    });
    private final String name;
    private final InferenceExperimentSchedule schedule;
    private final String description;
    private final List<ModelVariantConfig> modelVariants;
    private final InferenceExperimentDataStorageConfig dataStorageConfig;
    private final ShadowModeConfig shadowModeConfig;

    private UpdateInferenceExperimentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.schedule = builder.schedule;
        this.description = builder.description;
        this.modelVariants = builder.modelVariants;
        this.dataStorageConfig = builder.dataStorageConfig;
        this.shadowModeConfig = builder.shadowModeConfig;
    }

    public final String name() {
        return this.name;
    }

    public final InferenceExperimentSchedule schedule() {
        return this.schedule;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasModelVariants() {
        return this.modelVariants != null && !(this.modelVariants instanceof SdkAutoConstructList);
    }

    public final List<ModelVariantConfig> modelVariants() {
        return this.modelVariants;
    }

    public final InferenceExperimentDataStorageConfig dataStorageConfig() {
        return this.dataStorageConfig;
    }

    public final ShadowModeConfig shadowModeConfig() {
        return this.shadowModeConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelVariants() ? this.modelVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowModeConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInferenceExperimentRequest)) {
            return false;
        }
        UpdateInferenceExperimentRequest other = (UpdateInferenceExperimentRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.description(), other.description()) && this.hasModelVariants() == other.hasModelVariants() && Objects.equals(this.modelVariants(), other.modelVariants()) && Objects.equals(this.dataStorageConfig(), other.dataStorageConfig()) && Objects.equals(this.shadowModeConfig(), other.shadowModeConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateInferenceExperimentRequest").add("Name", (Object)this.name()).add("Schedule", (Object)this.schedule()).add("Description", (Object)this.description()).add("ModelVariants", this.hasModelVariants() ? this.modelVariants() : null).add("DataStorageConfig", (Object)this.dataStorageConfig()).add("ShadowModeConfig", (Object)this.shadowModeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ModelVariants": {
                return Optional.ofNullable(clazz.cast(this.modelVariants()));
            }
            case "DataStorageConfig": {
                return Optional.ofNullable(clazz.cast(this.dataStorageConfig()));
            }
            case "ShadowModeConfig": {
                return Optional.ofNullable(clazz.cast(this.shadowModeConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInferenceExperimentRequest, T> g) {
        return obj -> g.apply((UpdateInferenceExperimentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String name;
        private InferenceExperimentSchedule schedule;
        private String description;
        private List<ModelVariantConfig> modelVariants = DefaultSdkAutoConstructList.getInstance();
        private InferenceExperimentDataStorageConfig dataStorageConfig;
        private ShadowModeConfig shadowModeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInferenceExperimentRequest model) {
            super(model);
            this.name(model.name);
            this.schedule(model.schedule);
            this.description(model.description);
            this.modelVariants(model.modelVariants);
            this.dataStorageConfig(model.dataStorageConfig);
            this.shadowModeConfig(model.shadowModeConfig);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final InferenceExperimentSchedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(InferenceExperimentSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(InferenceExperimentSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ModelVariantConfig.Builder> getModelVariants() {
            List<ModelVariantConfig.Builder> result = ModelVariantConfigListCopier.copyToBuilder(this.modelVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelVariants(Collection<ModelVariantConfig.BuilderImpl> modelVariants) {
            this.modelVariants = ModelVariantConfigListCopier.copyFromBuilder(modelVariants);
        }

        @Override
        public final Builder modelVariants(Collection<ModelVariantConfig> modelVariants) {
            this.modelVariants = ModelVariantConfigListCopier.copy(modelVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariants(ModelVariantConfig ... modelVariants) {
            this.modelVariants(Arrays.asList(modelVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariants(Consumer<ModelVariantConfig.Builder> ... modelVariants) {
            this.modelVariants(Stream.of(modelVariants).map(c -> (ModelVariantConfig)((ModelVariantConfig.Builder)ModelVariantConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InferenceExperimentDataStorageConfig.Builder getDataStorageConfig() {
            return this.dataStorageConfig != null ? this.dataStorageConfig.toBuilder() : null;
        }

        public final void setDataStorageConfig(InferenceExperimentDataStorageConfig.BuilderImpl dataStorageConfig) {
            this.dataStorageConfig = dataStorageConfig != null ? dataStorageConfig.build() : null;
        }

        @Override
        public final Builder dataStorageConfig(InferenceExperimentDataStorageConfig dataStorageConfig) {
            this.dataStorageConfig = dataStorageConfig;
            return this;
        }

        public final ShadowModeConfig.Builder getShadowModeConfig() {
            return this.shadowModeConfig != null ? this.shadowModeConfig.toBuilder() : null;
        }

        public final void setShadowModeConfig(ShadowModeConfig.BuilderImpl shadowModeConfig) {
            this.shadowModeConfig = shadowModeConfig != null ? shadowModeConfig.build() : null;
        }

        @Override
        public final Builder shadowModeConfig(ShadowModeConfig shadowModeConfig) {
            this.shadowModeConfig = shadowModeConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInferenceExperimentRequest build() {
            return new UpdateInferenceExperimentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInferenceExperimentRequest> {
        public Builder name(String var1);

        public Builder schedule(InferenceExperimentSchedule var1);

        default public Builder schedule(Consumer<InferenceExperimentSchedule.Builder> schedule) {
            return this.schedule((InferenceExperimentSchedule)((InferenceExperimentSchedule.Builder)InferenceExperimentSchedule.builder().applyMutation(schedule)).build());
        }

        public Builder description(String var1);

        public Builder modelVariants(Collection<ModelVariantConfig> var1);

        public Builder modelVariants(ModelVariantConfig ... var1);

        public Builder modelVariants(Consumer<ModelVariantConfig.Builder> ... var1);

        public Builder dataStorageConfig(InferenceExperimentDataStorageConfig var1);

        default public Builder dataStorageConfig(Consumer<InferenceExperimentDataStorageConfig.Builder> dataStorageConfig) {
            return this.dataStorageConfig((InferenceExperimentDataStorageConfig)((InferenceExperimentDataStorageConfig.Builder)InferenceExperimentDataStorageConfig.builder().applyMutation(dataStorageConfig)).build());
        }

        public Builder shadowModeConfig(ShadowModeConfig var1);

        default public Builder shadowModeConfig(Consumer<ShadowModeConfig.Builder> shadowModeConfig) {
            return this.shadowModeConfig((ShadowModeConfig)((ShadowModeConfig.Builder)ShadowModeConfig.builder().applyMutation(shadowModeConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

