/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ClusterSchedulerConfigSummary;
import software.amazon.awssdk.services.sagemaker.model.ClusterSchedulerConfigSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClusterSchedulerConfigsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListClusterSchedulerConfigsResponse> {
    private static final SdkField<List<ClusterSchedulerConfigSummary>> CLUSTER_SCHEDULER_CONFIG_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterSchedulerConfigSummaries").getter(ListClusterSchedulerConfigsResponse.getter(ListClusterSchedulerConfigsResponse::clusterSchedulerConfigSummaries)).setter(ListClusterSchedulerConfigsResponse.setter(Builder::clusterSchedulerConfigSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterSchedulerConfigSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListClusterSchedulerConfigsResponse.getter(ListClusterSchedulerConfigsResponse::nextToken)).setter(ListClusterSchedulerConfigsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_SCHEDULER_CONFIG_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClusterSchedulerConfigSummaries", CLUSTER_SCHEDULER_CONFIG_SUMMARIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ClusterSchedulerConfigSummary> clusterSchedulerConfigSummaries;
    private final String nextToken;

    private ListClusterSchedulerConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.clusterSchedulerConfigSummaries = builder.clusterSchedulerConfigSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasClusterSchedulerConfigSummaries() {
        return this.clusterSchedulerConfigSummaries != null && !(this.clusterSchedulerConfigSummaries instanceof SdkAutoConstructList);
    }

    public final List<ClusterSchedulerConfigSummary> clusterSchedulerConfigSummaries() {
        return this.clusterSchedulerConfigSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterSchedulerConfigSummaries() ? this.clusterSchedulerConfigSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterSchedulerConfigsResponse)) {
            return false;
        }
        ListClusterSchedulerConfigsResponse other = (ListClusterSchedulerConfigsResponse)((Object)obj);
        return this.hasClusterSchedulerConfigSummaries() == other.hasClusterSchedulerConfigSummaries() && Objects.equals(this.clusterSchedulerConfigSummaries(), other.clusterSchedulerConfigSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListClusterSchedulerConfigsResponse").add("ClusterSchedulerConfigSummaries", this.hasClusterSchedulerConfigSummaries() ? this.clusterSchedulerConfigSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterSchedulerConfigSummaries": {
                return Optional.ofNullable(clazz.cast(this.clusterSchedulerConfigSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListClusterSchedulerConfigsResponse, T> g) {
        return obj -> g.apply((ListClusterSchedulerConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ClusterSchedulerConfigSummary> clusterSchedulerConfigSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterSchedulerConfigsResponse model) {
            super(model);
            this.clusterSchedulerConfigSummaries(model.clusterSchedulerConfigSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ClusterSchedulerConfigSummary.Builder> getClusterSchedulerConfigSummaries() {
            List<ClusterSchedulerConfigSummary.Builder> result = ClusterSchedulerConfigSummaryListCopier.copyToBuilder(this.clusterSchedulerConfigSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterSchedulerConfigSummaries(Collection<ClusterSchedulerConfigSummary.BuilderImpl> clusterSchedulerConfigSummaries) {
            this.clusterSchedulerConfigSummaries = ClusterSchedulerConfigSummaryListCopier.copyFromBuilder(clusterSchedulerConfigSummaries);
        }

        @Override
        public final Builder clusterSchedulerConfigSummaries(Collection<ClusterSchedulerConfigSummary> clusterSchedulerConfigSummaries) {
            this.clusterSchedulerConfigSummaries = ClusterSchedulerConfigSummaryListCopier.copy(clusterSchedulerConfigSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSchedulerConfigSummaries(ClusterSchedulerConfigSummary ... clusterSchedulerConfigSummaries) {
            this.clusterSchedulerConfigSummaries(Arrays.asList(clusterSchedulerConfigSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSchedulerConfigSummaries(Consumer<ClusterSchedulerConfigSummary.Builder> ... clusterSchedulerConfigSummaries) {
            this.clusterSchedulerConfigSummaries(Stream.of(clusterSchedulerConfigSummaries).map(c -> (ClusterSchedulerConfigSummary)((ClusterSchedulerConfigSummary.Builder)ClusterSchedulerConfigSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListClusterSchedulerConfigsResponse build() {
            return new ListClusterSchedulerConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClusterSchedulerConfigsResponse> {
        public Builder clusterSchedulerConfigSummaries(Collection<ClusterSchedulerConfigSummary> var1);

        public Builder clusterSchedulerConfigSummaries(ClusterSchedulerConfigSummary ... var1);

        public Builder clusterSchedulerConfigSummaries(Consumer<ClusterSchedulerConfigSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

