/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ActivationState;
import software.amazon.awssdk.services.sagemaker.model.ComputeQuotaConfig;
import software.amazon.awssdk.services.sagemaker.model.ComputeQuotaTarget;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateComputeQuotaRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateComputeQuotaRequest> {
    private static final SdkField<String> COMPUTE_QUOTA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeQuotaId").getter(UpdateComputeQuotaRequest.getter(UpdateComputeQuotaRequest::computeQuotaId)).setter(UpdateComputeQuotaRequest.setter(Builder::computeQuotaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaId").build()}).build();
    private static final SdkField<Integer> TARGET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetVersion").getter(UpdateComputeQuotaRequest.getter(UpdateComputeQuotaRequest::targetVersion)).setter(UpdateComputeQuotaRequest.setter(Builder::targetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVersion").build()}).build();
    private static final SdkField<ComputeQuotaConfig> COMPUTE_QUOTA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputeQuotaConfig").getter(UpdateComputeQuotaRequest.getter(UpdateComputeQuotaRequest::computeQuotaConfig)).setter(UpdateComputeQuotaRequest.setter(Builder::computeQuotaConfig)).constructor(ComputeQuotaConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaConfig").build()}).build();
    private static final SdkField<ComputeQuotaTarget> COMPUTE_QUOTA_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputeQuotaTarget").getter(UpdateComputeQuotaRequest.getter(UpdateComputeQuotaRequest::computeQuotaTarget)).setter(UpdateComputeQuotaRequest.setter(Builder::computeQuotaTarget)).constructor(ComputeQuotaTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaTarget").build()}).build();
    private static final SdkField<String> ACTIVATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivationState").getter(UpdateComputeQuotaRequest.getter(UpdateComputeQuotaRequest::activationStateAsString)).setter(UpdateComputeQuotaRequest.setter(Builder::activationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationState").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateComputeQuotaRequest.getter(UpdateComputeQuotaRequest::description)).setter(UpdateComputeQuotaRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_QUOTA_ID_FIELD, TARGET_VERSION_FIELD, COMPUTE_QUOTA_CONFIG_FIELD, COMPUTE_QUOTA_TARGET_FIELD, ACTIVATION_STATE_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ComputeQuotaId", COMPUTE_QUOTA_ID_FIELD);
            this.put("TargetVersion", TARGET_VERSION_FIELD);
            this.put("ComputeQuotaConfig", COMPUTE_QUOTA_CONFIG_FIELD);
            this.put("ComputeQuotaTarget", COMPUTE_QUOTA_TARGET_FIELD);
            this.put("ActivationState", ACTIVATION_STATE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
        }
    });
    private final String computeQuotaId;
    private final Integer targetVersion;
    private final ComputeQuotaConfig computeQuotaConfig;
    private final ComputeQuotaTarget computeQuotaTarget;
    private final String activationState;
    private final String description;

    private UpdateComputeQuotaRequest(BuilderImpl builder) {
        super(builder);
        this.computeQuotaId = builder.computeQuotaId;
        this.targetVersion = builder.targetVersion;
        this.computeQuotaConfig = builder.computeQuotaConfig;
        this.computeQuotaTarget = builder.computeQuotaTarget;
        this.activationState = builder.activationState;
        this.description = builder.description;
    }

    public final String computeQuotaId() {
        return this.computeQuotaId;
    }

    public final Integer targetVersion() {
        return this.targetVersion;
    }

    public final ComputeQuotaConfig computeQuotaConfig() {
        return this.computeQuotaConfig;
    }

    public final ComputeQuotaTarget computeQuotaTarget() {
        return this.computeQuotaTarget;
    }

    public final ActivationState activationState() {
        return ActivationState.fromValue(this.activationState);
    }

    public final String activationStateAsString() {
        return this.activationState;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.activationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputeQuotaRequest)) {
            return false;
        }
        UpdateComputeQuotaRequest other = (UpdateComputeQuotaRequest)((Object)obj);
        return Objects.equals(this.computeQuotaId(), other.computeQuotaId()) && Objects.equals(this.targetVersion(), other.targetVersion()) && Objects.equals(this.computeQuotaConfig(), other.computeQuotaConfig()) && Objects.equals(this.computeQuotaTarget(), other.computeQuotaTarget()) && Objects.equals(this.activationStateAsString(), other.activationStateAsString()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateComputeQuotaRequest").add("ComputeQuotaId", (Object)this.computeQuotaId()).add("TargetVersion", (Object)this.targetVersion()).add("ComputeQuotaConfig", (Object)this.computeQuotaConfig()).add("ComputeQuotaTarget", (Object)this.computeQuotaTarget()).add("ActivationState", (Object)this.activationStateAsString()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComputeQuotaId": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaId()));
            }
            case "TargetVersion": {
                return Optional.ofNullable(clazz.cast(this.targetVersion()));
            }
            case "ComputeQuotaConfig": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaConfig()));
            }
            case "ComputeQuotaTarget": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaTarget()));
            }
            case "ActivationState": {
                return Optional.ofNullable(clazz.cast(this.activationStateAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateComputeQuotaRequest, T> g) {
        return obj -> g.apply((UpdateComputeQuotaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String computeQuotaId;
        private Integer targetVersion;
        private ComputeQuotaConfig computeQuotaConfig;
        private ComputeQuotaTarget computeQuotaTarget;
        private String activationState;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputeQuotaRequest model) {
            super(model);
            this.computeQuotaId(model.computeQuotaId);
            this.targetVersion(model.targetVersion);
            this.computeQuotaConfig(model.computeQuotaConfig);
            this.computeQuotaTarget(model.computeQuotaTarget);
            this.activationState(model.activationState);
            this.description(model.description);
        }

        public final String getComputeQuotaId() {
            return this.computeQuotaId;
        }

        public final void setComputeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
        }

        @Override
        public final Builder computeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
            return this;
        }

        public final Integer getTargetVersion() {
            return this.targetVersion;
        }

        public final void setTargetVersion(Integer targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        public final Builder targetVersion(Integer targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final ComputeQuotaConfig.Builder getComputeQuotaConfig() {
            return this.computeQuotaConfig != null ? this.computeQuotaConfig.toBuilder() : null;
        }

        public final void setComputeQuotaConfig(ComputeQuotaConfig.BuilderImpl computeQuotaConfig) {
            this.computeQuotaConfig = computeQuotaConfig != null ? computeQuotaConfig.build() : null;
        }

        @Override
        public final Builder computeQuotaConfig(ComputeQuotaConfig computeQuotaConfig) {
            this.computeQuotaConfig = computeQuotaConfig;
            return this;
        }

        public final ComputeQuotaTarget.Builder getComputeQuotaTarget() {
            return this.computeQuotaTarget != null ? this.computeQuotaTarget.toBuilder() : null;
        }

        public final void setComputeQuotaTarget(ComputeQuotaTarget.BuilderImpl computeQuotaTarget) {
            this.computeQuotaTarget = computeQuotaTarget != null ? computeQuotaTarget.build() : null;
        }

        @Override
        public final Builder computeQuotaTarget(ComputeQuotaTarget computeQuotaTarget) {
            this.computeQuotaTarget = computeQuotaTarget;
            return this;
        }

        public final String getActivationState() {
            return this.activationState;
        }

        public final void setActivationState(String activationState) {
            this.activationState = activationState;
        }

        @Override
        public final Builder activationState(String activationState) {
            this.activationState = activationState;
            return this;
        }

        @Override
        public final Builder activationState(ActivationState activationState) {
            this.activationState(activationState == null ? null : activationState.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateComputeQuotaRequest build() {
            return new UpdateComputeQuotaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateComputeQuotaRequest> {
        public Builder computeQuotaId(String var1);

        public Builder targetVersion(Integer var1);

        public Builder computeQuotaConfig(ComputeQuotaConfig var1);

        default public Builder computeQuotaConfig(Consumer<ComputeQuotaConfig.Builder> computeQuotaConfig) {
            return this.computeQuotaConfig((ComputeQuotaConfig)((ComputeQuotaConfig.Builder)ComputeQuotaConfig.builder().applyMutation(computeQuotaConfig)).build());
        }

        public Builder computeQuotaTarget(ComputeQuotaTarget var1);

        default public Builder computeQuotaTarget(Consumer<ComputeQuotaTarget.Builder> computeQuotaTarget) {
            return this.computeQuotaTarget((ComputeQuotaTarget)((ComputeQuotaTarget.Builder)ComputeQuotaTarget.builder().applyMutation(computeQuotaTarget)).build());
        }

        public Builder activationState(String var1);

        public Builder activationState(ActivationState var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

