/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlgorithmSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlgorithmSummary> {
    private static final SdkField<String> ALGORITHM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmName").getter(AlgorithmSummary.getter(AlgorithmSummary::algorithmName)).setter(AlgorithmSummary.setter(Builder::algorithmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmName").build()}).build();
    private static final SdkField<String> ALGORITHM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmArn").getter(AlgorithmSummary.getter(AlgorithmSummary::algorithmArn)).setter(AlgorithmSummary.setter(Builder::algorithmArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmArn").build()}).build();
    private static final SdkField<String> ALGORITHM_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmDescription").getter(AlgorithmSummary.getter(AlgorithmSummary::algorithmDescription)).setter(AlgorithmSummary.setter(Builder::algorithmDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmDescription").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(AlgorithmSummary.getter(AlgorithmSummary::creationTime)).setter(AlgorithmSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> ALGORITHM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmStatus").getter(AlgorithmSummary.getter(AlgorithmSummary::algorithmStatusAsString)).setter(AlgorithmSummary.setter(Builder::algorithmStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_NAME_FIELD, ALGORITHM_ARN_FIELD, ALGORITHM_DESCRIPTION_FIELD, CREATION_TIME_FIELD, ALGORITHM_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AlgorithmName", ALGORITHM_NAME_FIELD);
            this.put("AlgorithmArn", ALGORITHM_ARN_FIELD);
            this.put("AlgorithmDescription", ALGORITHM_DESCRIPTION_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("AlgorithmStatus", ALGORITHM_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String algorithmName;
    private final String algorithmArn;
    private final String algorithmDescription;
    private final Instant creationTime;
    private final String algorithmStatus;

    private AlgorithmSummary(BuilderImpl builder) {
        this.algorithmName = builder.algorithmName;
        this.algorithmArn = builder.algorithmArn;
        this.algorithmDescription = builder.algorithmDescription;
        this.creationTime = builder.creationTime;
        this.algorithmStatus = builder.algorithmStatus;
    }

    public final String algorithmName() {
        return this.algorithmName;
    }

    public final String algorithmArn() {
        return this.algorithmArn;
    }

    public final String algorithmDescription() {
        return this.algorithmDescription;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final AlgorithmStatus algorithmStatus() {
        return AlgorithmStatus.fromValue(this.algorithmStatus);
    }

    public final String algorithmStatusAsString() {
        return this.algorithmStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmSummary)) {
            return false;
        }
        AlgorithmSummary other = (AlgorithmSummary)obj;
        return Objects.equals(this.algorithmName(), other.algorithmName()) && Objects.equals(this.algorithmArn(), other.algorithmArn()) && Objects.equals(this.algorithmDescription(), other.algorithmDescription()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.algorithmStatusAsString(), other.algorithmStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AlgorithmSummary").add("AlgorithmName", (Object)this.algorithmName()).add("AlgorithmArn", (Object)this.algorithmArn()).add("AlgorithmDescription", (Object)this.algorithmDescription()).add("CreationTime", (Object)this.creationTime()).add("AlgorithmStatus", (Object)this.algorithmStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlgorithmName": {
                return Optional.ofNullable(clazz.cast(this.algorithmName()));
            }
            case "AlgorithmArn": {
                return Optional.ofNullable(clazz.cast(this.algorithmArn()));
            }
            case "AlgorithmDescription": {
                return Optional.ofNullable(clazz.cast(this.algorithmDescription()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "AlgorithmStatus": {
                return Optional.ofNullable(clazz.cast(this.algorithmStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AlgorithmSummary, T> g) {
        return obj -> g.apply((AlgorithmSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithmName;
        private String algorithmArn;
        private String algorithmDescription;
        private Instant creationTime;
        private String algorithmStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmSummary model) {
            this.algorithmName(model.algorithmName);
            this.algorithmArn(model.algorithmArn);
            this.algorithmDescription(model.algorithmDescription);
            this.creationTime(model.creationTime);
            this.algorithmStatus(model.algorithmStatus);
        }

        public final String getAlgorithmName() {
            return this.algorithmName;
        }

        public final void setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        public final Builder algorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        public final String getAlgorithmArn() {
            return this.algorithmArn;
        }

        public final void setAlgorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
        }

        @Override
        public final Builder algorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
            return this;
        }

        public final String getAlgorithmDescription() {
            return this.algorithmDescription;
        }

        public final void setAlgorithmDescription(String algorithmDescription) {
            this.algorithmDescription = algorithmDescription;
        }

        @Override
        public final Builder algorithmDescription(String algorithmDescription) {
            this.algorithmDescription = algorithmDescription;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getAlgorithmStatus() {
            return this.algorithmStatus;
        }

        public final void setAlgorithmStatus(String algorithmStatus) {
            this.algorithmStatus = algorithmStatus;
        }

        @Override
        public final Builder algorithmStatus(String algorithmStatus) {
            this.algorithmStatus = algorithmStatus;
            return this;
        }

        @Override
        public final Builder algorithmStatus(AlgorithmStatus algorithmStatus) {
            this.algorithmStatus(algorithmStatus == null ? null : algorithmStatus.toString());
            return this;
        }

        public AlgorithmSummary build() {
            return new AlgorithmSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlgorithmSummary> {
        public Builder algorithmName(String var1);

        public Builder algorithmArn(String var1);

        public Builder algorithmDescription(String var1);

        public Builder creationTime(Instant var1);

        public Builder algorithmStatus(String var1);

        public Builder algorithmStatus(AlgorithmStatus var1);
    }
}

