/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClarifyShapBaselineConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClarifyShapBaselineConfig> {
    private static final SdkField<String> MIME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MimeType").getter(ClarifyShapBaselineConfig.getter(ClarifyShapBaselineConfig::mimeType)).setter(ClarifyShapBaselineConfig.setter(Builder::mimeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MimeType").build()}).build();
    private static final SdkField<String> SHAP_BASELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShapBaseline").getter(ClarifyShapBaselineConfig.getter(ClarifyShapBaselineConfig::shapBaseline)).setter(ClarifyShapBaselineConfig.setter(Builder::shapBaseline)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShapBaseline").build()}).build();
    private static final SdkField<String> SHAP_BASELINE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShapBaselineUri").getter(ClarifyShapBaselineConfig.getter(ClarifyShapBaselineConfig::shapBaselineUri)).setter(ClarifyShapBaselineConfig.setter(Builder::shapBaselineUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShapBaselineUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIME_TYPE_FIELD, SHAP_BASELINE_FIELD, SHAP_BASELINE_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MimeType", MIME_TYPE_FIELD);
            this.put("ShapBaseline", SHAP_BASELINE_FIELD);
            this.put("ShapBaselineUri", SHAP_BASELINE_URI_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String mimeType;
    private final String shapBaseline;
    private final String shapBaselineUri;

    private ClarifyShapBaselineConfig(BuilderImpl builder) {
        this.mimeType = builder.mimeType;
        this.shapBaseline = builder.shapBaseline;
        this.shapBaselineUri = builder.shapBaselineUri;
    }

    public final String mimeType() {
        return this.mimeType;
    }

    public final String shapBaseline() {
        return this.shapBaseline;
    }

    public final String shapBaselineUri() {
        return this.shapBaselineUri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mimeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.shapBaseline());
        hashCode = 31 * hashCode + Objects.hashCode(this.shapBaselineUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClarifyShapBaselineConfig)) {
            return false;
        }
        ClarifyShapBaselineConfig other = (ClarifyShapBaselineConfig)obj;
        return Objects.equals(this.mimeType(), other.mimeType()) && Objects.equals(this.shapBaseline(), other.shapBaseline()) && Objects.equals(this.shapBaselineUri(), other.shapBaselineUri());
    }

    public final String toString() {
        return ToString.builder((String)"ClarifyShapBaselineConfig").add("MimeType", (Object)this.mimeType()).add("ShapBaseline", (Object)this.shapBaseline()).add("ShapBaselineUri", (Object)this.shapBaselineUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MimeType": {
                return Optional.ofNullable(clazz.cast(this.mimeType()));
            }
            case "ShapBaseline": {
                return Optional.ofNullable(clazz.cast(this.shapBaseline()));
            }
            case "ShapBaselineUri": {
                return Optional.ofNullable(clazz.cast(this.shapBaselineUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClarifyShapBaselineConfig, T> g) {
        return obj -> g.apply((ClarifyShapBaselineConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mimeType;
        private String shapBaseline;
        private String shapBaselineUri;

        private BuilderImpl() {
        }

        private BuilderImpl(ClarifyShapBaselineConfig model) {
            this.mimeType(model.mimeType);
            this.shapBaseline(model.shapBaseline);
            this.shapBaselineUri(model.shapBaselineUri);
        }

        public final String getMimeType() {
            return this.mimeType;
        }

        public final void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public final Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public final String getShapBaseline() {
            return this.shapBaseline;
        }

        public final void setShapBaseline(String shapBaseline) {
            this.shapBaseline = shapBaseline;
        }

        @Override
        public final Builder shapBaseline(String shapBaseline) {
            this.shapBaseline = shapBaseline;
            return this;
        }

        public final String getShapBaselineUri() {
            return this.shapBaselineUri;
        }

        public final void setShapBaselineUri(String shapBaselineUri) {
            this.shapBaselineUri = shapBaselineUri;
        }

        @Override
        public final Builder shapBaselineUri(String shapBaselineUri) {
            this.shapBaselineUri = shapBaselineUri;
            return this;
        }

        public ClarifyShapBaselineConfig build() {
            return new ClarifyShapBaselineConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClarifyShapBaselineConfig> {
        public Builder mimeType(String var1);

        public Builder shapBaseline(String var1);

        public Builder shapBaselineUri(String var1);
    }
}

