/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetadataProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetadataProperties> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommitId").getter(MetadataProperties.getter(MetadataProperties::commitId)).setter(MetadataProperties.setter(Builder::commitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitId").build()}).build();
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Repository").getter(MetadataProperties.getter(MetadataProperties::repository)).setter(MetadataProperties.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Repository").build()}).build();
    private static final SdkField<String> GENERATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedBy").getter(MetadataProperties.getter(MetadataProperties::generatedBy)).setter(MetadataProperties.setter(Builder::generatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedBy").build()}).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectId").getter(MetadataProperties.getter(MetadataProperties::projectId)).setter(MetadataProperties.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_ID_FIELD, REPOSITORY_FIELD, GENERATED_BY_FIELD, PROJECT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CommitId", COMMIT_ID_FIELD);
            this.put("Repository", REPOSITORY_FIELD);
            this.put("GeneratedBy", GENERATED_BY_FIELD);
            this.put("ProjectId", PROJECT_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String commitId;
    private final String repository;
    private final String generatedBy;
    private final String projectId;

    private MetadataProperties(BuilderImpl builder) {
        this.commitId = builder.commitId;
        this.repository = builder.repository;
        this.generatedBy = builder.generatedBy;
        this.projectId = builder.projectId;
    }

    public final String commitId() {
        return this.commitId;
    }

    public final String repository() {
        return this.repository;
    }

    public final String generatedBy() {
        return this.generatedBy;
    }

    public final String projectId() {
        return this.projectId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataProperties)) {
            return false;
        }
        MetadataProperties other = (MetadataProperties)obj;
        return Objects.equals(this.commitId(), other.commitId()) && Objects.equals(this.repository(), other.repository()) && Objects.equals(this.generatedBy(), other.generatedBy()) && Objects.equals(this.projectId(), other.projectId());
    }

    public final String toString() {
        return ToString.builder((String)"MetadataProperties").add("CommitId", (Object)this.commitId()).add("Repository", (Object)this.repository()).add("GeneratedBy", (Object)this.generatedBy()).add("ProjectId", (Object)this.projectId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommitId": {
                return Optional.ofNullable(clazz.cast(this.commitId()));
            }
            case "Repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "GeneratedBy": {
                return Optional.ofNullable(clazz.cast(this.generatedBy()));
            }
            case "ProjectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MetadataProperties, T> g) {
        return obj -> g.apply((MetadataProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String commitId;
        private String repository;
        private String generatedBy;
        private String projectId;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataProperties model) {
            this.commitId(model.commitId);
            this.repository(model.repository);
            this.generatedBy(model.generatedBy);
            this.projectId(model.projectId);
        }

        public final String getCommitId() {
            return this.commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final String getRepository() {
            return this.repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getGeneratedBy() {
            return this.generatedBy;
        }

        public final void setGeneratedBy(String generatedBy) {
            this.generatedBy = generatedBy;
        }

        @Override
        public final Builder generatedBy(String generatedBy) {
            this.generatedBy = generatedBy;
            return this;
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public MetadataProperties build() {
            return new MetadataProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetadataProperties> {
        public Builder commitId(String var1);

        public Builder repository(String var1);

        public Builder generatedBy(String var1);

        public Builder projectId(String var1);
    }
}

