/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CustomImage;
import software.amazon.awssdk.services.sagemaker.model.CustomImagesCopier;
import software.amazon.awssdk.services.sagemaker.model.LifecycleConfigArnsCopier;
import software.amazon.awssdk.services.sagemaker.model.ResourceSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KernelGatewayAppSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KernelGatewayAppSettings> {
    private static final SdkField<ResourceSpec> DEFAULT_RESOURCE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultResourceSpec").getter(KernelGatewayAppSettings.getter(KernelGatewayAppSettings::defaultResourceSpec)).setter(KernelGatewayAppSettings.setter(Builder::defaultResourceSpec)).constructor(ResourceSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResourceSpec").build()}).build();
    private static final SdkField<List<CustomImage>> CUSTOM_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomImages").getter(KernelGatewayAppSettings.getter(KernelGatewayAppSettings::customImages)).setter(KernelGatewayAppSettings.setter(Builder::customImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomImages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LIFECYCLE_CONFIG_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LifecycleConfigArns").getter(KernelGatewayAppSettings.getter(KernelGatewayAppSettings::lifecycleConfigArns)).setter(KernelGatewayAppSettings.setter(Builder::lifecycleConfigArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleConfigArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_RESOURCE_SPEC_FIELD, CUSTOM_IMAGES_FIELD, LIFECYCLE_CONFIG_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DefaultResourceSpec", DEFAULT_RESOURCE_SPEC_FIELD);
            this.put("CustomImages", CUSTOM_IMAGES_FIELD);
            this.put("LifecycleConfigArns", LIFECYCLE_CONFIG_ARNS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ResourceSpec defaultResourceSpec;
    private final List<CustomImage> customImages;
    private final List<String> lifecycleConfigArns;

    private KernelGatewayAppSettings(BuilderImpl builder) {
        this.defaultResourceSpec = builder.defaultResourceSpec;
        this.customImages = builder.customImages;
        this.lifecycleConfigArns = builder.lifecycleConfigArns;
    }

    public final ResourceSpec defaultResourceSpec() {
        return this.defaultResourceSpec;
    }

    public final boolean hasCustomImages() {
        return this.customImages != null && !(this.customImages instanceof SdkAutoConstructList);
    }

    public final List<CustomImage> customImages() {
        return this.customImages;
    }

    public final boolean hasLifecycleConfigArns() {
        return this.lifecycleConfigArns != null && !(this.lifecycleConfigArns instanceof SdkAutoConstructList);
    }

    public final List<String> lifecycleConfigArns() {
        return this.lifecycleConfigArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResourceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomImages() ? this.customImages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifecycleConfigArns() ? this.lifecycleConfigArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KernelGatewayAppSettings)) {
            return false;
        }
        KernelGatewayAppSettings other = (KernelGatewayAppSettings)obj;
        return Objects.equals(this.defaultResourceSpec(), other.defaultResourceSpec()) && this.hasCustomImages() == other.hasCustomImages() && Objects.equals(this.customImages(), other.customImages()) && this.hasLifecycleConfigArns() == other.hasLifecycleConfigArns() && Objects.equals(this.lifecycleConfigArns(), other.lifecycleConfigArns());
    }

    public final String toString() {
        return ToString.builder((String)"KernelGatewayAppSettings").add("DefaultResourceSpec", (Object)this.defaultResourceSpec()).add("CustomImages", this.hasCustomImages() ? this.customImages() : null).add("LifecycleConfigArns", this.hasLifecycleConfigArns() ? this.lifecycleConfigArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultResourceSpec": {
                return Optional.ofNullable(clazz.cast(this.defaultResourceSpec()));
            }
            case "CustomImages": {
                return Optional.ofNullable(clazz.cast(this.customImages()));
            }
            case "LifecycleConfigArns": {
                return Optional.ofNullable(clazz.cast(this.lifecycleConfigArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KernelGatewayAppSettings, T> g) {
        return obj -> g.apply((KernelGatewayAppSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceSpec defaultResourceSpec;
        private List<CustomImage> customImages = DefaultSdkAutoConstructList.getInstance();
        private List<String> lifecycleConfigArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KernelGatewayAppSettings model) {
            this.defaultResourceSpec(model.defaultResourceSpec);
            this.customImages(model.customImages);
            this.lifecycleConfigArns(model.lifecycleConfigArns);
        }

        public final ResourceSpec.Builder getDefaultResourceSpec() {
            return this.defaultResourceSpec != null ? this.defaultResourceSpec.toBuilder() : null;
        }

        public final void setDefaultResourceSpec(ResourceSpec.BuilderImpl defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec != null ? defaultResourceSpec.build() : null;
        }

        @Override
        public final Builder defaultResourceSpec(ResourceSpec defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec;
            return this;
        }

        public final List<CustomImage.Builder> getCustomImages() {
            List<CustomImage.Builder> result = CustomImagesCopier.copyToBuilder(this.customImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomImages(Collection<CustomImage.BuilderImpl> customImages) {
            this.customImages = CustomImagesCopier.copyFromBuilder(customImages);
        }

        @Override
        public final Builder customImages(Collection<CustomImage> customImages) {
            this.customImages = CustomImagesCopier.copy(customImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customImages(CustomImage ... customImages) {
            this.customImages(Arrays.asList(customImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customImages(Consumer<CustomImage.Builder> ... customImages) {
            this.customImages(Stream.of(customImages).map(c -> (CustomImage)((CustomImage.Builder)CustomImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getLifecycleConfigArns() {
            if (this.lifecycleConfigArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lifecycleConfigArns;
        }

        public final void setLifecycleConfigArns(Collection<String> lifecycleConfigArns) {
            this.lifecycleConfigArns = LifecycleConfigArnsCopier.copy(lifecycleConfigArns);
        }

        @Override
        public final Builder lifecycleConfigArns(Collection<String> lifecycleConfigArns) {
            this.lifecycleConfigArns = LifecycleConfigArnsCopier.copy(lifecycleConfigArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleConfigArns(String ... lifecycleConfigArns) {
            this.lifecycleConfigArns(Arrays.asList(lifecycleConfigArns));
            return this;
        }

        public KernelGatewayAppSettings build() {
            return new KernelGatewayAppSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KernelGatewayAppSettings> {
        public Builder defaultResourceSpec(ResourceSpec var1);

        default public Builder defaultResourceSpec(Consumer<ResourceSpec.Builder> defaultResourceSpec) {
            return this.defaultResourceSpec((ResourceSpec)((ResourceSpec.Builder)ResourceSpec.builder().applyMutation(defaultResourceSpec)).build());
        }

        public Builder customImages(Collection<CustomImage> var1);

        public Builder customImages(CustomImage ... var1);

        public Builder customImages(Consumer<CustomImage.Builder> ... var1);

        public Builder lifecycleConfigArns(Collection<String> var1);

        public Builder lifecycleConfigArns(String ... var1);
    }
}

