/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SpaceStatus {
    DELETING("Deleting"),
    FAILED("Failed"),
    IN_SERVICE("InService"),
    PENDING("Pending"),
    UPDATING("Updating"),
    UPDATE_FAILED("Update_Failed"),
    DELETE_FAILED("Delete_Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SpaceStatus> VALUE_MAP;
    private final String value;

    private SpaceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SpaceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SpaceStatus> knownValues() {
        EnumSet<SpaceStatus> knownValues = EnumSet.allOf(SpaceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SpaceStatus.class, SpaceStatus::toString);
    }
}

