/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CollectionConfig;
import software.amazon.awssdk.services.sagemaker.model.CollectionType;
import software.amazon.awssdk.services.sagemaker.model.FeatureType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FeatureDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FeatureDefinition> {
    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureName").getter(FeatureDefinition.getter(FeatureDefinition::featureName)).setter(FeatureDefinition.setter(Builder::featureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureName").build()}).build();
    private static final SdkField<String> FEATURE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureType").getter(FeatureDefinition.getter(FeatureDefinition::featureTypeAsString)).setter(FeatureDefinition.setter(Builder::featureType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureType").build()}).build();
    private static final SdkField<String> COLLECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionType").getter(FeatureDefinition.getter(FeatureDefinition::collectionTypeAsString)).setter(FeatureDefinition.setter(Builder::collectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionType").build()}).build();
    private static final SdkField<CollectionConfig> COLLECTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CollectionConfig").getter(FeatureDefinition.getter(FeatureDefinition::collectionConfig)).setter(FeatureDefinition.setter(Builder::collectionConfig)).constructor(CollectionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_NAME_FIELD, FEATURE_TYPE_FIELD, COLLECTION_TYPE_FIELD, COLLECTION_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FeatureName", FEATURE_NAME_FIELD);
            this.put("FeatureType", FEATURE_TYPE_FIELD);
            this.put("CollectionType", COLLECTION_TYPE_FIELD);
            this.put("CollectionConfig", COLLECTION_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String featureName;
    private final String featureType;
    private final String collectionType;
    private final CollectionConfig collectionConfig;

    private FeatureDefinition(BuilderImpl builder) {
        this.featureName = builder.featureName;
        this.featureType = builder.featureType;
        this.collectionType = builder.collectionType;
        this.collectionConfig = builder.collectionConfig;
    }

    public final String featureName() {
        return this.featureName;
    }

    public final FeatureType featureType() {
        return FeatureType.fromValue(this.featureType);
    }

    public final String featureTypeAsString() {
        return this.featureType;
    }

    public final CollectionType collectionType() {
        return CollectionType.fromValue(this.collectionType);
    }

    public final String collectionTypeAsString() {
        return this.collectionType;
    }

    public final CollectionConfig collectionConfig() {
        return this.collectionConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeatureDefinition)) {
            return false;
        }
        FeatureDefinition other = (FeatureDefinition)obj;
        return Objects.equals(this.featureName(), other.featureName()) && Objects.equals(this.featureTypeAsString(), other.featureTypeAsString()) && Objects.equals(this.collectionTypeAsString(), other.collectionTypeAsString()) && Objects.equals(this.collectionConfig(), other.collectionConfig());
    }

    public final String toString() {
        return ToString.builder((String)"FeatureDefinition").add("FeatureName", (Object)this.featureName()).add("FeatureType", (Object)this.featureTypeAsString()).add("CollectionType", (Object)this.collectionTypeAsString()).add("CollectionConfig", (Object)this.collectionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureName": {
                return Optional.ofNullable(clazz.cast(this.featureName()));
            }
            case "FeatureType": {
                return Optional.ofNullable(clazz.cast(this.featureTypeAsString()));
            }
            case "CollectionType": {
                return Optional.ofNullable(clazz.cast(this.collectionTypeAsString()));
            }
            case "CollectionConfig": {
                return Optional.ofNullable(clazz.cast(this.collectionConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FeatureDefinition, T> g) {
        return obj -> g.apply((FeatureDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String featureName;
        private String featureType;
        private String collectionType;
        private CollectionConfig collectionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(FeatureDefinition model) {
            this.featureName(model.featureName);
            this.featureType(model.featureType);
            this.collectionType(model.collectionType);
            this.collectionConfig(model.collectionConfig);
        }

        public final String getFeatureName() {
            return this.featureName;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        public final String getFeatureType() {
            return this.featureType;
        }

        public final void setFeatureType(String featureType) {
            this.featureType = featureType;
        }

        @Override
        public final Builder featureType(String featureType) {
            this.featureType = featureType;
            return this;
        }

        @Override
        public final Builder featureType(FeatureType featureType) {
            this.featureType(featureType == null ? null : featureType.toString());
            return this;
        }

        public final String getCollectionType() {
            return this.collectionType;
        }

        public final void setCollectionType(String collectionType) {
            this.collectionType = collectionType;
        }

        @Override
        public final Builder collectionType(String collectionType) {
            this.collectionType = collectionType;
            return this;
        }

        @Override
        public final Builder collectionType(CollectionType collectionType) {
            this.collectionType(collectionType == null ? null : collectionType.toString());
            return this;
        }

        public final CollectionConfig.Builder getCollectionConfig() {
            return this.collectionConfig != null ? this.collectionConfig.toBuilder() : null;
        }

        public final void setCollectionConfig(CollectionConfig.BuilderImpl collectionConfig) {
            this.collectionConfig = collectionConfig != null ? collectionConfig.build() : null;
        }

        @Override
        public final Builder collectionConfig(CollectionConfig collectionConfig) {
            this.collectionConfig = collectionConfig;
            return this;
        }

        public FeatureDefinition build() {
            return new FeatureDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FeatureDefinition> {
        public Builder featureName(String var1);

        public Builder featureType(String var1);

        public Builder featureType(FeatureType var1);

        public Builder collectionType(String var1);

        public Builder collectionType(CollectionType var1);

        public Builder collectionConfig(CollectionConfig var1);

        default public Builder collectionConfig(Consumer<CollectionConfig.Builder> collectionConfig) {
            return this.collectionConfig((CollectionConfig)((CollectionConfig.Builder)CollectionConfig.builder().applyMutation(collectionConfig)).build());
        }
    }
}

