/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SelectedStep;
import software.amazon.awssdk.services.sagemaker.model.SelectedStepListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelectiveExecutionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SelectiveExecutionConfig> {
    private static final SdkField<String> SOURCE_PIPELINE_EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePipelineExecutionArn").getter(SelectiveExecutionConfig.getter(SelectiveExecutionConfig::sourcePipelineExecutionArn)).setter(SelectiveExecutionConfig.setter(Builder::sourcePipelineExecutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePipelineExecutionArn").build()}).build();
    private static final SdkField<List<SelectedStep>> SELECTED_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedSteps").getter(SelectiveExecutionConfig.getter(SelectiveExecutionConfig::selectedSteps)).setter(SelectiveExecutionConfig.setter(Builder::selectedSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SelectedStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_PIPELINE_EXECUTION_ARN_FIELD, SELECTED_STEPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SourcePipelineExecutionArn", SOURCE_PIPELINE_EXECUTION_ARN_FIELD);
            this.put("SelectedSteps", SELECTED_STEPS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String sourcePipelineExecutionArn;
    private final List<SelectedStep> selectedSteps;

    private SelectiveExecutionConfig(BuilderImpl builder) {
        this.sourcePipelineExecutionArn = builder.sourcePipelineExecutionArn;
        this.selectedSteps = builder.selectedSteps;
    }

    public final String sourcePipelineExecutionArn() {
        return this.sourcePipelineExecutionArn;
    }

    public final boolean hasSelectedSteps() {
        return this.selectedSteps != null && !(this.selectedSteps instanceof SdkAutoConstructList);
    }

    public final List<SelectedStep> selectedSteps() {
        return this.selectedSteps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePipelineExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedSteps() ? this.selectedSteps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectiveExecutionConfig)) {
            return false;
        }
        SelectiveExecutionConfig other = (SelectiveExecutionConfig)obj;
        return Objects.equals(this.sourcePipelineExecutionArn(), other.sourcePipelineExecutionArn()) && this.hasSelectedSteps() == other.hasSelectedSteps() && Objects.equals(this.selectedSteps(), other.selectedSteps());
    }

    public final String toString() {
        return ToString.builder((String)"SelectiveExecutionConfig").add("SourcePipelineExecutionArn", (Object)this.sourcePipelineExecutionArn()).add("SelectedSteps", this.hasSelectedSteps() ? this.selectedSteps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourcePipelineExecutionArn": {
                return Optional.ofNullable(clazz.cast(this.sourcePipelineExecutionArn()));
            }
            case "SelectedSteps": {
                return Optional.ofNullable(clazz.cast(this.selectedSteps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SelectiveExecutionConfig, T> g) {
        return obj -> g.apply((SelectiveExecutionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourcePipelineExecutionArn;
        private List<SelectedStep> selectedSteps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SelectiveExecutionConfig model) {
            this.sourcePipelineExecutionArn(model.sourcePipelineExecutionArn);
            this.selectedSteps(model.selectedSteps);
        }

        public final String getSourcePipelineExecutionArn() {
            return this.sourcePipelineExecutionArn;
        }

        public final void setSourcePipelineExecutionArn(String sourcePipelineExecutionArn) {
            this.sourcePipelineExecutionArn = sourcePipelineExecutionArn;
        }

        @Override
        public final Builder sourcePipelineExecutionArn(String sourcePipelineExecutionArn) {
            this.sourcePipelineExecutionArn = sourcePipelineExecutionArn;
            return this;
        }

        public final List<SelectedStep.Builder> getSelectedSteps() {
            List<SelectedStep.Builder> result = SelectedStepListCopier.copyToBuilder(this.selectedSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectedSteps(Collection<SelectedStep.BuilderImpl> selectedSteps) {
            this.selectedSteps = SelectedStepListCopier.copyFromBuilder(selectedSteps);
        }

        @Override
        public final Builder selectedSteps(Collection<SelectedStep> selectedSteps) {
            this.selectedSteps = SelectedStepListCopier.copy(selectedSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedSteps(SelectedStep ... selectedSteps) {
            this.selectedSteps(Arrays.asList(selectedSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedSteps(Consumer<SelectedStep.Builder> ... selectedSteps) {
            this.selectedSteps(Stream.of(selectedSteps).map(c -> (SelectedStep)((SelectedStep.Builder)SelectedStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SelectiveExecutionConfig build() {
            return new SelectiveExecutionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SelectiveExecutionConfig> {
        public Builder sourcePipelineExecutionArn(String var1);

        public Builder selectedSteps(Collection<SelectedStep> var1);

        public Builder selectedSteps(SelectedStep ... var1);

        public Builder selectedSteps(Consumer<SelectedStep.Builder> ... var1);
    }
}

