/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClarifyCheckStepMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClarifyCheckStepMetadata> {
    private static final SdkField<String> CHECK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CheckType").getter(ClarifyCheckStepMetadata.getter(ClarifyCheckStepMetadata::checkType)).setter(ClarifyCheckStepMetadata.setter(Builder::checkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckType").build()}).build();
    private static final SdkField<String> BASELINE_USED_FOR_DRIFT_CHECK_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaselineUsedForDriftCheckConstraints").getter(ClarifyCheckStepMetadata.getter(ClarifyCheckStepMetadata::baselineUsedForDriftCheckConstraints)).setter(ClarifyCheckStepMetadata.setter(Builder::baselineUsedForDriftCheckConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineUsedForDriftCheckConstraints").build()}).build();
    private static final SdkField<String> CALCULATED_BASELINE_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatedBaselineConstraints").getter(ClarifyCheckStepMetadata.getter(ClarifyCheckStepMetadata::calculatedBaselineConstraints)).setter(ClarifyCheckStepMetadata.setter(Builder::calculatedBaselineConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedBaselineConstraints").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupName").getter(ClarifyCheckStepMetadata.getter(ClarifyCheckStepMetadata::modelPackageGroupName)).setter(ClarifyCheckStepMetadata.setter(Builder::modelPackageGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build()}).build();
    private static final SdkField<String> VIOLATION_REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViolationReport").getter(ClarifyCheckStepMetadata.getter(ClarifyCheckStepMetadata::violationReport)).setter(ClarifyCheckStepMetadata.setter(Builder::violationReport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationReport").build()}).build();
    private static final SdkField<String> CHECK_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CheckJobArn").getter(ClarifyCheckStepMetadata.getter(ClarifyCheckStepMetadata::checkJobArn)).setter(ClarifyCheckStepMetadata.setter(Builder::checkJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckJobArn").build()}).build();
    private static final SdkField<Boolean> SKIP_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SkipCheck").getter(ClarifyCheckStepMetadata.getter(ClarifyCheckStepMetadata::skipCheck)).setter(ClarifyCheckStepMetadata.setter(Builder::skipCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipCheck").build()}).build();
    private static final SdkField<Boolean> REGISTER_NEW_BASELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RegisterNewBaseline").getter(ClarifyCheckStepMetadata.getter(ClarifyCheckStepMetadata::registerNewBaseline)).setter(ClarifyCheckStepMetadata.setter(Builder::registerNewBaseline)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisterNewBaseline").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_TYPE_FIELD, BASELINE_USED_FOR_DRIFT_CHECK_CONSTRAINTS_FIELD, CALCULATED_BASELINE_CONSTRAINTS_FIELD, MODEL_PACKAGE_GROUP_NAME_FIELD, VIOLATION_REPORT_FIELD, CHECK_JOB_ARN_FIELD, SKIP_CHECK_FIELD, REGISTER_NEW_BASELINE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CheckType", CHECK_TYPE_FIELD);
            this.put("BaselineUsedForDriftCheckConstraints", BASELINE_USED_FOR_DRIFT_CHECK_CONSTRAINTS_FIELD);
            this.put("CalculatedBaselineConstraints", CALCULATED_BASELINE_CONSTRAINTS_FIELD);
            this.put("ModelPackageGroupName", MODEL_PACKAGE_GROUP_NAME_FIELD);
            this.put("ViolationReport", VIOLATION_REPORT_FIELD);
            this.put("CheckJobArn", CHECK_JOB_ARN_FIELD);
            this.put("SkipCheck", SKIP_CHECK_FIELD);
            this.put("RegisterNewBaseline", REGISTER_NEW_BASELINE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String checkType;
    private final String baselineUsedForDriftCheckConstraints;
    private final String calculatedBaselineConstraints;
    private final String modelPackageGroupName;
    private final String violationReport;
    private final String checkJobArn;
    private final Boolean skipCheck;
    private final Boolean registerNewBaseline;

    private ClarifyCheckStepMetadata(BuilderImpl builder) {
        this.checkType = builder.checkType;
        this.baselineUsedForDriftCheckConstraints = builder.baselineUsedForDriftCheckConstraints;
        this.calculatedBaselineConstraints = builder.calculatedBaselineConstraints;
        this.modelPackageGroupName = builder.modelPackageGroupName;
        this.violationReport = builder.violationReport;
        this.checkJobArn = builder.checkJobArn;
        this.skipCheck = builder.skipCheck;
        this.registerNewBaseline = builder.registerNewBaseline;
    }

    public final String checkType() {
        return this.checkType;
    }

    public final String baselineUsedForDriftCheckConstraints() {
        return this.baselineUsedForDriftCheckConstraints;
    }

    public final String calculatedBaselineConstraints() {
        return this.calculatedBaselineConstraints;
    }

    public final String modelPackageGroupName() {
        return this.modelPackageGroupName;
    }

    public final String violationReport() {
        return this.violationReport;
    }

    public final String checkJobArn() {
        return this.checkJobArn;
    }

    public final Boolean skipCheck() {
        return this.skipCheck;
    }

    public final Boolean registerNewBaseline() {
        return this.registerNewBaseline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.checkType());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineUsedForDriftCheckConstraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatedBaselineConstraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.violationReport());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.registerNewBaseline());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClarifyCheckStepMetadata)) {
            return false;
        }
        ClarifyCheckStepMetadata other = (ClarifyCheckStepMetadata)obj;
        return Objects.equals(this.checkType(), other.checkType()) && Objects.equals(this.baselineUsedForDriftCheckConstraints(), other.baselineUsedForDriftCheckConstraints()) && Objects.equals(this.calculatedBaselineConstraints(), other.calculatedBaselineConstraints()) && Objects.equals(this.modelPackageGroupName(), other.modelPackageGroupName()) && Objects.equals(this.violationReport(), other.violationReport()) && Objects.equals(this.checkJobArn(), other.checkJobArn()) && Objects.equals(this.skipCheck(), other.skipCheck()) && Objects.equals(this.registerNewBaseline(), other.registerNewBaseline());
    }

    public final String toString() {
        return ToString.builder((String)"ClarifyCheckStepMetadata").add("CheckType", (Object)this.checkType()).add("BaselineUsedForDriftCheckConstraints", (Object)this.baselineUsedForDriftCheckConstraints()).add("CalculatedBaselineConstraints", (Object)this.calculatedBaselineConstraints()).add("ModelPackageGroupName", (Object)this.modelPackageGroupName()).add("ViolationReport", (Object)this.violationReport()).add("CheckJobArn", (Object)this.checkJobArn()).add("SkipCheck", (Object)this.skipCheck()).add("RegisterNewBaseline", (Object)this.registerNewBaseline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CheckType": {
                return Optional.ofNullable(clazz.cast(this.checkType()));
            }
            case "BaselineUsedForDriftCheckConstraints": {
                return Optional.ofNullable(clazz.cast(this.baselineUsedForDriftCheckConstraints()));
            }
            case "CalculatedBaselineConstraints": {
                return Optional.ofNullable(clazz.cast(this.calculatedBaselineConstraints()));
            }
            case "ModelPackageGroupName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupName()));
            }
            case "ViolationReport": {
                return Optional.ofNullable(clazz.cast(this.violationReport()));
            }
            case "CheckJobArn": {
                return Optional.ofNullable(clazz.cast(this.checkJobArn()));
            }
            case "SkipCheck": {
                return Optional.ofNullable(clazz.cast(this.skipCheck()));
            }
            case "RegisterNewBaseline": {
                return Optional.ofNullable(clazz.cast(this.registerNewBaseline()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClarifyCheckStepMetadata, T> g) {
        return obj -> g.apply((ClarifyCheckStepMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String checkType;
        private String baselineUsedForDriftCheckConstraints;
        private String calculatedBaselineConstraints;
        private String modelPackageGroupName;
        private String violationReport;
        private String checkJobArn;
        private Boolean skipCheck;
        private Boolean registerNewBaseline;

        private BuilderImpl() {
        }

        private BuilderImpl(ClarifyCheckStepMetadata model) {
            this.checkType(model.checkType);
            this.baselineUsedForDriftCheckConstraints(model.baselineUsedForDriftCheckConstraints);
            this.calculatedBaselineConstraints(model.calculatedBaselineConstraints);
            this.modelPackageGroupName(model.modelPackageGroupName);
            this.violationReport(model.violationReport);
            this.checkJobArn(model.checkJobArn);
            this.skipCheck(model.skipCheck);
            this.registerNewBaseline(model.registerNewBaseline);
        }

        public final String getCheckType() {
            return this.checkType;
        }

        public final void setCheckType(String checkType) {
            this.checkType = checkType;
        }

        @Override
        public final Builder checkType(String checkType) {
            this.checkType = checkType;
            return this;
        }

        public final String getBaselineUsedForDriftCheckConstraints() {
            return this.baselineUsedForDriftCheckConstraints;
        }

        public final void setBaselineUsedForDriftCheckConstraints(String baselineUsedForDriftCheckConstraints) {
            this.baselineUsedForDriftCheckConstraints = baselineUsedForDriftCheckConstraints;
        }

        @Override
        public final Builder baselineUsedForDriftCheckConstraints(String baselineUsedForDriftCheckConstraints) {
            this.baselineUsedForDriftCheckConstraints = baselineUsedForDriftCheckConstraints;
            return this;
        }

        public final String getCalculatedBaselineConstraints() {
            return this.calculatedBaselineConstraints;
        }

        public final void setCalculatedBaselineConstraints(String calculatedBaselineConstraints) {
            this.calculatedBaselineConstraints = calculatedBaselineConstraints;
        }

        @Override
        public final Builder calculatedBaselineConstraints(String calculatedBaselineConstraints) {
            this.calculatedBaselineConstraints = calculatedBaselineConstraints;
            return this;
        }

        public final String getModelPackageGroupName() {
            return this.modelPackageGroupName;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        @Override
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public final String getViolationReport() {
            return this.violationReport;
        }

        public final void setViolationReport(String violationReport) {
            this.violationReport = violationReport;
        }

        @Override
        public final Builder violationReport(String violationReport) {
            this.violationReport = violationReport;
            return this;
        }

        public final String getCheckJobArn() {
            return this.checkJobArn;
        }

        public final void setCheckJobArn(String checkJobArn) {
            this.checkJobArn = checkJobArn;
        }

        @Override
        public final Builder checkJobArn(String checkJobArn) {
            this.checkJobArn = checkJobArn;
            return this;
        }

        public final Boolean getSkipCheck() {
            return this.skipCheck;
        }

        public final void setSkipCheck(Boolean skipCheck) {
            this.skipCheck = skipCheck;
        }

        @Override
        public final Builder skipCheck(Boolean skipCheck) {
            this.skipCheck = skipCheck;
            return this;
        }

        public final Boolean getRegisterNewBaseline() {
            return this.registerNewBaseline;
        }

        public final void setRegisterNewBaseline(Boolean registerNewBaseline) {
            this.registerNewBaseline = registerNewBaseline;
        }

        @Override
        public final Builder registerNewBaseline(Boolean registerNewBaseline) {
            this.registerNewBaseline = registerNewBaseline;
            return this;
        }

        public ClarifyCheckStepMetadata build() {
            return new ClarifyCheckStepMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClarifyCheckStepMetadata> {
        public Builder checkType(String var1);

        public Builder baselineUsedForDriftCheckConstraints(String var1);

        public Builder calculatedBaselineConstraints(String var1);

        public Builder modelPackageGroupName(String var1);

        public Builder violationReport(String var1);

        public Builder checkJobArn(String var1);

        public Builder skipCheck(Boolean var1);

        public Builder registerNewBaseline(Boolean var1);
    }
}

