/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AsyncInferenceConfig;
import software.amazon.awssdk.services.sagemaker.model.DataCaptureConfig;
import software.amazon.awssdk.services.sagemaker.model.ExplainerConfig;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariant;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEndpointConfigRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateEndpointConfigRequest> {
    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointConfigName").getter(CreateEndpointConfigRequest.getter(CreateEndpointConfigRequest::endpointConfigName)).setter(CreateEndpointConfigRequest.setter(Builder::endpointConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build()}).build();
    private static final SdkField<List<ProductionVariant>> PRODUCTION_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductionVariants").getter(CreateEndpointConfigRequest.getter(CreateEndpointConfigRequest::productionVariants)).setter(CreateEndpointConfigRequest.setter(Builder::productionVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductionVariant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataCaptureConfig> DATA_CAPTURE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataCaptureConfig").getter(CreateEndpointConfigRequest.getter(CreateEndpointConfigRequest::dataCaptureConfig)).setter(CreateEndpointConfigRequest.setter(Builder::dataCaptureConfig)).constructor(DataCaptureConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCaptureConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateEndpointConfigRequest.getter(CreateEndpointConfigRequest::tags)).setter(CreateEndpointConfigRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateEndpointConfigRequest.getter(CreateEndpointConfigRequest::kmsKeyId)).setter(CreateEndpointConfigRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<AsyncInferenceConfig> ASYNC_INFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AsyncInferenceConfig").getter(CreateEndpointConfigRequest.getter(CreateEndpointConfigRequest::asyncInferenceConfig)).setter(CreateEndpointConfigRequest.setter(Builder::asyncInferenceConfig)).constructor(AsyncInferenceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsyncInferenceConfig").build()}).build();
    private static final SdkField<ExplainerConfig> EXPLAINER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExplainerConfig").getter(CreateEndpointConfigRequest.getter(CreateEndpointConfigRequest::explainerConfig)).setter(CreateEndpointConfigRequest.setter(Builder::explainerConfig)).constructor(ExplainerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainerConfig").build()}).build();
    private static final SdkField<List<ProductionVariant>> SHADOW_PRODUCTION_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ShadowProductionVariants").getter(CreateEndpointConfigRequest.getter(CreateEndpointConfigRequest::shadowProductionVariants)).setter(CreateEndpointConfigRequest.setter(Builder::shadowProductionVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShadowProductionVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductionVariant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(CreateEndpointConfigRequest.getter(CreateEndpointConfigRequest::executionRoleArn)).setter(CreateEndpointConfigRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(CreateEndpointConfigRequest.getter(CreateEndpointConfigRequest::vpcConfig)).setter(CreateEndpointConfigRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableNetworkIsolation").getter(CreateEndpointConfigRequest.getter(CreateEndpointConfigRequest::enableNetworkIsolation)).setter(CreateEndpointConfigRequest.setter(Builder::enableNetworkIsolation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_CONFIG_NAME_FIELD, PRODUCTION_VARIANTS_FIELD, DATA_CAPTURE_CONFIG_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD, ASYNC_INFERENCE_CONFIG_FIELD, EXPLAINER_CONFIG_FIELD, SHADOW_PRODUCTION_VARIANTS_FIELD, EXECUTION_ROLE_ARN_FIELD, VPC_CONFIG_FIELD, ENABLE_NETWORK_ISOLATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EndpointConfigName", ENDPOINT_CONFIG_NAME_FIELD);
            this.put("ProductionVariants", PRODUCTION_VARIANTS_FIELD);
            this.put("DataCaptureConfig", DATA_CAPTURE_CONFIG_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("KmsKeyId", KMS_KEY_ID_FIELD);
            this.put("AsyncInferenceConfig", ASYNC_INFERENCE_CONFIG_FIELD);
            this.put("ExplainerConfig", EXPLAINER_CONFIG_FIELD);
            this.put("ShadowProductionVariants", SHADOW_PRODUCTION_VARIANTS_FIELD);
            this.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
            this.put("VpcConfig", VPC_CONFIG_FIELD);
            this.put("EnableNetworkIsolation", ENABLE_NETWORK_ISOLATION_FIELD);
        }
    });
    private final String endpointConfigName;
    private final List<ProductionVariant> productionVariants;
    private final DataCaptureConfig dataCaptureConfig;
    private final List<Tag> tags;
    private final String kmsKeyId;
    private final AsyncInferenceConfig asyncInferenceConfig;
    private final ExplainerConfig explainerConfig;
    private final List<ProductionVariant> shadowProductionVariants;
    private final String executionRoleArn;
    private final VpcConfig vpcConfig;
    private final Boolean enableNetworkIsolation;

    private CreateEndpointConfigRequest(BuilderImpl builder) {
        super(builder);
        this.endpointConfigName = builder.endpointConfigName;
        this.productionVariants = builder.productionVariants;
        this.dataCaptureConfig = builder.dataCaptureConfig;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.asyncInferenceConfig = builder.asyncInferenceConfig;
        this.explainerConfig = builder.explainerConfig;
        this.shadowProductionVariants = builder.shadowProductionVariants;
        this.executionRoleArn = builder.executionRoleArn;
        this.vpcConfig = builder.vpcConfig;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
    }

    public final String endpointConfigName() {
        return this.endpointConfigName;
    }

    public final boolean hasProductionVariants() {
        return this.productionVariants != null && !(this.productionVariants instanceof SdkAutoConstructList);
    }

    public final List<ProductionVariant> productionVariants() {
        return this.productionVariants;
    }

    public final DataCaptureConfig dataCaptureConfig() {
        return this.dataCaptureConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final AsyncInferenceConfig asyncInferenceConfig() {
        return this.asyncInferenceConfig;
    }

    public final ExplainerConfig explainerConfig() {
        return this.explainerConfig;
    }

    public final boolean hasShadowProductionVariants() {
        return this.shadowProductionVariants != null && !(this.shadowProductionVariants instanceof SdkAutoConstructList);
    }

    public final List<ProductionVariant> shadowProductionVariants() {
        return this.shadowProductionVariants;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final Boolean enableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductionVariants() ? this.productionVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCaptureConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.asyncInferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShadowProductionVariants() ? this.shadowProductionVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableNetworkIsolation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndpointConfigRequest)) {
            return false;
        }
        CreateEndpointConfigRequest other = (CreateEndpointConfigRequest)((Object)obj);
        return Objects.equals(this.endpointConfigName(), other.endpointConfigName()) && this.hasProductionVariants() == other.hasProductionVariants() && Objects.equals(this.productionVariants(), other.productionVariants()) && Objects.equals(this.dataCaptureConfig(), other.dataCaptureConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.asyncInferenceConfig(), other.asyncInferenceConfig()) && Objects.equals(this.explainerConfig(), other.explainerConfig()) && this.hasShadowProductionVariants() == other.hasShadowProductionVariants() && Objects.equals(this.shadowProductionVariants(), other.shadowProductionVariants()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.enableNetworkIsolation(), other.enableNetworkIsolation());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEndpointConfigRequest").add("EndpointConfigName", (Object)this.endpointConfigName()).add("ProductionVariants", this.hasProductionVariants() ? this.productionVariants() : null).add("DataCaptureConfig", (Object)this.dataCaptureConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("KmsKeyId", (Object)this.kmsKeyId()).add("AsyncInferenceConfig", (Object)this.asyncInferenceConfig()).add("ExplainerConfig", (Object)this.explainerConfig()).add("ShadowProductionVariants", this.hasShadowProductionVariants() ? this.shadowProductionVariants() : null).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("VpcConfig", (Object)this.vpcConfig()).add("EnableNetworkIsolation", (Object)this.enableNetworkIsolation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointConfigName": {
                return Optional.ofNullable(clazz.cast(this.endpointConfigName()));
            }
            case "ProductionVariants": {
                return Optional.ofNullable(clazz.cast(this.productionVariants()));
            }
            case "DataCaptureConfig": {
                return Optional.ofNullable(clazz.cast(this.dataCaptureConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "AsyncInferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.asyncInferenceConfig()));
            }
            case "ExplainerConfig": {
                return Optional.ofNullable(clazz.cast(this.explainerConfig()));
            }
            case "ShadowProductionVariants": {
                return Optional.ofNullable(clazz.cast(this.shadowProductionVariants()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "EnableNetworkIsolation": {
                return Optional.ofNullable(clazz.cast(this.enableNetworkIsolation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateEndpointConfigRequest, T> g) {
        return obj -> g.apply((CreateEndpointConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String endpointConfigName;
        private List<ProductionVariant> productionVariants = DefaultSdkAutoConstructList.getInstance();
        private DataCaptureConfig dataCaptureConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;
        private AsyncInferenceConfig asyncInferenceConfig;
        private ExplainerConfig explainerConfig;
        private List<ProductionVariant> shadowProductionVariants = DefaultSdkAutoConstructList.getInstance();
        private String executionRoleArn;
        private VpcConfig vpcConfig;
        private Boolean enableNetworkIsolation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEndpointConfigRequest model) {
            super(model);
            this.endpointConfigName(model.endpointConfigName);
            this.productionVariants(model.productionVariants);
            this.dataCaptureConfig(model.dataCaptureConfig);
            this.tags(model.tags);
            this.kmsKeyId(model.kmsKeyId);
            this.asyncInferenceConfig(model.asyncInferenceConfig);
            this.explainerConfig(model.explainerConfig);
            this.shadowProductionVariants(model.shadowProductionVariants);
            this.executionRoleArn(model.executionRoleArn);
            this.vpcConfig(model.vpcConfig);
            this.enableNetworkIsolation(model.enableNetworkIsolation);
        }

        public final String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final List<ProductionVariant.Builder> getProductionVariants() {
            List<ProductionVariant.Builder> result = ProductionVariantListCopier.copyToBuilder(this.productionVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductionVariants(Collection<ProductionVariant.BuilderImpl> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copyFromBuilder(productionVariants);
        }

        @Override
        public final Builder productionVariants(Collection<ProductionVariant> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copy(productionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(ProductionVariant ... productionVariants) {
            this.productionVariants(Arrays.asList(productionVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(Consumer<ProductionVariant.Builder> ... productionVariants) {
            this.productionVariants(Stream.of(productionVariants).map(c -> (ProductionVariant)((ProductionVariant.Builder)ProductionVariant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataCaptureConfig.Builder getDataCaptureConfig() {
            return this.dataCaptureConfig != null ? this.dataCaptureConfig.toBuilder() : null;
        }

        public final void setDataCaptureConfig(DataCaptureConfig.BuilderImpl dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig != null ? dataCaptureConfig.build() : null;
        }

        @Override
        public final Builder dataCaptureConfig(DataCaptureConfig dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final AsyncInferenceConfig.Builder getAsyncInferenceConfig() {
            return this.asyncInferenceConfig != null ? this.asyncInferenceConfig.toBuilder() : null;
        }

        public final void setAsyncInferenceConfig(AsyncInferenceConfig.BuilderImpl asyncInferenceConfig) {
            this.asyncInferenceConfig = asyncInferenceConfig != null ? asyncInferenceConfig.build() : null;
        }

        @Override
        public final Builder asyncInferenceConfig(AsyncInferenceConfig asyncInferenceConfig) {
            this.asyncInferenceConfig = asyncInferenceConfig;
            return this;
        }

        public final ExplainerConfig.Builder getExplainerConfig() {
            return this.explainerConfig != null ? this.explainerConfig.toBuilder() : null;
        }

        public final void setExplainerConfig(ExplainerConfig.BuilderImpl explainerConfig) {
            this.explainerConfig = explainerConfig != null ? explainerConfig.build() : null;
        }

        @Override
        public final Builder explainerConfig(ExplainerConfig explainerConfig) {
            this.explainerConfig = explainerConfig;
            return this;
        }

        public final List<ProductionVariant.Builder> getShadowProductionVariants() {
            List<ProductionVariant.Builder> result = ProductionVariantListCopier.copyToBuilder(this.shadowProductionVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShadowProductionVariants(Collection<ProductionVariant.BuilderImpl> shadowProductionVariants) {
            this.shadowProductionVariants = ProductionVariantListCopier.copyFromBuilder(shadowProductionVariants);
        }

        @Override
        public final Builder shadowProductionVariants(Collection<ProductionVariant> shadowProductionVariants) {
            this.shadowProductionVariants = ProductionVariantListCopier.copy(shadowProductionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shadowProductionVariants(ProductionVariant ... shadowProductionVariants) {
            this.shadowProductionVariants(Arrays.asList(shadowProductionVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shadowProductionVariants(Consumer<ProductionVariant.Builder> ... shadowProductionVariants) {
            this.shadowProductionVariants(Stream.of(shadowProductionVariants).map(c -> (ProductionVariant)((ProductionVariant.Builder)ProductionVariant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final Boolean getEnableNetworkIsolation() {
            return this.enableNetworkIsolation;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEndpointConfigRequest build() {
            return new CreateEndpointConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEndpointConfigRequest> {
        public Builder endpointConfigName(String var1);

        public Builder productionVariants(Collection<ProductionVariant> var1);

        public Builder productionVariants(ProductionVariant ... var1);

        public Builder productionVariants(Consumer<ProductionVariant.Builder> ... var1);

        public Builder dataCaptureConfig(DataCaptureConfig var1);

        default public Builder dataCaptureConfig(Consumer<DataCaptureConfig.Builder> dataCaptureConfig) {
            return this.dataCaptureConfig((DataCaptureConfig)((DataCaptureConfig.Builder)DataCaptureConfig.builder().applyMutation(dataCaptureConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder kmsKeyId(String var1);

        public Builder asyncInferenceConfig(AsyncInferenceConfig var1);

        default public Builder asyncInferenceConfig(Consumer<AsyncInferenceConfig.Builder> asyncInferenceConfig) {
            return this.asyncInferenceConfig((AsyncInferenceConfig)((AsyncInferenceConfig.Builder)AsyncInferenceConfig.builder().applyMutation(asyncInferenceConfig)).build());
        }

        public Builder explainerConfig(ExplainerConfig var1);

        default public Builder explainerConfig(Consumer<ExplainerConfig.Builder> explainerConfig) {
            return this.explainerConfig((ExplainerConfig)((ExplainerConfig.Builder)ExplainerConfig.builder().applyMutation(explainerConfig)).build());
        }

        public Builder shadowProductionVariants(Collection<ProductionVariant> var1);

        public Builder shadowProductionVariants(ProductionVariant ... var1);

        public Builder shadowProductionVariants(Consumer<ProductionVariant.Builder> ... var1);

        public Builder executionRoleArn(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder enableNetworkIsolation(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

