/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelQualityAppSpecification;
import software.amazon.awssdk.services.sagemaker.model.ModelQualityBaselineConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelQualityJobInput;
import software.amazon.awssdk.services.sagemaker.model.MonitoringNetworkConfig;
import software.amazon.awssdk.services.sagemaker.model.MonitoringOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.MonitoringResources;
import software.amazon.awssdk.services.sagemaker.model.MonitoringStoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeModelQualityJobDefinitionResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeModelQualityJobDefinitionResponse> {
    private static final SdkField<String> JOB_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobDefinitionArn").getter(DescribeModelQualityJobDefinitionResponse.getter(DescribeModelQualityJobDefinitionResponse::jobDefinitionArn)).setter(DescribeModelQualityJobDefinitionResponse.setter(Builder::jobDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionArn").build()}).build();
    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobDefinitionName").getter(DescribeModelQualityJobDefinitionResponse.getter(DescribeModelQualityJobDefinitionResponse::jobDefinitionName)).setter(DescribeModelQualityJobDefinitionResponse.setter(Builder::jobDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeModelQualityJobDefinitionResponse.getter(DescribeModelQualityJobDefinitionResponse::creationTime)).setter(DescribeModelQualityJobDefinitionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<ModelQualityBaselineConfig> MODEL_QUALITY_BASELINE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelQualityBaselineConfig").getter(DescribeModelQualityJobDefinitionResponse.getter(DescribeModelQualityJobDefinitionResponse::modelQualityBaselineConfig)).setter(DescribeModelQualityJobDefinitionResponse.setter(Builder::modelQualityBaselineConfig)).constructor(ModelQualityBaselineConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityBaselineConfig").build()}).build();
    private static final SdkField<ModelQualityAppSpecification> MODEL_QUALITY_APP_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelQualityAppSpecification").getter(DescribeModelQualityJobDefinitionResponse.getter(DescribeModelQualityJobDefinitionResponse::modelQualityAppSpecification)).setter(DescribeModelQualityJobDefinitionResponse.setter(Builder::modelQualityAppSpecification)).constructor(ModelQualityAppSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityAppSpecification").build()}).build();
    private static final SdkField<ModelQualityJobInput> MODEL_QUALITY_JOB_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelQualityJobInput").getter(DescribeModelQualityJobDefinitionResponse.getter(DescribeModelQualityJobDefinitionResponse::modelQualityJobInput)).setter(DescribeModelQualityJobDefinitionResponse.setter(Builder::modelQualityJobInput)).constructor(ModelQualityJobInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityJobInput").build()}).build();
    private static final SdkField<MonitoringOutputConfig> MODEL_QUALITY_JOB_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelQualityJobOutputConfig").getter(DescribeModelQualityJobDefinitionResponse.getter(DescribeModelQualityJobDefinitionResponse::modelQualityJobOutputConfig)).setter(DescribeModelQualityJobDefinitionResponse.setter(Builder::modelQualityJobOutputConfig)).constructor(MonitoringOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityJobOutputConfig").build()}).build();
    private static final SdkField<MonitoringResources> JOB_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobResources").getter(DescribeModelQualityJobDefinitionResponse.getter(DescribeModelQualityJobDefinitionResponse::jobResources)).setter(DescribeModelQualityJobDefinitionResponse.setter(Builder::jobResources)).constructor(MonitoringResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobResources").build()}).build();
    private static final SdkField<MonitoringNetworkConfig> NETWORK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfig").getter(DescribeModelQualityJobDefinitionResponse.getter(DescribeModelQualityJobDefinitionResponse::networkConfig)).setter(DescribeModelQualityJobDefinitionResponse.setter(Builder::networkConfig)).constructor(MonitoringNetworkConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeModelQualityJobDefinitionResponse.getter(DescribeModelQualityJobDefinitionResponse::roleArn)).setter(DescribeModelQualityJobDefinitionResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<MonitoringStoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(DescribeModelQualityJobDefinitionResponse.getter(DescribeModelQualityJobDefinitionResponse::stoppingCondition)).setter(DescribeModelQualityJobDefinitionResponse.setter(Builder::stoppingCondition)).constructor(MonitoringStoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_ARN_FIELD, JOB_DEFINITION_NAME_FIELD, CREATION_TIME_FIELD, MODEL_QUALITY_BASELINE_CONFIG_FIELD, MODEL_QUALITY_APP_SPECIFICATION_FIELD, MODEL_QUALITY_JOB_INPUT_FIELD, MODEL_QUALITY_JOB_OUTPUT_CONFIG_FIELD, JOB_RESOURCES_FIELD, NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD, STOPPING_CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("JobDefinitionArn", JOB_DEFINITION_ARN_FIELD);
            this.put("JobDefinitionName", JOB_DEFINITION_NAME_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("ModelQualityBaselineConfig", MODEL_QUALITY_BASELINE_CONFIG_FIELD);
            this.put("ModelQualityAppSpecification", MODEL_QUALITY_APP_SPECIFICATION_FIELD);
            this.put("ModelQualityJobInput", MODEL_QUALITY_JOB_INPUT_FIELD);
            this.put("ModelQualityJobOutputConfig", MODEL_QUALITY_JOB_OUTPUT_CONFIG_FIELD);
            this.put("JobResources", JOB_RESOURCES_FIELD);
            this.put("NetworkConfig", NETWORK_CONFIG_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("StoppingCondition", STOPPING_CONDITION_FIELD);
        }
    });
    private final String jobDefinitionArn;
    private final String jobDefinitionName;
    private final Instant creationTime;
    private final ModelQualityBaselineConfig modelQualityBaselineConfig;
    private final ModelQualityAppSpecification modelQualityAppSpecification;
    private final ModelQualityJobInput modelQualityJobInput;
    private final MonitoringOutputConfig modelQualityJobOutputConfig;
    private final MonitoringResources jobResources;
    private final MonitoringNetworkConfig networkConfig;
    private final String roleArn;
    private final MonitoringStoppingCondition stoppingCondition;

    private DescribeModelQualityJobDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionArn = builder.jobDefinitionArn;
        this.jobDefinitionName = builder.jobDefinitionName;
        this.creationTime = builder.creationTime;
        this.modelQualityBaselineConfig = builder.modelQualityBaselineConfig;
        this.modelQualityAppSpecification = builder.modelQualityAppSpecification;
        this.modelQualityJobInput = builder.modelQualityJobInput;
        this.modelQualityJobOutputConfig = builder.modelQualityJobOutputConfig;
        this.jobResources = builder.jobResources;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
    }

    public final String jobDefinitionArn() {
        return this.jobDefinitionArn;
    }

    public final String jobDefinitionName() {
        return this.jobDefinitionName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ModelQualityBaselineConfig modelQualityBaselineConfig() {
        return this.modelQualityBaselineConfig;
    }

    public final ModelQualityAppSpecification modelQualityAppSpecification() {
        return this.modelQualityAppSpecification;
    }

    public final ModelQualityJobInput modelQualityJobInput() {
        return this.modelQualityJobInput;
    }

    public final MonitoringOutputConfig modelQualityJobOutputConfig() {
        return this.modelQualityJobOutputConfig;
    }

    public final MonitoringResources jobResources() {
        return this.jobResources;
    }

    public final MonitoringNetworkConfig networkConfig() {
        return this.networkConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final MonitoringStoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelQualityBaselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelQualityAppSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelQualityJobInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelQualityJobOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelQualityJobDefinitionResponse)) {
            return false;
        }
        DescribeModelQualityJobDefinitionResponse other = (DescribeModelQualityJobDefinitionResponse)((Object)obj);
        return Objects.equals(this.jobDefinitionArn(), other.jobDefinitionArn()) && Objects.equals(this.jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.modelQualityBaselineConfig(), other.modelQualityBaselineConfig()) && Objects.equals(this.modelQualityAppSpecification(), other.modelQualityAppSpecification()) && Objects.equals(this.modelQualityJobInput(), other.modelQualityJobInput()) && Objects.equals(this.modelQualityJobOutputConfig(), other.modelQualityJobOutputConfig()) && Objects.equals(this.jobResources(), other.jobResources()) && Objects.equals(this.networkConfig(), other.networkConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeModelQualityJobDefinitionResponse").add("JobDefinitionArn", (Object)this.jobDefinitionArn()).add("JobDefinitionName", (Object)this.jobDefinitionName()).add("CreationTime", (Object)this.creationTime()).add("ModelQualityBaselineConfig", (Object)this.modelQualityBaselineConfig()).add("ModelQualityAppSpecification", (Object)this.modelQualityAppSpecification()).add("ModelQualityJobInput", (Object)this.modelQualityJobInput()).add("ModelQualityJobOutputConfig", (Object)this.modelQualityJobOutputConfig()).add("JobResources", (Object)this.jobResources()).add("NetworkConfig", (Object)this.networkConfig()).add("RoleArn", (Object)this.roleArn()).add("StoppingCondition", (Object)this.stoppingCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionArn()));
            }
            case "JobDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ModelQualityBaselineConfig": {
                return Optional.ofNullable(clazz.cast(this.modelQualityBaselineConfig()));
            }
            case "ModelQualityAppSpecification": {
                return Optional.ofNullable(clazz.cast(this.modelQualityAppSpecification()));
            }
            case "ModelQualityJobInput": {
                return Optional.ofNullable(clazz.cast(this.modelQualityJobInput()));
            }
            case "ModelQualityJobOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.modelQualityJobOutputConfig()));
            }
            case "JobResources": {
                return Optional.ofNullable(clazz.cast(this.jobResources()));
            }
            case "NetworkConfig": {
                return Optional.ofNullable(clazz.cast(this.networkConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelQualityJobDefinitionResponse, T> g) {
        return obj -> g.apply((DescribeModelQualityJobDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String jobDefinitionArn;
        private String jobDefinitionName;
        private Instant creationTime;
        private ModelQualityBaselineConfig modelQualityBaselineConfig;
        private ModelQualityAppSpecification modelQualityAppSpecification;
        private ModelQualityJobInput modelQualityJobInput;
        private MonitoringOutputConfig modelQualityJobOutputConfig;
        private MonitoringResources jobResources;
        private MonitoringNetworkConfig networkConfig;
        private String roleArn;
        private MonitoringStoppingCondition stoppingCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelQualityJobDefinitionResponse model) {
            super(model);
            this.jobDefinitionArn(model.jobDefinitionArn);
            this.jobDefinitionName(model.jobDefinitionName);
            this.creationTime(model.creationTime);
            this.modelQualityBaselineConfig(model.modelQualityBaselineConfig);
            this.modelQualityAppSpecification(model.modelQualityAppSpecification);
            this.modelQualityJobInput(model.modelQualityJobInput);
            this.modelQualityJobOutputConfig(model.modelQualityJobOutputConfig);
            this.jobResources(model.jobResources);
            this.networkConfig(model.networkConfig);
            this.roleArn(model.roleArn);
            this.stoppingCondition(model.stoppingCondition);
        }

        public final String getJobDefinitionArn() {
            return this.jobDefinitionArn;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        @Override
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        public final String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ModelQualityBaselineConfig.Builder getModelQualityBaselineConfig() {
            return this.modelQualityBaselineConfig != null ? this.modelQualityBaselineConfig.toBuilder() : null;
        }

        public final void setModelQualityBaselineConfig(ModelQualityBaselineConfig.BuilderImpl modelQualityBaselineConfig) {
            this.modelQualityBaselineConfig = modelQualityBaselineConfig != null ? modelQualityBaselineConfig.build() : null;
        }

        @Override
        public final Builder modelQualityBaselineConfig(ModelQualityBaselineConfig modelQualityBaselineConfig) {
            this.modelQualityBaselineConfig = modelQualityBaselineConfig;
            return this;
        }

        public final ModelQualityAppSpecification.Builder getModelQualityAppSpecification() {
            return this.modelQualityAppSpecification != null ? this.modelQualityAppSpecification.toBuilder() : null;
        }

        public final void setModelQualityAppSpecification(ModelQualityAppSpecification.BuilderImpl modelQualityAppSpecification) {
            this.modelQualityAppSpecification = modelQualityAppSpecification != null ? modelQualityAppSpecification.build() : null;
        }

        @Override
        public final Builder modelQualityAppSpecification(ModelQualityAppSpecification modelQualityAppSpecification) {
            this.modelQualityAppSpecification = modelQualityAppSpecification;
            return this;
        }

        public final ModelQualityJobInput.Builder getModelQualityJobInput() {
            return this.modelQualityJobInput != null ? this.modelQualityJobInput.toBuilder() : null;
        }

        public final void setModelQualityJobInput(ModelQualityJobInput.BuilderImpl modelQualityJobInput) {
            this.modelQualityJobInput = modelQualityJobInput != null ? modelQualityJobInput.build() : null;
        }

        @Override
        public final Builder modelQualityJobInput(ModelQualityJobInput modelQualityJobInput) {
            this.modelQualityJobInput = modelQualityJobInput;
            return this;
        }

        public final MonitoringOutputConfig.Builder getModelQualityJobOutputConfig() {
            return this.modelQualityJobOutputConfig != null ? this.modelQualityJobOutputConfig.toBuilder() : null;
        }

        public final void setModelQualityJobOutputConfig(MonitoringOutputConfig.BuilderImpl modelQualityJobOutputConfig) {
            this.modelQualityJobOutputConfig = modelQualityJobOutputConfig != null ? modelQualityJobOutputConfig.build() : null;
        }

        @Override
        public final Builder modelQualityJobOutputConfig(MonitoringOutputConfig modelQualityJobOutputConfig) {
            this.modelQualityJobOutputConfig = modelQualityJobOutputConfig;
            return this;
        }

        public final MonitoringResources.Builder getJobResources() {
            return this.jobResources != null ? this.jobResources.toBuilder() : null;
        }

        public final void setJobResources(MonitoringResources.BuilderImpl jobResources) {
            this.jobResources = jobResources != null ? jobResources.build() : null;
        }

        @Override
        public final Builder jobResources(MonitoringResources jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        public final MonitoringNetworkConfig.Builder getNetworkConfig() {
            return this.networkConfig != null ? this.networkConfig.toBuilder() : null;
        }

        public final void setNetworkConfig(MonitoringNetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        @Override
        public final Builder networkConfig(MonitoringNetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final MonitoringStoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(MonitoringStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        @Override
        public DescribeModelQualityJobDefinitionResponse build() {
            return new DescribeModelQualityJobDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeModelQualityJobDefinitionResponse> {
        public Builder jobDefinitionArn(String var1);

        public Builder jobDefinitionName(String var1);

        public Builder creationTime(Instant var1);

        public Builder modelQualityBaselineConfig(ModelQualityBaselineConfig var1);

        default public Builder modelQualityBaselineConfig(Consumer<ModelQualityBaselineConfig.Builder> modelQualityBaselineConfig) {
            return this.modelQualityBaselineConfig((ModelQualityBaselineConfig)((ModelQualityBaselineConfig.Builder)ModelQualityBaselineConfig.builder().applyMutation(modelQualityBaselineConfig)).build());
        }

        public Builder modelQualityAppSpecification(ModelQualityAppSpecification var1);

        default public Builder modelQualityAppSpecification(Consumer<ModelQualityAppSpecification.Builder> modelQualityAppSpecification) {
            return this.modelQualityAppSpecification((ModelQualityAppSpecification)((ModelQualityAppSpecification.Builder)ModelQualityAppSpecification.builder().applyMutation(modelQualityAppSpecification)).build());
        }

        public Builder modelQualityJobInput(ModelQualityJobInput var1);

        default public Builder modelQualityJobInput(Consumer<ModelQualityJobInput.Builder> modelQualityJobInput) {
            return this.modelQualityJobInput((ModelQualityJobInput)((ModelQualityJobInput.Builder)ModelQualityJobInput.builder().applyMutation(modelQualityJobInput)).build());
        }

        public Builder modelQualityJobOutputConfig(MonitoringOutputConfig var1);

        default public Builder modelQualityJobOutputConfig(Consumer<MonitoringOutputConfig.Builder> modelQualityJobOutputConfig) {
            return this.modelQualityJobOutputConfig((MonitoringOutputConfig)((MonitoringOutputConfig.Builder)MonitoringOutputConfig.builder().applyMutation(modelQualityJobOutputConfig)).build());
        }

        public Builder jobResources(MonitoringResources var1);

        default public Builder jobResources(Consumer<MonitoringResources.Builder> jobResources) {
            return this.jobResources((MonitoringResources)((MonitoringResources.Builder)MonitoringResources.builder().applyMutation(jobResources)).build());
        }

        public Builder networkConfig(MonitoringNetworkConfig var1);

        default public Builder networkConfig(Consumer<MonitoringNetworkConfig.Builder> networkConfig) {
            return this.networkConfig((MonitoringNetworkConfig)((MonitoringNetworkConfig.Builder)MonitoringNetworkConfig.builder().applyMutation(networkConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder stoppingCondition(MonitoringStoppingCondition var1);

        default public Builder stoppingCondition(Consumer<MonitoringStoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((MonitoringStoppingCondition)((MonitoringStoppingCondition.Builder)MonitoringStoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }
    }
}

