/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HubContentSearchKeywordListCopier;
import software.amazon.awssdk.services.sagemaker.model.HubContentType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportHubContentRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ImportHubContentRequest> {
    private static final SdkField<String> HUB_CONTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentName").getter(ImportHubContentRequest.getter(ImportHubContentRequest::hubContentName)).setter(ImportHubContentRequest.setter(Builder::hubContentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentName").build()}).build();
    private static final SdkField<String> HUB_CONTENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentVersion").getter(ImportHubContentRequest.getter(ImportHubContentRequest::hubContentVersion)).setter(ImportHubContentRequest.setter(Builder::hubContentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentVersion").build()}).build();
    private static final SdkField<String> HUB_CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentType").getter(ImportHubContentRequest.getter(ImportHubContentRequest::hubContentTypeAsString)).setter(ImportHubContentRequest.setter(Builder::hubContentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentType").build()}).build();
    private static final SdkField<String> DOCUMENT_SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentSchemaVersion").getter(ImportHubContentRequest.getter(ImportHubContentRequest::documentSchemaVersion)).setter(ImportHubContentRequest.setter(Builder::documentSchemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentSchemaVersion").build()}).build();
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubName").getter(ImportHubContentRequest.getter(ImportHubContentRequest::hubName)).setter(ImportHubContentRequest.setter(Builder::hubName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()}).build();
    private static final SdkField<String> HUB_CONTENT_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentDisplayName").getter(ImportHubContentRequest.getter(ImportHubContentRequest::hubContentDisplayName)).setter(ImportHubContentRequest.setter(Builder::hubContentDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDisplayName").build()}).build();
    private static final SdkField<String> HUB_CONTENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentDescription").getter(ImportHubContentRequest.getter(ImportHubContentRequest::hubContentDescription)).setter(ImportHubContentRequest.setter(Builder::hubContentDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDescription").build()}).build();
    private static final SdkField<String> HUB_CONTENT_MARKDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentMarkdown").getter(ImportHubContentRequest.getter(ImportHubContentRequest::hubContentMarkdown)).setter(ImportHubContentRequest.setter(Builder::hubContentMarkdown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentMarkdown").build()}).build();
    private static final SdkField<String> HUB_CONTENT_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentDocument").getter(ImportHubContentRequest.getter(ImportHubContentRequest::hubContentDocument)).setter(ImportHubContentRequest.setter(Builder::hubContentDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDocument").build()}).build();
    private static final SdkField<List<String>> HUB_CONTENT_SEARCH_KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HubContentSearchKeywords").getter(ImportHubContentRequest.getter(ImportHubContentRequest::hubContentSearchKeywords)).setter(ImportHubContentRequest.setter(Builder::hubContentSearchKeywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentSearchKeywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ImportHubContentRequest.getter(ImportHubContentRequest::tags)).setter(ImportHubContentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_CONTENT_NAME_FIELD, HUB_CONTENT_VERSION_FIELD, HUB_CONTENT_TYPE_FIELD, DOCUMENT_SCHEMA_VERSION_FIELD, HUB_NAME_FIELD, HUB_CONTENT_DISPLAY_NAME_FIELD, HUB_CONTENT_DESCRIPTION_FIELD, HUB_CONTENT_MARKDOWN_FIELD, HUB_CONTENT_DOCUMENT_FIELD, HUB_CONTENT_SEARCH_KEYWORDS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("HubContentName", HUB_CONTENT_NAME_FIELD);
            this.put("HubContentVersion", HUB_CONTENT_VERSION_FIELD);
            this.put("HubContentType", HUB_CONTENT_TYPE_FIELD);
            this.put("DocumentSchemaVersion", DOCUMENT_SCHEMA_VERSION_FIELD);
            this.put("HubName", HUB_NAME_FIELD);
            this.put("HubContentDisplayName", HUB_CONTENT_DISPLAY_NAME_FIELD);
            this.put("HubContentDescription", HUB_CONTENT_DESCRIPTION_FIELD);
            this.put("HubContentMarkdown", HUB_CONTENT_MARKDOWN_FIELD);
            this.put("HubContentDocument", HUB_CONTENT_DOCUMENT_FIELD);
            this.put("HubContentSearchKeywords", HUB_CONTENT_SEARCH_KEYWORDS_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String hubContentName;
    private final String hubContentVersion;
    private final String hubContentType;
    private final String documentSchemaVersion;
    private final String hubName;
    private final String hubContentDisplayName;
    private final String hubContentDescription;
    private final String hubContentMarkdown;
    private final String hubContentDocument;
    private final List<String> hubContentSearchKeywords;
    private final List<Tag> tags;

    private ImportHubContentRequest(BuilderImpl builder) {
        super(builder);
        this.hubContentName = builder.hubContentName;
        this.hubContentVersion = builder.hubContentVersion;
        this.hubContentType = builder.hubContentType;
        this.documentSchemaVersion = builder.documentSchemaVersion;
        this.hubName = builder.hubName;
        this.hubContentDisplayName = builder.hubContentDisplayName;
        this.hubContentDescription = builder.hubContentDescription;
        this.hubContentMarkdown = builder.hubContentMarkdown;
        this.hubContentDocument = builder.hubContentDocument;
        this.hubContentSearchKeywords = builder.hubContentSearchKeywords;
        this.tags = builder.tags;
    }

    public final String hubContentName() {
        return this.hubContentName;
    }

    public final String hubContentVersion() {
        return this.hubContentVersion;
    }

    public final HubContentType hubContentType() {
        return HubContentType.fromValue(this.hubContentType);
    }

    public final String hubContentTypeAsString() {
        return this.hubContentType;
    }

    public final String documentSchemaVersion() {
        return this.documentSchemaVersion;
    }

    public final String hubName() {
        return this.hubName;
    }

    public final String hubContentDisplayName() {
        return this.hubContentDisplayName;
    }

    public final String hubContentDescription() {
        return this.hubContentDescription;
    }

    public final String hubContentMarkdown() {
        return this.hubContentMarkdown;
    }

    public final String hubContentDocument() {
        return this.hubContentDocument;
    }

    public final boolean hasHubContentSearchKeywords() {
        return this.hubContentSearchKeywords != null && !(this.hubContentSearchKeywords instanceof SdkAutoConstructList);
    }

    public final List<String> hubContentSearchKeywords() {
        return this.hubContentSearchKeywords;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentSchemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentMarkdown());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHubContentSearchKeywords() ? this.hubContentSearchKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportHubContentRequest)) {
            return false;
        }
        ImportHubContentRequest other = (ImportHubContentRequest)((Object)obj);
        return Objects.equals(this.hubContentName(), other.hubContentName()) && Objects.equals(this.hubContentVersion(), other.hubContentVersion()) && Objects.equals(this.hubContentTypeAsString(), other.hubContentTypeAsString()) && Objects.equals(this.documentSchemaVersion(), other.documentSchemaVersion()) && Objects.equals(this.hubName(), other.hubName()) && Objects.equals(this.hubContentDisplayName(), other.hubContentDisplayName()) && Objects.equals(this.hubContentDescription(), other.hubContentDescription()) && Objects.equals(this.hubContentMarkdown(), other.hubContentMarkdown()) && Objects.equals(this.hubContentDocument(), other.hubContentDocument()) && this.hasHubContentSearchKeywords() == other.hasHubContentSearchKeywords() && Objects.equals(this.hubContentSearchKeywords(), other.hubContentSearchKeywords()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ImportHubContentRequest").add("HubContentName", (Object)this.hubContentName()).add("HubContentVersion", (Object)this.hubContentVersion()).add("HubContentType", (Object)this.hubContentTypeAsString()).add("DocumentSchemaVersion", (Object)this.documentSchemaVersion()).add("HubName", (Object)this.hubName()).add("HubContentDisplayName", (Object)this.hubContentDisplayName()).add("HubContentDescription", (Object)this.hubContentDescription()).add("HubContentMarkdown", (Object)this.hubContentMarkdown()).add("HubContentDocument", (Object)this.hubContentDocument()).add("HubContentSearchKeywords", this.hasHubContentSearchKeywords() ? this.hubContentSearchKeywords() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubContentName": {
                return Optional.ofNullable(clazz.cast(this.hubContentName()));
            }
            case "HubContentVersion": {
                return Optional.ofNullable(clazz.cast(this.hubContentVersion()));
            }
            case "HubContentType": {
                return Optional.ofNullable(clazz.cast(this.hubContentTypeAsString()));
            }
            case "DocumentSchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.documentSchemaVersion()));
            }
            case "HubName": {
                return Optional.ofNullable(clazz.cast(this.hubName()));
            }
            case "HubContentDisplayName": {
                return Optional.ofNullable(clazz.cast(this.hubContentDisplayName()));
            }
            case "HubContentDescription": {
                return Optional.ofNullable(clazz.cast(this.hubContentDescription()));
            }
            case "HubContentMarkdown": {
                return Optional.ofNullable(clazz.cast(this.hubContentMarkdown()));
            }
            case "HubContentDocument": {
                return Optional.ofNullable(clazz.cast(this.hubContentDocument()));
            }
            case "HubContentSearchKeywords": {
                return Optional.ofNullable(clazz.cast(this.hubContentSearchKeywords()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportHubContentRequest, T> g) {
        return obj -> g.apply((ImportHubContentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String hubContentName;
        private String hubContentVersion;
        private String hubContentType;
        private String documentSchemaVersion;
        private String hubName;
        private String hubContentDisplayName;
        private String hubContentDescription;
        private String hubContentMarkdown;
        private String hubContentDocument;
        private List<String> hubContentSearchKeywords = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportHubContentRequest model) {
            super(model);
            this.hubContentName(model.hubContentName);
            this.hubContentVersion(model.hubContentVersion);
            this.hubContentType(model.hubContentType);
            this.documentSchemaVersion(model.documentSchemaVersion);
            this.hubName(model.hubName);
            this.hubContentDisplayName(model.hubContentDisplayName);
            this.hubContentDescription(model.hubContentDescription);
            this.hubContentMarkdown(model.hubContentMarkdown);
            this.hubContentDocument(model.hubContentDocument);
            this.hubContentSearchKeywords(model.hubContentSearchKeywords);
            this.tags(model.tags);
        }

        public final String getHubContentName() {
            return this.hubContentName;
        }

        public final void setHubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
        }

        @Override
        public final Builder hubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
            return this;
        }

        public final String getHubContentVersion() {
            return this.hubContentVersion;
        }

        public final void setHubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
        }

        @Override
        public final Builder hubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
            return this;
        }

        public final String getHubContentType() {
            return this.hubContentType;
        }

        public final void setHubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
        }

        @Override
        public final Builder hubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
            return this;
        }

        @Override
        public final Builder hubContentType(HubContentType hubContentType) {
            this.hubContentType(hubContentType == null ? null : hubContentType.toString());
            return this;
        }

        public final String getDocumentSchemaVersion() {
            return this.documentSchemaVersion;
        }

        public final void setDocumentSchemaVersion(String documentSchemaVersion) {
            this.documentSchemaVersion = documentSchemaVersion;
        }

        @Override
        public final Builder documentSchemaVersion(String documentSchemaVersion) {
            this.documentSchemaVersion = documentSchemaVersion;
            return this;
        }

        public final String getHubName() {
            return this.hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubContentDisplayName() {
            return this.hubContentDisplayName;
        }

        public final void setHubContentDisplayName(String hubContentDisplayName) {
            this.hubContentDisplayName = hubContentDisplayName;
        }

        @Override
        public final Builder hubContentDisplayName(String hubContentDisplayName) {
            this.hubContentDisplayName = hubContentDisplayName;
            return this;
        }

        public final String getHubContentDescription() {
            return this.hubContentDescription;
        }

        public final void setHubContentDescription(String hubContentDescription) {
            this.hubContentDescription = hubContentDescription;
        }

        @Override
        public final Builder hubContentDescription(String hubContentDescription) {
            this.hubContentDescription = hubContentDescription;
            return this;
        }

        public final String getHubContentMarkdown() {
            return this.hubContentMarkdown;
        }

        public final void setHubContentMarkdown(String hubContentMarkdown) {
            this.hubContentMarkdown = hubContentMarkdown;
        }

        @Override
        public final Builder hubContentMarkdown(String hubContentMarkdown) {
            this.hubContentMarkdown = hubContentMarkdown;
            return this;
        }

        public final String getHubContentDocument() {
            return this.hubContentDocument;
        }

        public final void setHubContentDocument(String hubContentDocument) {
            this.hubContentDocument = hubContentDocument;
        }

        @Override
        public final Builder hubContentDocument(String hubContentDocument) {
            this.hubContentDocument = hubContentDocument;
            return this;
        }

        public final Collection<String> getHubContentSearchKeywords() {
            if (this.hubContentSearchKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hubContentSearchKeywords;
        }

        public final void setHubContentSearchKeywords(Collection<String> hubContentSearchKeywords) {
            this.hubContentSearchKeywords = HubContentSearchKeywordListCopier.copy(hubContentSearchKeywords);
        }

        @Override
        public final Builder hubContentSearchKeywords(Collection<String> hubContentSearchKeywords) {
            this.hubContentSearchKeywords = HubContentSearchKeywordListCopier.copy(hubContentSearchKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubContentSearchKeywords(String ... hubContentSearchKeywords) {
            this.hubContentSearchKeywords(Arrays.asList(hubContentSearchKeywords));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportHubContentRequest build() {
            return new ImportHubContentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportHubContentRequest> {
        public Builder hubContentName(String var1);

        public Builder hubContentVersion(String var1);

        public Builder hubContentType(String var1);

        public Builder hubContentType(HubContentType var1);

        public Builder documentSchemaVersion(String var1);

        public Builder hubName(String var1);

        public Builder hubContentDisplayName(String var1);

        public Builder hubContentDescription(String var1);

        public Builder hubContentMarkdown(String var1);

        public Builder hubContentDocument(String var1);

        public Builder hubContentSearchKeywords(Collection<String> var1);

        public Builder hubContentSearchKeywords(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

