/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ArtifactSource;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteArtifactRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, DeleteArtifactRequest> {
    private static final SdkField<String> ARTIFACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactArn").getter(DeleteArtifactRequest.getter(DeleteArtifactRequest::artifactArn)).setter(DeleteArtifactRequest.setter(Builder::artifactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactArn").build()}).build();
    private static final SdkField<ArtifactSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(DeleteArtifactRequest.getter(DeleteArtifactRequest::source)).setter(DeleteArtifactRequest.setter(Builder::source)).constructor(ArtifactSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_ARN_FIELD, SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ArtifactArn", ARTIFACT_ARN_FIELD);
            this.put("Source", SOURCE_FIELD);
        }
    });
    private final String artifactArn;
    private final ArtifactSource source;

    private DeleteArtifactRequest(BuilderImpl builder) {
        super(builder);
        this.artifactArn = builder.artifactArn;
        this.source = builder.source;
    }

    public final String artifactArn() {
        return this.artifactArn;
    }

    public final ArtifactSource source() {
        return this.source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteArtifactRequest)) {
            return false;
        }
        DeleteArtifactRequest other = (DeleteArtifactRequest)((Object)obj);
        return Objects.equals(this.artifactArn(), other.artifactArn()) && Objects.equals(this.source(), other.source());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteArtifactRequest").add("ArtifactArn", (Object)this.artifactArn()).add("Source", (Object)this.source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArtifactArn": {
                return Optional.ofNullable(clazz.cast(this.artifactArn()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteArtifactRequest, T> g) {
        return obj -> g.apply((DeleteArtifactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String artifactArn;
        private ArtifactSource source;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteArtifactRequest model) {
            super(model);
            this.artifactArn(model.artifactArn);
            this.source(model.source);
        }

        public final String getArtifactArn() {
            return this.artifactArn;
        }

        public final void setArtifactArn(String artifactArn) {
            this.artifactArn = artifactArn;
        }

        @Override
        public final Builder artifactArn(String artifactArn) {
            this.artifactArn = artifactArn;
            return this;
        }

        public final ArtifactSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(ArtifactSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ArtifactSource source) {
            this.source = source;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteArtifactRequest build() {
            return new DeleteArtifactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteArtifactRequest> {
        public Builder artifactArn(String var1);

        public Builder source(ArtifactSource var1);

        default public Builder source(Consumer<ArtifactSource.Builder> source) {
            return this.source((ArtifactSource)((ArtifactSource.Builder)ArtifactSource.builder().applyMutation(source)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

