/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoMLMode {
    AUTO("AUTO"),
    ENSEMBLING("ENSEMBLING"),
    HYPERPARAMETER_TUNING("HYPERPARAMETER_TUNING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoMLMode> VALUE_MAP;
    private final String value;

    private AutoMLMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoMLMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoMLMode> knownValues() {
        EnumSet<AutoMLMode> knownValues = EnumSet.allOf(AutoMLMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoMLMode.class, AutoMLMode::toString);
    }
}

