/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AppNetworkAccessType;
import software.amazon.awssdk.services.sagemaker.model.AppSecurityGroupManagement;
import software.amazon.awssdk.services.sagemaker.model.DefaultSpaceSettings;
import software.amazon.awssdk.services.sagemaker.model.DomainSettingsForUpdate;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SubnetsCopier;
import software.amazon.awssdk.services.sagemaker.model.TagPropagation;
import software.amazon.awssdk.services.sagemaker.model.UserSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDomainRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateDomainRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(UpdateDomainRequest.getter(UpdateDomainRequest::domainId)).setter(UpdateDomainRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<UserSettings> DEFAULT_USER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultUserSettings").getter(UpdateDomainRequest.getter(UpdateDomainRequest::defaultUserSettings)).setter(UpdateDomainRequest.setter(Builder::defaultUserSettings)).constructor(UserSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultUserSettings").build()}).build();
    private static final SdkField<DomainSettingsForUpdate> DOMAIN_SETTINGS_FOR_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainSettingsForUpdate").getter(UpdateDomainRequest.getter(UpdateDomainRequest::domainSettingsForUpdate)).setter(UpdateDomainRequest.setter(Builder::domainSettingsForUpdate)).constructor(DomainSettingsForUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainSettingsForUpdate").build()}).build();
    private static final SdkField<String> APP_SECURITY_GROUP_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppSecurityGroupManagement").getter(UpdateDomainRequest.getter(UpdateDomainRequest::appSecurityGroupManagementAsString)).setter(UpdateDomainRequest.setter(Builder::appSecurityGroupManagement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppSecurityGroupManagement").build()}).build();
    private static final SdkField<DefaultSpaceSettings> DEFAULT_SPACE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultSpaceSettings").getter(UpdateDomainRequest.getter(UpdateDomainRequest::defaultSpaceSettings)).setter(UpdateDomainRequest.setter(Builder::defaultSpaceSettings)).constructor(DefaultSpaceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSpaceSettings").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(UpdateDomainRequest.getter(UpdateDomainRequest::subnetIds)).setter(UpdateDomainRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APP_NETWORK_ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppNetworkAccessType").getter(UpdateDomainRequest.getter(UpdateDomainRequest::appNetworkAccessTypeAsString)).setter(UpdateDomainRequest.setter(Builder::appNetworkAccessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppNetworkAccessType").build()}).build();
    private static final SdkField<String> TAG_PROPAGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagPropagation").getter(UpdateDomainRequest.getter(UpdateDomainRequest::tagPropagationAsString)).setter(UpdateDomainRequest.setter(Builder::tagPropagation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagPropagation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, DEFAULT_USER_SETTINGS_FIELD, DOMAIN_SETTINGS_FOR_UPDATE_FIELD, APP_SECURITY_GROUP_MANAGEMENT_FIELD, DEFAULT_SPACE_SETTINGS_FIELD, SUBNET_IDS_FIELD, APP_NETWORK_ACCESS_TYPE_FIELD, TAG_PROPAGATION_FIELD));
    private final String domainId;
    private final UserSettings defaultUserSettings;
    private final DomainSettingsForUpdate domainSettingsForUpdate;
    private final String appSecurityGroupManagement;
    private final DefaultSpaceSettings defaultSpaceSettings;
    private final List<String> subnetIds;
    private final String appNetworkAccessType;
    private final String tagPropagation;

    private UpdateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.defaultUserSettings = builder.defaultUserSettings;
        this.domainSettingsForUpdate = builder.domainSettingsForUpdate;
        this.appSecurityGroupManagement = builder.appSecurityGroupManagement;
        this.defaultSpaceSettings = builder.defaultSpaceSettings;
        this.subnetIds = builder.subnetIds;
        this.appNetworkAccessType = builder.appNetworkAccessType;
        this.tagPropagation = builder.tagPropagation;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final UserSettings defaultUserSettings() {
        return this.defaultUserSettings;
    }

    public final DomainSettingsForUpdate domainSettingsForUpdate() {
        return this.domainSettingsForUpdate;
    }

    public final AppSecurityGroupManagement appSecurityGroupManagement() {
        return AppSecurityGroupManagement.fromValue(this.appSecurityGroupManagement);
    }

    public final String appSecurityGroupManagementAsString() {
        return this.appSecurityGroupManagement;
    }

    public final DefaultSpaceSettings defaultSpaceSettings() {
        return this.defaultSpaceSettings;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final AppNetworkAccessType appNetworkAccessType() {
        return AppNetworkAccessType.fromValue(this.appNetworkAccessType);
    }

    public final String appNetworkAccessTypeAsString() {
        return this.appNetworkAccessType;
    }

    public final TagPropagation tagPropagation() {
        return TagPropagation.fromValue(this.tagPropagation);
    }

    public final String tagPropagationAsString() {
        return this.tagPropagation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultUserSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainSettingsForUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.appSecurityGroupManagementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSpaceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.appNetworkAccessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagPropagationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainRequest)) {
            return false;
        }
        UpdateDomainRequest other = (UpdateDomainRequest)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.defaultUserSettings(), other.defaultUserSettings()) && Objects.equals(this.domainSettingsForUpdate(), other.domainSettingsForUpdate()) && Objects.equals(this.appSecurityGroupManagementAsString(), other.appSecurityGroupManagementAsString()) && Objects.equals(this.defaultSpaceSettings(), other.defaultSpaceSettings()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.appNetworkAccessTypeAsString(), other.appNetworkAccessTypeAsString()) && Objects.equals(this.tagPropagationAsString(), other.tagPropagationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDomainRequest").add("DomainId", (Object)this.domainId()).add("DefaultUserSettings", (Object)this.defaultUserSettings()).add("DomainSettingsForUpdate", (Object)this.domainSettingsForUpdate()).add("AppSecurityGroupManagement", (Object)this.appSecurityGroupManagementAsString()).add("DefaultSpaceSettings", (Object)this.defaultSpaceSettings()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("AppNetworkAccessType", (Object)this.appNetworkAccessTypeAsString()).add("TagPropagation", (Object)this.tagPropagationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "DefaultUserSettings": {
                return Optional.ofNullable(clazz.cast(this.defaultUserSettings()));
            }
            case "DomainSettingsForUpdate": {
                return Optional.ofNullable(clazz.cast(this.domainSettingsForUpdate()));
            }
            case "AppSecurityGroupManagement": {
                return Optional.ofNullable(clazz.cast(this.appSecurityGroupManagementAsString()));
            }
            case "DefaultSpaceSettings": {
                return Optional.ofNullable(clazz.cast(this.defaultSpaceSettings()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "AppNetworkAccessType": {
                return Optional.ofNullable(clazz.cast(this.appNetworkAccessTypeAsString()));
            }
            case "TagPropagation": {
                return Optional.ofNullable(clazz.cast(this.tagPropagationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainRequest, T> g) {
        return obj -> g.apply((UpdateDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String domainId;
        private UserSettings defaultUserSettings;
        private DomainSettingsForUpdate domainSettingsForUpdate;
        private String appSecurityGroupManagement;
        private DefaultSpaceSettings defaultSpaceSettings;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String appNetworkAccessType;
        private String tagPropagation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainRequest model) {
            super(model);
            this.domainId(model.domainId);
            this.defaultUserSettings(model.defaultUserSettings);
            this.domainSettingsForUpdate(model.domainSettingsForUpdate);
            this.appSecurityGroupManagement(model.appSecurityGroupManagement);
            this.defaultSpaceSettings(model.defaultSpaceSettings);
            this.subnetIds(model.subnetIds);
            this.appNetworkAccessType(model.appNetworkAccessType);
            this.tagPropagation(model.tagPropagation);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final UserSettings.Builder getDefaultUserSettings() {
            return this.defaultUserSettings != null ? this.defaultUserSettings.toBuilder() : null;
        }

        public final void setDefaultUserSettings(UserSettings.BuilderImpl defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings != null ? defaultUserSettings.build() : null;
        }

        @Override
        public final Builder defaultUserSettings(UserSettings defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings;
            return this;
        }

        public final DomainSettingsForUpdate.Builder getDomainSettingsForUpdate() {
            return this.domainSettingsForUpdate != null ? this.domainSettingsForUpdate.toBuilder() : null;
        }

        public final void setDomainSettingsForUpdate(DomainSettingsForUpdate.BuilderImpl domainSettingsForUpdate) {
            this.domainSettingsForUpdate = domainSettingsForUpdate != null ? domainSettingsForUpdate.build() : null;
        }

        @Override
        public final Builder domainSettingsForUpdate(DomainSettingsForUpdate domainSettingsForUpdate) {
            this.domainSettingsForUpdate = domainSettingsForUpdate;
            return this;
        }

        public final String getAppSecurityGroupManagement() {
            return this.appSecurityGroupManagement;
        }

        public final void setAppSecurityGroupManagement(String appSecurityGroupManagement) {
            this.appSecurityGroupManagement = appSecurityGroupManagement;
        }

        @Override
        public final Builder appSecurityGroupManagement(String appSecurityGroupManagement) {
            this.appSecurityGroupManagement = appSecurityGroupManagement;
            return this;
        }

        @Override
        public final Builder appSecurityGroupManagement(AppSecurityGroupManagement appSecurityGroupManagement) {
            this.appSecurityGroupManagement(appSecurityGroupManagement == null ? null : appSecurityGroupManagement.toString());
            return this;
        }

        public final DefaultSpaceSettings.Builder getDefaultSpaceSettings() {
            return this.defaultSpaceSettings != null ? this.defaultSpaceSettings.toBuilder() : null;
        }

        public final void setDefaultSpaceSettings(DefaultSpaceSettings.BuilderImpl defaultSpaceSettings) {
            this.defaultSpaceSettings = defaultSpaceSettings != null ? defaultSpaceSettings.build() : null;
        }

        @Override
        public final Builder defaultSpaceSettings(DefaultSpaceSettings defaultSpaceSettings) {
            this.defaultSpaceSettings = defaultSpaceSettings;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getAppNetworkAccessType() {
            return this.appNetworkAccessType;
        }

        public final void setAppNetworkAccessType(String appNetworkAccessType) {
            this.appNetworkAccessType = appNetworkAccessType;
        }

        @Override
        public final Builder appNetworkAccessType(String appNetworkAccessType) {
            this.appNetworkAccessType = appNetworkAccessType;
            return this;
        }

        @Override
        public final Builder appNetworkAccessType(AppNetworkAccessType appNetworkAccessType) {
            this.appNetworkAccessType(appNetworkAccessType == null ? null : appNetworkAccessType.toString());
            return this;
        }

        public final String getTagPropagation() {
            return this.tagPropagation;
        }

        public final void setTagPropagation(String tagPropagation) {
            this.tagPropagation = tagPropagation;
        }

        @Override
        public final Builder tagPropagation(String tagPropagation) {
            this.tagPropagation = tagPropagation;
            return this;
        }

        @Override
        public final Builder tagPropagation(TagPropagation tagPropagation) {
            this.tagPropagation(tagPropagation == null ? null : tagPropagation.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainRequest build() {
            return new UpdateDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDomainRequest> {
        public Builder domainId(String var1);

        public Builder defaultUserSettings(UserSettings var1);

        default public Builder defaultUserSettings(Consumer<UserSettings.Builder> defaultUserSettings) {
            return this.defaultUserSettings((UserSettings)((UserSettings.Builder)UserSettings.builder().applyMutation(defaultUserSettings)).build());
        }

        public Builder domainSettingsForUpdate(DomainSettingsForUpdate var1);

        default public Builder domainSettingsForUpdate(Consumer<DomainSettingsForUpdate.Builder> domainSettingsForUpdate) {
            return this.domainSettingsForUpdate((DomainSettingsForUpdate)((DomainSettingsForUpdate.Builder)DomainSettingsForUpdate.builder().applyMutation(domainSettingsForUpdate)).build());
        }

        public Builder appSecurityGroupManagement(String var1);

        public Builder appSecurityGroupManagement(AppSecurityGroupManagement var1);

        public Builder defaultSpaceSettings(DefaultSpaceSettings var1);

        default public Builder defaultSpaceSettings(Consumer<DefaultSpaceSettings.Builder> defaultSpaceSettings) {
            return this.defaultSpaceSettings((DefaultSpaceSettings)((DefaultSpaceSettings.Builder)DefaultSpaceSettings.builder().applyMutation(defaultSpaceSettings)).build());
        }

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder appNetworkAccessType(String var1);

        public Builder appNetworkAccessType(AppNetworkAccessType var1);

        public Builder tagPropagation(String var1);

        public Builder tagPropagation(TagPropagation var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

