/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.DynamicScalingConfiguration;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.ScalingPolicyMetric;
import software.amazon.awssdk.services.sagemaker.model.ScalingPolicyObjective;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetScalingConfigurationRecommendationResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, GetScalingConfigurationRecommendationResponse> {
    private static final SdkField<String> INFERENCE_RECOMMENDATIONS_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceRecommendationsJobName").getter(GetScalingConfigurationRecommendationResponse.getter(GetScalingConfigurationRecommendationResponse::inferenceRecommendationsJobName)).setter(GetScalingConfigurationRecommendationResponse.setter(Builder::inferenceRecommendationsJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceRecommendationsJobName").build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationId").getter(GetScalingConfigurationRecommendationResponse.getter(GetScalingConfigurationRecommendationResponse::recommendationId)).setter(GetScalingConfigurationRecommendationResponse.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(GetScalingConfigurationRecommendationResponse.getter(GetScalingConfigurationRecommendationResponse::endpointName)).setter(GetScalingConfigurationRecommendationResponse.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<Integer> TARGET_CPU_UTILIZATION_PER_CORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetCpuUtilizationPerCore").getter(GetScalingConfigurationRecommendationResponse.getter(GetScalingConfigurationRecommendationResponse::targetCpuUtilizationPerCore)).setter(GetScalingConfigurationRecommendationResponse.setter(Builder::targetCpuUtilizationPerCore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCpuUtilizationPerCore").build()}).build();
    private static final SdkField<ScalingPolicyObjective> SCALING_POLICY_OBJECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScalingPolicyObjective").getter(GetScalingConfigurationRecommendationResponse.getter(GetScalingConfigurationRecommendationResponse::scalingPolicyObjective)).setter(GetScalingConfigurationRecommendationResponse.setter(Builder::scalingPolicyObjective)).constructor(ScalingPolicyObjective::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPolicyObjective").build()}).build();
    private static final SdkField<ScalingPolicyMetric> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metric").getter(GetScalingConfigurationRecommendationResponse.getter(GetScalingConfigurationRecommendationResponse::metric)).setter(GetScalingConfigurationRecommendationResponse.setter(Builder::metric)).constructor(ScalingPolicyMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()}).build();
    private static final SdkField<DynamicScalingConfiguration> DYNAMIC_SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DynamicScalingConfiguration").getter(GetScalingConfigurationRecommendationResponse.getter(GetScalingConfigurationRecommendationResponse::dynamicScalingConfiguration)).setter(GetScalingConfigurationRecommendationResponse.setter(Builder::dynamicScalingConfiguration)).constructor(DynamicScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicScalingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_RECOMMENDATIONS_JOB_NAME_FIELD, RECOMMENDATION_ID_FIELD, ENDPOINT_NAME_FIELD, TARGET_CPU_UTILIZATION_PER_CORE_FIELD, SCALING_POLICY_OBJECTIVE_FIELD, METRIC_FIELD, DYNAMIC_SCALING_CONFIGURATION_FIELD));
    private final String inferenceRecommendationsJobName;
    private final String recommendationId;
    private final String endpointName;
    private final Integer targetCpuUtilizationPerCore;
    private final ScalingPolicyObjective scalingPolicyObjective;
    private final ScalingPolicyMetric metric;
    private final DynamicScalingConfiguration dynamicScalingConfiguration;

    private GetScalingConfigurationRecommendationResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceRecommendationsJobName = builder.inferenceRecommendationsJobName;
        this.recommendationId = builder.recommendationId;
        this.endpointName = builder.endpointName;
        this.targetCpuUtilizationPerCore = builder.targetCpuUtilizationPerCore;
        this.scalingPolicyObjective = builder.scalingPolicyObjective;
        this.metric = builder.metric;
        this.dynamicScalingConfiguration = builder.dynamicScalingConfiguration;
    }

    public final String inferenceRecommendationsJobName() {
        return this.inferenceRecommendationsJobName;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final Integer targetCpuUtilizationPerCore() {
        return this.targetCpuUtilizationPerCore;
    }

    public final ScalingPolicyObjective scalingPolicyObjective() {
        return this.scalingPolicyObjective;
    }

    public final ScalingPolicyMetric metric() {
        return this.metric;
    }

    public final DynamicScalingConfiguration dynamicScalingConfiguration() {
        return this.dynamicScalingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceRecommendationsJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCpuUtilizationPerCore());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPolicyObjective());
        hashCode = 31 * hashCode + Objects.hashCode(this.metric());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicScalingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScalingConfigurationRecommendationResponse)) {
            return false;
        }
        GetScalingConfigurationRecommendationResponse other = (GetScalingConfigurationRecommendationResponse)((Object)obj);
        return Objects.equals(this.inferenceRecommendationsJobName(), other.inferenceRecommendationsJobName()) && Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.targetCpuUtilizationPerCore(), other.targetCpuUtilizationPerCore()) && Objects.equals(this.scalingPolicyObjective(), other.scalingPolicyObjective()) && Objects.equals(this.metric(), other.metric()) && Objects.equals(this.dynamicScalingConfiguration(), other.dynamicScalingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GetScalingConfigurationRecommendationResponse").add("InferenceRecommendationsJobName", (Object)this.inferenceRecommendationsJobName()).add("RecommendationId", (Object)this.recommendationId()).add("EndpointName", (Object)this.endpointName()).add("TargetCpuUtilizationPerCore", (Object)this.targetCpuUtilizationPerCore()).add("ScalingPolicyObjective", (Object)this.scalingPolicyObjective()).add("Metric", (Object)this.metric()).add("DynamicScalingConfiguration", (Object)this.dynamicScalingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InferenceRecommendationsJobName": {
                return Optional.ofNullable(clazz.cast(this.inferenceRecommendationsJobName()));
            }
            case "RecommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "TargetCpuUtilizationPerCore": {
                return Optional.ofNullable(clazz.cast(this.targetCpuUtilizationPerCore()));
            }
            case "ScalingPolicyObjective": {
                return Optional.ofNullable(clazz.cast(this.scalingPolicyObjective()));
            }
            case "Metric": {
                return Optional.ofNullable(clazz.cast(this.metric()));
            }
            case "DynamicScalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dynamicScalingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetScalingConfigurationRecommendationResponse, T> g) {
        return obj -> g.apply((GetScalingConfigurationRecommendationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String inferenceRecommendationsJobName;
        private String recommendationId;
        private String endpointName;
        private Integer targetCpuUtilizationPerCore;
        private ScalingPolicyObjective scalingPolicyObjective;
        private ScalingPolicyMetric metric;
        private DynamicScalingConfiguration dynamicScalingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScalingConfigurationRecommendationResponse model) {
            super(model);
            this.inferenceRecommendationsJobName(model.inferenceRecommendationsJobName);
            this.recommendationId(model.recommendationId);
            this.endpointName(model.endpointName);
            this.targetCpuUtilizationPerCore(model.targetCpuUtilizationPerCore);
            this.scalingPolicyObjective(model.scalingPolicyObjective);
            this.metric(model.metric);
            this.dynamicScalingConfiguration(model.dynamicScalingConfiguration);
        }

        public final String getInferenceRecommendationsJobName() {
            return this.inferenceRecommendationsJobName;
        }

        public final void setInferenceRecommendationsJobName(String inferenceRecommendationsJobName) {
            this.inferenceRecommendationsJobName = inferenceRecommendationsJobName;
        }

        @Override
        public final Builder inferenceRecommendationsJobName(String inferenceRecommendationsJobName) {
            this.inferenceRecommendationsJobName = inferenceRecommendationsJobName;
            return this;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final Integer getTargetCpuUtilizationPerCore() {
            return this.targetCpuUtilizationPerCore;
        }

        public final void setTargetCpuUtilizationPerCore(Integer targetCpuUtilizationPerCore) {
            this.targetCpuUtilizationPerCore = targetCpuUtilizationPerCore;
        }

        @Override
        public final Builder targetCpuUtilizationPerCore(Integer targetCpuUtilizationPerCore) {
            this.targetCpuUtilizationPerCore = targetCpuUtilizationPerCore;
            return this;
        }

        public final ScalingPolicyObjective.Builder getScalingPolicyObjective() {
            return this.scalingPolicyObjective != null ? this.scalingPolicyObjective.toBuilder() : null;
        }

        public final void setScalingPolicyObjective(ScalingPolicyObjective.BuilderImpl scalingPolicyObjective) {
            this.scalingPolicyObjective = scalingPolicyObjective != null ? scalingPolicyObjective.build() : null;
        }

        @Override
        public final Builder scalingPolicyObjective(ScalingPolicyObjective scalingPolicyObjective) {
            this.scalingPolicyObjective = scalingPolicyObjective;
            return this;
        }

        public final ScalingPolicyMetric.Builder getMetric() {
            return this.metric != null ? this.metric.toBuilder() : null;
        }

        public final void setMetric(ScalingPolicyMetric.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        @Override
        public final Builder metric(ScalingPolicyMetric metric) {
            this.metric = metric;
            return this;
        }

        public final DynamicScalingConfiguration.Builder getDynamicScalingConfiguration() {
            return this.dynamicScalingConfiguration != null ? this.dynamicScalingConfiguration.toBuilder() : null;
        }

        public final void setDynamicScalingConfiguration(DynamicScalingConfiguration.BuilderImpl dynamicScalingConfiguration) {
            this.dynamicScalingConfiguration = dynamicScalingConfiguration != null ? dynamicScalingConfiguration.build() : null;
        }

        @Override
        public final Builder dynamicScalingConfiguration(DynamicScalingConfiguration dynamicScalingConfiguration) {
            this.dynamicScalingConfiguration = dynamicScalingConfiguration;
            return this;
        }

        @Override
        public GetScalingConfigurationRecommendationResponse build() {
            return new GetScalingConfigurationRecommendationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetScalingConfigurationRecommendationResponse> {
        public Builder inferenceRecommendationsJobName(String var1);

        public Builder recommendationId(String var1);

        public Builder endpointName(String var1);

        public Builder targetCpuUtilizationPerCore(Integer var1);

        public Builder scalingPolicyObjective(ScalingPolicyObjective var1);

        default public Builder scalingPolicyObjective(Consumer<ScalingPolicyObjective.Builder> scalingPolicyObjective) {
            return this.scalingPolicyObjective((ScalingPolicyObjective)((ScalingPolicyObjective.Builder)ScalingPolicyObjective.builder().applyMutation(scalingPolicyObjective)).build());
        }

        public Builder metric(ScalingPolicyMetric var1);

        default public Builder metric(Consumer<ScalingPolicyMetric.Builder> metric) {
            return this.metric((ScalingPolicyMetric)((ScalingPolicyMetric.Builder)ScalingPolicyMetric.builder().applyMutation(metric)).build());
        }

        public Builder dynamicScalingConfiguration(DynamicScalingConfiguration var1);

        default public Builder dynamicScalingConfiguration(Consumer<DynamicScalingConfiguration.Builder> dynamicScalingConfiguration) {
            return this.dynamicScalingConfiguration((DynamicScalingConfiguration)((DynamicScalingConfiguration.Builder)DynamicScalingConfiguration.builder().applyMutation(dynamicScalingConfiguration)).build());
        }
    }
}

