/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningAllocationStrategy;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningInstanceConfig;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningInstanceConfigsCopier;
import software.amazon.awssdk.services.sagemaker.model.TrainingInstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperParameterTuningResourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HyperParameterTuningResourceConfig> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(HyperParameterTuningResourceConfig.getter(HyperParameterTuningResourceConfig::instanceTypeAsString)).setter(HyperParameterTuningResourceConfig.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(HyperParameterTuningResourceConfig.getter(HyperParameterTuningResourceConfig::instanceCount)).setter(HyperParameterTuningResourceConfig.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeSizeInGB").getter(HyperParameterTuningResourceConfig.getter(HyperParameterTuningResourceConfig::volumeSizeInGB)).setter(HyperParameterTuningResourceConfig.setter(Builder::volumeSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()}).build();
    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeKmsKeyId").getter(HyperParameterTuningResourceConfig.getter(HyperParameterTuningResourceConfig::volumeKmsKeyId)).setter(HyperParameterTuningResourceConfig.setter(Builder::volumeKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()}).build();
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationStrategy").getter(HyperParameterTuningResourceConfig.getter(HyperParameterTuningResourceConfig::allocationStrategyAsString)).setter(HyperParameterTuningResourceConfig.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy").build()}).build();
    private static final SdkField<List<HyperParameterTuningInstanceConfig>> INSTANCE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceConfigs").getter(HyperParameterTuningResourceConfig.getter(HyperParameterTuningResourceConfig::instanceConfigs)).setter(HyperParameterTuningResourceConfig.setter(Builder::instanceConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HyperParameterTuningInstanceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, INSTANCE_COUNT_FIELD, VOLUME_SIZE_IN_GB_FIELD, VOLUME_KMS_KEY_ID_FIELD, ALLOCATION_STRATEGY_FIELD, INSTANCE_CONFIGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final Integer instanceCount;
    private final Integer volumeSizeInGB;
    private final String volumeKmsKeyId;
    private final String allocationStrategy;
    private final List<HyperParameterTuningInstanceConfig> instanceConfigs;

    private HyperParameterTuningResourceConfig(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
        this.allocationStrategy = builder.allocationStrategy;
        this.instanceConfigs = builder.instanceConfigs;
    }

    public final TrainingInstanceType instanceType() {
        return TrainingInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final Integer volumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public final String volumeKmsKeyId() {
        return this.volumeKmsKeyId;
    }

    public final HyperParameterTuningAllocationStrategy allocationStrategy() {
        return HyperParameterTuningAllocationStrategy.fromValue(this.allocationStrategy);
    }

    public final String allocationStrategyAsString() {
        return this.allocationStrategy;
    }

    public final boolean hasInstanceConfigs() {
        return this.instanceConfigs != null && !(this.instanceConfigs instanceof SdkAutoConstructList);
    }

    public final List<HyperParameterTuningInstanceConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceConfigs() ? this.instanceConfigs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTuningResourceConfig)) {
            return false;
        }
        HyperParameterTuningResourceConfig other = (HyperParameterTuningResourceConfig)obj;
        return Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.volumeSizeInGB(), other.volumeSizeInGB()) && Objects.equals(this.volumeKmsKeyId(), other.volumeKmsKeyId()) && Objects.equals(this.allocationStrategyAsString(), other.allocationStrategyAsString()) && this.hasInstanceConfigs() == other.hasInstanceConfigs() && Objects.equals(this.instanceConfigs(), other.instanceConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"HyperParameterTuningResourceConfig").add("InstanceType", (Object)this.instanceTypeAsString()).add("InstanceCount", (Object)this.instanceCount()).add("VolumeSizeInGB", (Object)this.volumeSizeInGB()).add("VolumeKmsKeyId", (Object)this.volumeKmsKeyId()).add("AllocationStrategy", (Object)this.allocationStrategyAsString()).add("InstanceConfigs", this.hasInstanceConfigs() ? this.instanceConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "VolumeSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeInGB()));
            }
            case "VolumeKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.volumeKmsKeyId()));
            }
            case "AllocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategyAsString()));
            }
            case "InstanceConfigs": {
                return Optional.ofNullable(clazz.cast(this.instanceConfigs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTuningResourceConfig, T> g) {
        return obj -> g.apply((HyperParameterTuningResourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private Integer instanceCount;
        private Integer volumeSizeInGB;
        private String volumeKmsKeyId;
        private String allocationStrategy;
        private List<HyperParameterTuningInstanceConfig> instanceConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTuningResourceConfig model) {
            this.instanceType(model.instanceType);
            this.instanceCount(model.instanceCount);
            this.volumeSizeInGB(model.volumeSizeInGB);
            this.volumeKmsKeyId(model.volumeKmsKeyId);
            this.allocationStrategy(model.allocationStrategy);
            this.instanceConfigs(model.instanceConfigs);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(TrainingInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Integer getVolumeSizeInGB() {
            return this.volumeSizeInGB;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final String getVolumeKmsKeyId() {
            return this.volumeKmsKeyId;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        @Override
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(HyperParameterTuningAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        public final List<HyperParameterTuningInstanceConfig.Builder> getInstanceConfigs() {
            List<HyperParameterTuningInstanceConfig.Builder> result = HyperParameterTuningInstanceConfigsCopier.copyToBuilder(this.instanceConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceConfigs(Collection<HyperParameterTuningInstanceConfig.BuilderImpl> instanceConfigs) {
            this.instanceConfigs = HyperParameterTuningInstanceConfigsCopier.copyFromBuilder(instanceConfigs);
        }

        @Override
        public final Builder instanceConfigs(Collection<HyperParameterTuningInstanceConfig> instanceConfigs) {
            this.instanceConfigs = HyperParameterTuningInstanceConfigsCopier.copy(instanceConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceConfigs(HyperParameterTuningInstanceConfig ... instanceConfigs) {
            this.instanceConfigs(Arrays.asList(instanceConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceConfigs(Consumer<HyperParameterTuningInstanceConfig.Builder> ... instanceConfigs) {
            this.instanceConfigs(Stream.of(instanceConfigs).map(c -> (HyperParameterTuningInstanceConfig)((HyperParameterTuningInstanceConfig.Builder)HyperParameterTuningInstanceConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public HyperParameterTuningResourceConfig build() {
            return new HyperParameterTuningResourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HyperParameterTuningResourceConfig> {
        public Builder instanceType(String var1);

        public Builder instanceType(TrainingInstanceType var1);

        public Builder instanceCount(Integer var1);

        public Builder volumeSizeInGB(Integer var1);

        public Builder volumeKmsKeyId(String var1);

        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(HyperParameterTuningAllocationStrategy var1);

        public Builder instanceConfigs(Collection<HyperParameterTuningInstanceConfig> var1);

        public Builder instanceConfigs(HyperParameterTuningInstanceConfig ... var1);

        public Builder instanceConfigs(Consumer<HyperParameterTuningInstanceConfig.Builder> ... var1);
    }
}

