/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AutoMLCandidate;
import software.amazon.awssdk.services.sagemaker.model.AutoMLComputeConfig;
import software.amazon.awssdk.services.sagemaker.model.AutoMLDataSplitConfig;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobArtifacts;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobChannel;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobInputDataConfigCopier;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjective;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus;
import software.amazon.awssdk.services.sagemaker.model.AutoMLOutputDataConfig;
import software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReason;
import software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReasonsCopier;
import software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfig;
import software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfigName;
import software.amazon.awssdk.services.sagemaker.model.AutoMLResolvedAttributes;
import software.amazon.awssdk.services.sagemaker.model.AutoMLSecurityConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelDeployConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelDeployResult;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAutoMlJobV2Response
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeAutoMlJobV2Response> {
    private static final SdkField<String> AUTO_ML_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLJobName").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::autoMLJobName)).setter(DescribeAutoMlJobV2Response.setter(Builder::autoMLJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobName").build()}).build();
    private static final SdkField<String> AUTO_ML_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLJobArn").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::autoMLJobArn)).setter(DescribeAutoMlJobV2Response.setter(Builder::autoMLJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArn").build()}).build();
    private static final SdkField<List<AutoMLJobChannel>> AUTO_ML_JOB_INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutoMLJobInputDataConfig").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::autoMLJobInputDataConfig)).setter(DescribeAutoMlJobV2Response.setter(Builder::autoMLJobInputDataConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobInputDataConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoMLJobChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoMLOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputDataConfig").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::outputDataConfig)).setter(DescribeAutoMlJobV2Response.setter(Builder::outputDataConfig)).constructor(AutoMLOutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::roleArn)).setter(DescribeAutoMlJobV2Response.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<AutoMLJobObjective> AUTO_ML_JOB_OBJECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMLJobObjective").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::autoMLJobObjective)).setter(DescribeAutoMlJobV2Response.setter(Builder::autoMLJobObjective)).constructor(AutoMLJobObjective::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobObjective").build()}).build();
    private static final SdkField<AutoMLProblemTypeConfig> AUTO_ML_PROBLEM_TYPE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMLProblemTypeConfig").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::autoMLProblemTypeConfig)).setter(DescribeAutoMlJobV2Response.setter(Builder::autoMLProblemTypeConfig)).constructor(AutoMLProblemTypeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLProblemTypeConfig").build()}).build();
    private static final SdkField<String> AUTO_ML_PROBLEM_TYPE_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLProblemTypeConfigName").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::autoMLProblemTypeConfigNameAsString)).setter(DescribeAutoMlJobV2Response.setter(Builder::autoMLProblemTypeConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLProblemTypeConfigName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::creationTime)).setter(DescribeAutoMlJobV2Response.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::endTime)).setter(DescribeAutoMlJobV2Response.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::lastModifiedTime)).setter(DescribeAutoMlJobV2Response.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::failureReason)).setter(DescribeAutoMlJobV2Response.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<List<AutoMLPartialFailureReason>> PARTIAL_FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartialFailureReasons").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::partialFailureReasons)).setter(DescribeAutoMlJobV2Response.setter(Builder::partialFailureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartialFailureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoMLPartialFailureReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoMLCandidate> BEST_CANDIDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BestCandidate").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::bestCandidate)).setter(DescribeAutoMlJobV2Response.setter(Builder::bestCandidate)).constructor(AutoMLCandidate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestCandidate").build()}).build();
    private static final SdkField<String> AUTO_ML_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLJobStatus").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::autoMLJobStatusAsString)).setter(DescribeAutoMlJobV2Response.setter(Builder::autoMLJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobStatus").build()}).build();
    private static final SdkField<String> AUTO_ML_JOB_SECONDARY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLJobSecondaryStatus").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::autoMLJobSecondaryStatusAsString)).setter(DescribeAutoMlJobV2Response.setter(Builder::autoMLJobSecondaryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobSecondaryStatus").build()}).build();
    private static final SdkField<AutoMLJobArtifacts> AUTO_ML_JOB_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMLJobArtifacts").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::autoMLJobArtifacts)).setter(DescribeAutoMlJobV2Response.setter(Builder::autoMLJobArtifacts)).constructor(AutoMLJobArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArtifacts").build()}).build();
    private static final SdkField<AutoMLResolvedAttributes> RESOLVED_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResolvedAttributes").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::resolvedAttributes)).setter(DescribeAutoMlJobV2Response.setter(Builder::resolvedAttributes)).constructor(AutoMLResolvedAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedAttributes").build()}).build();
    private static final SdkField<ModelDeployConfig> MODEL_DEPLOY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelDeployConfig").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::modelDeployConfig)).setter(DescribeAutoMlJobV2Response.setter(Builder::modelDeployConfig)).constructor(ModelDeployConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDeployConfig").build()}).build();
    private static final SdkField<ModelDeployResult> MODEL_DEPLOY_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelDeployResult").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::modelDeployResult)).setter(DescribeAutoMlJobV2Response.setter(Builder::modelDeployResult)).constructor(ModelDeployResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDeployResult").build()}).build();
    private static final SdkField<AutoMLDataSplitConfig> DATA_SPLIT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSplitConfig").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::dataSplitConfig)).setter(DescribeAutoMlJobV2Response.setter(Builder::dataSplitConfig)).constructor(AutoMLDataSplitConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSplitConfig").build()}).build();
    private static final SdkField<AutoMLSecurityConfig> SECURITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityConfig").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::securityConfig)).setter(DescribeAutoMlJobV2Response.setter(Builder::securityConfig)).constructor(AutoMLSecurityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfig").build()}).build();
    private static final SdkField<AutoMLComputeConfig> AUTO_ML_COMPUTE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMLComputeConfig").getter(DescribeAutoMlJobV2Response.getter(DescribeAutoMlJobV2Response::autoMLComputeConfig)).setter(DescribeAutoMlJobV2Response.setter(Builder::autoMLComputeConfig)).constructor(AutoMLComputeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLComputeConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_NAME_FIELD, AUTO_ML_JOB_ARN_FIELD, AUTO_ML_JOB_INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, ROLE_ARN_FIELD, AUTO_ML_JOB_OBJECTIVE_FIELD, AUTO_ML_PROBLEM_TYPE_CONFIG_FIELD, AUTO_ML_PROBLEM_TYPE_CONFIG_NAME_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, PARTIAL_FAILURE_REASONS_FIELD, BEST_CANDIDATE_FIELD, AUTO_ML_JOB_STATUS_FIELD, AUTO_ML_JOB_SECONDARY_STATUS_FIELD, AUTO_ML_JOB_ARTIFACTS_FIELD, RESOLVED_ATTRIBUTES_FIELD, MODEL_DEPLOY_CONFIG_FIELD, MODEL_DEPLOY_RESULT_FIELD, DATA_SPLIT_CONFIG_FIELD, SECURITY_CONFIG_FIELD, AUTO_ML_COMPUTE_CONFIG_FIELD));
    private final String autoMLJobName;
    private final String autoMLJobArn;
    private final List<AutoMLJobChannel> autoMLJobInputDataConfig;
    private final AutoMLOutputDataConfig outputDataConfig;
    private final String roleArn;
    private final AutoMLJobObjective autoMLJobObjective;
    private final AutoMLProblemTypeConfig autoMLProblemTypeConfig;
    private final String autoMLProblemTypeConfigName;
    private final Instant creationTime;
    private final Instant endTime;
    private final Instant lastModifiedTime;
    private final String failureReason;
    private final List<AutoMLPartialFailureReason> partialFailureReasons;
    private final AutoMLCandidate bestCandidate;
    private final String autoMLJobStatus;
    private final String autoMLJobSecondaryStatus;
    private final AutoMLJobArtifacts autoMLJobArtifacts;
    private final AutoMLResolvedAttributes resolvedAttributes;
    private final ModelDeployConfig modelDeployConfig;
    private final ModelDeployResult modelDeployResult;
    private final AutoMLDataSplitConfig dataSplitConfig;
    private final AutoMLSecurityConfig securityConfig;
    private final AutoMLComputeConfig autoMLComputeConfig;

    private DescribeAutoMlJobV2Response(BuilderImpl builder) {
        super(builder);
        this.autoMLJobName = builder.autoMLJobName;
        this.autoMLJobArn = builder.autoMLJobArn;
        this.autoMLJobInputDataConfig = builder.autoMLJobInputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.roleArn = builder.roleArn;
        this.autoMLJobObjective = builder.autoMLJobObjective;
        this.autoMLProblemTypeConfig = builder.autoMLProblemTypeConfig;
        this.autoMLProblemTypeConfigName = builder.autoMLProblemTypeConfigName;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.partialFailureReasons = builder.partialFailureReasons;
        this.bestCandidate = builder.bestCandidate;
        this.autoMLJobStatus = builder.autoMLJobStatus;
        this.autoMLJobSecondaryStatus = builder.autoMLJobSecondaryStatus;
        this.autoMLJobArtifacts = builder.autoMLJobArtifacts;
        this.resolvedAttributes = builder.resolvedAttributes;
        this.modelDeployConfig = builder.modelDeployConfig;
        this.modelDeployResult = builder.modelDeployResult;
        this.dataSplitConfig = builder.dataSplitConfig;
        this.securityConfig = builder.securityConfig;
        this.autoMLComputeConfig = builder.autoMLComputeConfig;
    }

    public final String autoMLJobName() {
        return this.autoMLJobName;
    }

    public final String autoMLJobArn() {
        return this.autoMLJobArn;
    }

    public final boolean hasAutoMLJobInputDataConfig() {
        return this.autoMLJobInputDataConfig != null && !(this.autoMLJobInputDataConfig instanceof SdkAutoConstructList);
    }

    public final List<AutoMLJobChannel> autoMLJobInputDataConfig() {
        return this.autoMLJobInputDataConfig;
    }

    public final AutoMLOutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final AutoMLJobObjective autoMLJobObjective() {
        return this.autoMLJobObjective;
    }

    public final AutoMLProblemTypeConfig autoMLProblemTypeConfig() {
        return this.autoMLProblemTypeConfig;
    }

    public final AutoMLProblemTypeConfigName autoMLProblemTypeConfigName() {
        return AutoMLProblemTypeConfigName.fromValue(this.autoMLProblemTypeConfigName);
    }

    public final String autoMLProblemTypeConfigNameAsString() {
        return this.autoMLProblemTypeConfigName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final boolean hasPartialFailureReasons() {
        return this.partialFailureReasons != null && !(this.partialFailureReasons instanceof SdkAutoConstructList);
    }

    public final List<AutoMLPartialFailureReason> partialFailureReasons() {
        return this.partialFailureReasons;
    }

    public final AutoMLCandidate bestCandidate() {
        return this.bestCandidate;
    }

    public final AutoMLJobStatus autoMLJobStatus() {
        return AutoMLJobStatus.fromValue(this.autoMLJobStatus);
    }

    public final String autoMLJobStatusAsString() {
        return this.autoMLJobStatus;
    }

    public final AutoMLJobSecondaryStatus autoMLJobSecondaryStatus() {
        return AutoMLJobSecondaryStatus.fromValue(this.autoMLJobSecondaryStatus);
    }

    public final String autoMLJobSecondaryStatusAsString() {
        return this.autoMLJobSecondaryStatus;
    }

    public final AutoMLJobArtifacts autoMLJobArtifacts() {
        return this.autoMLJobArtifacts;
    }

    public final AutoMLResolvedAttributes resolvedAttributes() {
        return this.resolvedAttributes;
    }

    public final ModelDeployConfig modelDeployConfig() {
        return this.modelDeployConfig;
    }

    public final ModelDeployResult modelDeployResult() {
        return this.modelDeployResult;
    }

    public final AutoMLDataSplitConfig dataSplitConfig() {
        return this.dataSplitConfig;
    }

    public final AutoMLSecurityConfig securityConfig() {
        return this.securityConfig;
    }

    public final AutoMLComputeConfig autoMLComputeConfig() {
        return this.autoMLComputeConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoMLJobInputDataConfig() ? this.autoMLJobInputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobObjective());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLProblemTypeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLProblemTypeConfigNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartialFailureReasons() ? this.partialFailureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.bestCandidate());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobSecondaryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDeployConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDeployResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSplitConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLComputeConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoMlJobV2Response)) {
            return false;
        }
        DescribeAutoMlJobV2Response other = (DescribeAutoMlJobV2Response)((Object)obj);
        return Objects.equals(this.autoMLJobName(), other.autoMLJobName()) && Objects.equals(this.autoMLJobArn(), other.autoMLJobArn()) && this.hasAutoMLJobInputDataConfig() == other.hasAutoMLJobInputDataConfig() && Objects.equals(this.autoMLJobInputDataConfig(), other.autoMLJobInputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.autoMLJobObjective(), other.autoMLJobObjective()) && Objects.equals(this.autoMLProblemTypeConfig(), other.autoMLProblemTypeConfig()) && Objects.equals(this.autoMLProblemTypeConfigNameAsString(), other.autoMLProblemTypeConfigNameAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.failureReason(), other.failureReason()) && this.hasPartialFailureReasons() == other.hasPartialFailureReasons() && Objects.equals(this.partialFailureReasons(), other.partialFailureReasons()) && Objects.equals(this.bestCandidate(), other.bestCandidate()) && Objects.equals(this.autoMLJobStatusAsString(), other.autoMLJobStatusAsString()) && Objects.equals(this.autoMLJobSecondaryStatusAsString(), other.autoMLJobSecondaryStatusAsString()) && Objects.equals(this.autoMLJobArtifacts(), other.autoMLJobArtifacts()) && Objects.equals(this.resolvedAttributes(), other.resolvedAttributes()) && Objects.equals(this.modelDeployConfig(), other.modelDeployConfig()) && Objects.equals(this.modelDeployResult(), other.modelDeployResult()) && Objects.equals(this.dataSplitConfig(), other.dataSplitConfig()) && Objects.equals(this.securityConfig(), other.securityConfig()) && Objects.equals(this.autoMLComputeConfig(), other.autoMLComputeConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAutoMlJobV2Response").add("AutoMLJobName", (Object)this.autoMLJobName()).add("AutoMLJobArn", (Object)this.autoMLJobArn()).add("AutoMLJobInputDataConfig", this.hasAutoMLJobInputDataConfig() ? this.autoMLJobInputDataConfig() : null).add("OutputDataConfig", (Object)this.outputDataConfig()).add("RoleArn", (Object)this.roleArn()).add("AutoMLJobObjective", (Object)this.autoMLJobObjective()).add("AutoMLProblemTypeConfig", (Object)this.autoMLProblemTypeConfig()).add("AutoMLProblemTypeConfigName", (Object)this.autoMLProblemTypeConfigNameAsString()).add("CreationTime", (Object)this.creationTime()).add("EndTime", (Object)this.endTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("FailureReason", (Object)this.failureReason()).add("PartialFailureReasons", this.hasPartialFailureReasons() ? this.partialFailureReasons() : null).add("BestCandidate", (Object)this.bestCandidate()).add("AutoMLJobStatus", (Object)this.autoMLJobStatusAsString()).add("AutoMLJobSecondaryStatus", (Object)this.autoMLJobSecondaryStatusAsString()).add("AutoMLJobArtifacts", (Object)this.autoMLJobArtifacts()).add("ResolvedAttributes", (Object)this.resolvedAttributes()).add("ModelDeployConfig", (Object)this.modelDeployConfig()).add("ModelDeployResult", (Object)this.modelDeployResult()).add("DataSplitConfig", (Object)this.dataSplitConfig()).add("SecurityConfig", (Object)this.securityConfig()).add("AutoMLComputeConfig", (Object)this.autoMLComputeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoMLJobName": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobName()));
            }
            case "AutoMLJobArn": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobArn()));
            }
            case "AutoMLJobInputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobInputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "AutoMLJobObjective": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobObjective()));
            }
            case "AutoMLProblemTypeConfig": {
                return Optional.ofNullable(clazz.cast(this.autoMLProblemTypeConfig()));
            }
            case "AutoMLProblemTypeConfigName": {
                return Optional.ofNullable(clazz.cast(this.autoMLProblemTypeConfigNameAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "PartialFailureReasons": {
                return Optional.ofNullable(clazz.cast(this.partialFailureReasons()));
            }
            case "BestCandidate": {
                return Optional.ofNullable(clazz.cast(this.bestCandidate()));
            }
            case "AutoMLJobStatus": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobStatusAsString()));
            }
            case "AutoMLJobSecondaryStatus": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobSecondaryStatusAsString()));
            }
            case "AutoMLJobArtifacts": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobArtifacts()));
            }
            case "ResolvedAttributes": {
                return Optional.ofNullable(clazz.cast(this.resolvedAttributes()));
            }
            case "ModelDeployConfig": {
                return Optional.ofNullable(clazz.cast(this.modelDeployConfig()));
            }
            case "ModelDeployResult": {
                return Optional.ofNullable(clazz.cast(this.modelDeployResult()));
            }
            case "DataSplitConfig": {
                return Optional.ofNullable(clazz.cast(this.dataSplitConfig()));
            }
            case "SecurityConfig": {
                return Optional.ofNullable(clazz.cast(this.securityConfig()));
            }
            case "AutoMLComputeConfig": {
                return Optional.ofNullable(clazz.cast(this.autoMLComputeConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutoMlJobV2Response, T> g) {
        return obj -> g.apply((DescribeAutoMlJobV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String autoMLJobName;
        private String autoMLJobArn;
        private List<AutoMLJobChannel> autoMLJobInputDataConfig = DefaultSdkAutoConstructList.getInstance();
        private AutoMLOutputDataConfig outputDataConfig;
        private String roleArn;
        private AutoMLJobObjective autoMLJobObjective;
        private AutoMLProblemTypeConfig autoMLProblemTypeConfig;
        private String autoMLProblemTypeConfigName;
        private Instant creationTime;
        private Instant endTime;
        private Instant lastModifiedTime;
        private String failureReason;
        private List<AutoMLPartialFailureReason> partialFailureReasons = DefaultSdkAutoConstructList.getInstance();
        private AutoMLCandidate bestCandidate;
        private String autoMLJobStatus;
        private String autoMLJobSecondaryStatus;
        private AutoMLJobArtifacts autoMLJobArtifacts;
        private AutoMLResolvedAttributes resolvedAttributes;
        private ModelDeployConfig modelDeployConfig;
        private ModelDeployResult modelDeployResult;
        private AutoMLDataSplitConfig dataSplitConfig;
        private AutoMLSecurityConfig securityConfig;
        private AutoMLComputeConfig autoMLComputeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoMlJobV2Response model) {
            super(model);
            this.autoMLJobName(model.autoMLJobName);
            this.autoMLJobArn(model.autoMLJobArn);
            this.autoMLJobInputDataConfig(model.autoMLJobInputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.roleArn(model.roleArn);
            this.autoMLJobObjective(model.autoMLJobObjective);
            this.autoMLProblemTypeConfig(model.autoMLProblemTypeConfig);
            this.autoMLProblemTypeConfigName(model.autoMLProblemTypeConfigName);
            this.creationTime(model.creationTime);
            this.endTime(model.endTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.failureReason(model.failureReason);
            this.partialFailureReasons(model.partialFailureReasons);
            this.bestCandidate(model.bestCandidate);
            this.autoMLJobStatus(model.autoMLJobStatus);
            this.autoMLJobSecondaryStatus(model.autoMLJobSecondaryStatus);
            this.autoMLJobArtifacts(model.autoMLJobArtifacts);
            this.resolvedAttributes(model.resolvedAttributes);
            this.modelDeployConfig(model.modelDeployConfig);
            this.modelDeployResult(model.modelDeployResult);
            this.dataSplitConfig(model.dataSplitConfig);
            this.securityConfig(model.securityConfig);
            this.autoMLComputeConfig(model.autoMLComputeConfig);
        }

        public final String getAutoMLJobName() {
            return this.autoMLJobName;
        }

        public final void setAutoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
        }

        @Override
        public final Builder autoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
            return this;
        }

        public final String getAutoMLJobArn() {
            return this.autoMLJobArn;
        }

        public final void setAutoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
        }

        @Override
        public final Builder autoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
            return this;
        }

        public final List<AutoMLJobChannel.Builder> getAutoMLJobInputDataConfig() {
            List<AutoMLJobChannel.Builder> result = AutoMLJobInputDataConfigCopier.copyToBuilder(this.autoMLJobInputDataConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoMLJobInputDataConfig(Collection<AutoMLJobChannel.BuilderImpl> autoMLJobInputDataConfig) {
            this.autoMLJobInputDataConfig = AutoMLJobInputDataConfigCopier.copyFromBuilder(autoMLJobInputDataConfig);
        }

        @Override
        public final Builder autoMLJobInputDataConfig(Collection<AutoMLJobChannel> autoMLJobInputDataConfig) {
            this.autoMLJobInputDataConfig = AutoMLJobInputDataConfigCopier.copy(autoMLJobInputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLJobInputDataConfig(AutoMLJobChannel ... autoMLJobInputDataConfig) {
            this.autoMLJobInputDataConfig(Arrays.asList(autoMLJobInputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLJobInputDataConfig(Consumer<AutoMLJobChannel.Builder> ... autoMLJobInputDataConfig) {
            this.autoMLJobInputDataConfig(Stream.of(autoMLJobInputDataConfig).map(c -> (AutoMLJobChannel)((AutoMLJobChannel.Builder)AutoMLJobChannel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutoMLOutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(AutoMLOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(AutoMLOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final AutoMLJobObjective.Builder getAutoMLJobObjective() {
            return this.autoMLJobObjective != null ? this.autoMLJobObjective.toBuilder() : null;
        }

        public final void setAutoMLJobObjective(AutoMLJobObjective.BuilderImpl autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective != null ? autoMLJobObjective.build() : null;
        }

        @Override
        public final Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective;
            return this;
        }

        public final AutoMLProblemTypeConfig.Builder getAutoMLProblemTypeConfig() {
            return this.autoMLProblemTypeConfig != null ? this.autoMLProblemTypeConfig.toBuilder() : null;
        }

        public final void setAutoMLProblemTypeConfig(AutoMLProblemTypeConfig.BuilderImpl autoMLProblemTypeConfig) {
            this.autoMLProblemTypeConfig = autoMLProblemTypeConfig != null ? autoMLProblemTypeConfig.build() : null;
        }

        @Override
        public final Builder autoMLProblemTypeConfig(AutoMLProblemTypeConfig autoMLProblemTypeConfig) {
            this.autoMLProblemTypeConfig = autoMLProblemTypeConfig;
            return this;
        }

        public final String getAutoMLProblemTypeConfigName() {
            return this.autoMLProblemTypeConfigName;
        }

        public final void setAutoMLProblemTypeConfigName(String autoMLProblemTypeConfigName) {
            this.autoMLProblemTypeConfigName = autoMLProblemTypeConfigName;
        }

        @Override
        public final Builder autoMLProblemTypeConfigName(String autoMLProblemTypeConfigName) {
            this.autoMLProblemTypeConfigName = autoMLProblemTypeConfigName;
            return this;
        }

        @Override
        public final Builder autoMLProblemTypeConfigName(AutoMLProblemTypeConfigName autoMLProblemTypeConfigName) {
            this.autoMLProblemTypeConfigName(autoMLProblemTypeConfigName == null ? null : autoMLProblemTypeConfigName.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final List<AutoMLPartialFailureReason.Builder> getPartialFailureReasons() {
            List<AutoMLPartialFailureReason.Builder> result = AutoMLPartialFailureReasonsCopier.copyToBuilder(this.partialFailureReasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartialFailureReasons(Collection<AutoMLPartialFailureReason.BuilderImpl> partialFailureReasons) {
            this.partialFailureReasons = AutoMLPartialFailureReasonsCopier.copyFromBuilder(partialFailureReasons);
        }

        @Override
        public final Builder partialFailureReasons(Collection<AutoMLPartialFailureReason> partialFailureReasons) {
            this.partialFailureReasons = AutoMLPartialFailureReasonsCopier.copy(partialFailureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partialFailureReasons(AutoMLPartialFailureReason ... partialFailureReasons) {
            this.partialFailureReasons(Arrays.asList(partialFailureReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partialFailureReasons(Consumer<AutoMLPartialFailureReason.Builder> ... partialFailureReasons) {
            this.partialFailureReasons(Stream.of(partialFailureReasons).map(c -> (AutoMLPartialFailureReason)((AutoMLPartialFailureReason.Builder)AutoMLPartialFailureReason.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutoMLCandidate.Builder getBestCandidate() {
            return this.bestCandidate != null ? this.bestCandidate.toBuilder() : null;
        }

        public final void setBestCandidate(AutoMLCandidate.BuilderImpl bestCandidate) {
            this.bestCandidate = bestCandidate != null ? bestCandidate.build() : null;
        }

        @Override
        public final Builder bestCandidate(AutoMLCandidate bestCandidate) {
            this.bestCandidate = bestCandidate;
            return this;
        }

        public final String getAutoMLJobStatus() {
            return this.autoMLJobStatus;
        }

        public final void setAutoMLJobStatus(String autoMLJobStatus) {
            this.autoMLJobStatus = autoMLJobStatus;
        }

        @Override
        public final Builder autoMLJobStatus(String autoMLJobStatus) {
            this.autoMLJobStatus = autoMLJobStatus;
            return this;
        }

        @Override
        public final Builder autoMLJobStatus(AutoMLJobStatus autoMLJobStatus) {
            this.autoMLJobStatus(autoMLJobStatus == null ? null : autoMLJobStatus.toString());
            return this;
        }

        public final String getAutoMLJobSecondaryStatus() {
            return this.autoMLJobSecondaryStatus;
        }

        public final void setAutoMLJobSecondaryStatus(String autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus = autoMLJobSecondaryStatus;
        }

        @Override
        public final Builder autoMLJobSecondaryStatus(String autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus = autoMLJobSecondaryStatus;
            return this;
        }

        @Override
        public final Builder autoMLJobSecondaryStatus(AutoMLJobSecondaryStatus autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus(autoMLJobSecondaryStatus == null ? null : autoMLJobSecondaryStatus.toString());
            return this;
        }

        public final AutoMLJobArtifacts.Builder getAutoMLJobArtifacts() {
            return this.autoMLJobArtifacts != null ? this.autoMLJobArtifacts.toBuilder() : null;
        }

        public final void setAutoMLJobArtifacts(AutoMLJobArtifacts.BuilderImpl autoMLJobArtifacts) {
            this.autoMLJobArtifacts = autoMLJobArtifacts != null ? autoMLJobArtifacts.build() : null;
        }

        @Override
        public final Builder autoMLJobArtifacts(AutoMLJobArtifacts autoMLJobArtifacts) {
            this.autoMLJobArtifacts = autoMLJobArtifacts;
            return this;
        }

        public final AutoMLResolvedAttributes.Builder getResolvedAttributes() {
            return this.resolvedAttributes != null ? this.resolvedAttributes.toBuilder() : null;
        }

        public final void setResolvedAttributes(AutoMLResolvedAttributes.BuilderImpl resolvedAttributes) {
            this.resolvedAttributes = resolvedAttributes != null ? resolvedAttributes.build() : null;
        }

        @Override
        public final Builder resolvedAttributes(AutoMLResolvedAttributes resolvedAttributes) {
            this.resolvedAttributes = resolvedAttributes;
            return this;
        }

        public final ModelDeployConfig.Builder getModelDeployConfig() {
            return this.modelDeployConfig != null ? this.modelDeployConfig.toBuilder() : null;
        }

        public final void setModelDeployConfig(ModelDeployConfig.BuilderImpl modelDeployConfig) {
            this.modelDeployConfig = modelDeployConfig != null ? modelDeployConfig.build() : null;
        }

        @Override
        public final Builder modelDeployConfig(ModelDeployConfig modelDeployConfig) {
            this.modelDeployConfig = modelDeployConfig;
            return this;
        }

        public final ModelDeployResult.Builder getModelDeployResult() {
            return this.modelDeployResult != null ? this.modelDeployResult.toBuilder() : null;
        }

        public final void setModelDeployResult(ModelDeployResult.BuilderImpl modelDeployResult) {
            this.modelDeployResult = modelDeployResult != null ? modelDeployResult.build() : null;
        }

        @Override
        public final Builder modelDeployResult(ModelDeployResult modelDeployResult) {
            this.modelDeployResult = modelDeployResult;
            return this;
        }

        public final AutoMLDataSplitConfig.Builder getDataSplitConfig() {
            return this.dataSplitConfig != null ? this.dataSplitConfig.toBuilder() : null;
        }

        public final void setDataSplitConfig(AutoMLDataSplitConfig.BuilderImpl dataSplitConfig) {
            this.dataSplitConfig = dataSplitConfig != null ? dataSplitConfig.build() : null;
        }

        @Override
        public final Builder dataSplitConfig(AutoMLDataSplitConfig dataSplitConfig) {
            this.dataSplitConfig = dataSplitConfig;
            return this;
        }

        public final AutoMLSecurityConfig.Builder getSecurityConfig() {
            return this.securityConfig != null ? this.securityConfig.toBuilder() : null;
        }

        public final void setSecurityConfig(AutoMLSecurityConfig.BuilderImpl securityConfig) {
            this.securityConfig = securityConfig != null ? securityConfig.build() : null;
        }

        @Override
        public final Builder securityConfig(AutoMLSecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        public final AutoMLComputeConfig.Builder getAutoMLComputeConfig() {
            return this.autoMLComputeConfig != null ? this.autoMLComputeConfig.toBuilder() : null;
        }

        public final void setAutoMLComputeConfig(AutoMLComputeConfig.BuilderImpl autoMLComputeConfig) {
            this.autoMLComputeConfig = autoMLComputeConfig != null ? autoMLComputeConfig.build() : null;
        }

        @Override
        public final Builder autoMLComputeConfig(AutoMLComputeConfig autoMLComputeConfig) {
            this.autoMLComputeConfig = autoMLComputeConfig;
            return this;
        }

        @Override
        public DescribeAutoMlJobV2Response build() {
            return new DescribeAutoMlJobV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAutoMlJobV2Response> {
        public Builder autoMLJobName(String var1);

        public Builder autoMLJobArn(String var1);

        public Builder autoMLJobInputDataConfig(Collection<AutoMLJobChannel> var1);

        public Builder autoMLJobInputDataConfig(AutoMLJobChannel ... var1);

        public Builder autoMLJobInputDataConfig(Consumer<AutoMLJobChannel.Builder> ... var1);

        public Builder outputDataConfig(AutoMLOutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<AutoMLOutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((AutoMLOutputDataConfig)((AutoMLOutputDataConfig.Builder)AutoMLOutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder autoMLJobObjective(AutoMLJobObjective var1);

        default public Builder autoMLJobObjective(Consumer<AutoMLJobObjective.Builder> autoMLJobObjective) {
            return this.autoMLJobObjective((AutoMLJobObjective)((AutoMLJobObjective.Builder)AutoMLJobObjective.builder().applyMutation(autoMLJobObjective)).build());
        }

        public Builder autoMLProblemTypeConfig(AutoMLProblemTypeConfig var1);

        default public Builder autoMLProblemTypeConfig(Consumer<AutoMLProblemTypeConfig.Builder> autoMLProblemTypeConfig) {
            return this.autoMLProblemTypeConfig((AutoMLProblemTypeConfig)((AutoMLProblemTypeConfig.Builder)AutoMLProblemTypeConfig.builder().applyMutation(autoMLProblemTypeConfig)).build());
        }

        public Builder autoMLProblemTypeConfigName(String var1);

        public Builder autoMLProblemTypeConfigName(AutoMLProblemTypeConfigName var1);

        public Builder creationTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder partialFailureReasons(Collection<AutoMLPartialFailureReason> var1);

        public Builder partialFailureReasons(AutoMLPartialFailureReason ... var1);

        public Builder partialFailureReasons(Consumer<AutoMLPartialFailureReason.Builder> ... var1);

        public Builder bestCandidate(AutoMLCandidate var1);

        default public Builder bestCandidate(Consumer<AutoMLCandidate.Builder> bestCandidate) {
            return this.bestCandidate((AutoMLCandidate)((AutoMLCandidate.Builder)AutoMLCandidate.builder().applyMutation(bestCandidate)).build());
        }

        public Builder autoMLJobStatus(String var1);

        public Builder autoMLJobStatus(AutoMLJobStatus var1);

        public Builder autoMLJobSecondaryStatus(String var1);

        public Builder autoMLJobSecondaryStatus(AutoMLJobSecondaryStatus var1);

        public Builder autoMLJobArtifacts(AutoMLJobArtifacts var1);

        default public Builder autoMLJobArtifacts(Consumer<AutoMLJobArtifacts.Builder> autoMLJobArtifacts) {
            return this.autoMLJobArtifacts((AutoMLJobArtifacts)((AutoMLJobArtifacts.Builder)AutoMLJobArtifacts.builder().applyMutation(autoMLJobArtifacts)).build());
        }

        public Builder resolvedAttributes(AutoMLResolvedAttributes var1);

        default public Builder resolvedAttributes(Consumer<AutoMLResolvedAttributes.Builder> resolvedAttributes) {
            return this.resolvedAttributes((AutoMLResolvedAttributes)((AutoMLResolvedAttributes.Builder)AutoMLResolvedAttributes.builder().applyMutation(resolvedAttributes)).build());
        }

        public Builder modelDeployConfig(ModelDeployConfig var1);

        default public Builder modelDeployConfig(Consumer<ModelDeployConfig.Builder> modelDeployConfig) {
            return this.modelDeployConfig((ModelDeployConfig)((ModelDeployConfig.Builder)ModelDeployConfig.builder().applyMutation(modelDeployConfig)).build());
        }

        public Builder modelDeployResult(ModelDeployResult var1);

        default public Builder modelDeployResult(Consumer<ModelDeployResult.Builder> modelDeployResult) {
            return this.modelDeployResult((ModelDeployResult)((ModelDeployResult.Builder)ModelDeployResult.builder().applyMutation(modelDeployResult)).build());
        }

        public Builder dataSplitConfig(AutoMLDataSplitConfig var1);

        default public Builder dataSplitConfig(Consumer<AutoMLDataSplitConfig.Builder> dataSplitConfig) {
            return this.dataSplitConfig((AutoMLDataSplitConfig)((AutoMLDataSplitConfig.Builder)AutoMLDataSplitConfig.builder().applyMutation(dataSplitConfig)).build());
        }

        public Builder securityConfig(AutoMLSecurityConfig var1);

        default public Builder securityConfig(Consumer<AutoMLSecurityConfig.Builder> securityConfig) {
            return this.securityConfig((AutoMLSecurityConfig)((AutoMLSecurityConfig.Builder)AutoMLSecurityConfig.builder().applyMutation(securityConfig)).build());
        }

        public Builder autoMLComputeConfig(AutoMLComputeConfig var1);

        default public Builder autoMLComputeConfig(Consumer<AutoMLComputeConfig.Builder> autoMLComputeConfig) {
            return this.autoMLComputeConfig((AutoMLComputeConfig)((AutoMLComputeConfig.Builder)AutoMLComputeConfig.builder().applyMutation(autoMLComputeConfig)).build());
        }
    }
}

