/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CanvasAppSettings;
import software.amazon.awssdk.services.sagemaker.model.CodeEditorAppSettings;
import software.amazon.awssdk.services.sagemaker.model.CustomFileSystemConfig;
import software.amazon.awssdk.services.sagemaker.model.CustomFileSystemConfigsCopier;
import software.amazon.awssdk.services.sagemaker.model.CustomPosixUserConfig;
import software.amazon.awssdk.services.sagemaker.model.DefaultSpaceStorageSettings;
import software.amazon.awssdk.services.sagemaker.model.JupyterLabAppSettings;
import software.amazon.awssdk.services.sagemaker.model.JupyterServerAppSettings;
import software.amazon.awssdk.services.sagemaker.model.KernelGatewayAppSettings;
import software.amazon.awssdk.services.sagemaker.model.RSessionAppSettings;
import software.amazon.awssdk.services.sagemaker.model.RStudioServerProAppSettings;
import software.amazon.awssdk.services.sagemaker.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.services.sagemaker.model.SharingSettings;
import software.amazon.awssdk.services.sagemaker.model.StudioWebPortal;
import software.amazon.awssdk.services.sagemaker.model.StudioWebPortalSettings;
import software.amazon.awssdk.services.sagemaker.model.TensorBoardAppSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserSettings> {
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRole").getter(UserSettings.getter(UserSettings::executionRole)).setter(UserSettings.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(UserSettings.getter(UserSettings::securityGroups)).setter(UserSettings.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SharingSettings> SHARING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SharingSettings").getter(UserSettings.getter(UserSettings::sharingSettings)).setter(UserSettings.setter(Builder::sharingSettings)).constructor(SharingSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharingSettings").build()}).build();
    private static final SdkField<JupyterServerAppSettings> JUPYTER_SERVER_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JupyterServerAppSettings").getter(UserSettings.getter(UserSettings::jupyterServerAppSettings)).setter(UserSettings.setter(Builder::jupyterServerAppSettings)).constructor(JupyterServerAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterServerAppSettings").build()}).build();
    private static final SdkField<KernelGatewayAppSettings> KERNEL_GATEWAY_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KernelGatewayAppSettings").getter(UserSettings.getter(UserSettings::kernelGatewayAppSettings)).setter(UserSettings.setter(Builder::kernelGatewayAppSettings)).constructor(KernelGatewayAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelGatewayAppSettings").build()}).build();
    private static final SdkField<TensorBoardAppSettings> TENSOR_BOARD_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TensorBoardAppSettings").getter(UserSettings.getter(UserSettings::tensorBoardAppSettings)).setter(UserSettings.setter(Builder::tensorBoardAppSettings)).constructor(TensorBoardAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TensorBoardAppSettings").build()}).build();
    private static final SdkField<RStudioServerProAppSettings> R_STUDIO_SERVER_PRO_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RStudioServerProAppSettings").getter(UserSettings.getter(UserSettings::rStudioServerProAppSettings)).setter(UserSettings.setter(Builder::rStudioServerProAppSettings)).constructor(RStudioServerProAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RStudioServerProAppSettings").build()}).build();
    private static final SdkField<RSessionAppSettings> R_SESSION_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RSessionAppSettings").getter(UserSettings.getter(UserSettings::rSessionAppSettings)).setter(UserSettings.setter(Builder::rSessionAppSettings)).constructor(RSessionAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RSessionAppSettings").build()}).build();
    private static final SdkField<CanvasAppSettings> CANVAS_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CanvasAppSettings").getter(UserSettings.getter(UserSettings::canvasAppSettings)).setter(UserSettings.setter(Builder::canvasAppSettings)).constructor(CanvasAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanvasAppSettings").build()}).build();
    private static final SdkField<CodeEditorAppSettings> CODE_EDITOR_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodeEditorAppSettings").getter(UserSettings.getter(UserSettings::codeEditorAppSettings)).setter(UserSettings.setter(Builder::codeEditorAppSettings)).constructor(CodeEditorAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeEditorAppSettings").build()}).build();
    private static final SdkField<JupyterLabAppSettings> JUPYTER_LAB_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JupyterLabAppSettings").getter(UserSettings.getter(UserSettings::jupyterLabAppSettings)).setter(UserSettings.setter(Builder::jupyterLabAppSettings)).constructor(JupyterLabAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterLabAppSettings").build()}).build();
    private static final SdkField<DefaultSpaceStorageSettings> SPACE_STORAGE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpaceStorageSettings").getter(UserSettings.getter(UserSettings::spaceStorageSettings)).setter(UserSettings.setter(Builder::spaceStorageSettings)).constructor(DefaultSpaceStorageSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceStorageSettings").build()}).build();
    private static final SdkField<String> DEFAULT_LANDING_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultLandingUri").getter(UserSettings.getter(UserSettings::defaultLandingUri)).setter(UserSettings.setter(Builder::defaultLandingUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultLandingUri").build()}).build();
    private static final SdkField<String> STUDIO_WEB_PORTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StudioWebPortal").getter(UserSettings.getter(UserSettings::studioWebPortalAsString)).setter(UserSettings.setter(Builder::studioWebPortal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioWebPortal").build()}).build();
    private static final SdkField<CustomPosixUserConfig> CUSTOM_POSIX_USER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomPosixUserConfig").getter(UserSettings.getter(UserSettings::customPosixUserConfig)).setter(UserSettings.setter(Builder::customPosixUserConfig)).constructor(CustomPosixUserConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPosixUserConfig").build()}).build();
    private static final SdkField<List<CustomFileSystemConfig>> CUSTOM_FILE_SYSTEM_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomFileSystemConfigs").getter(UserSettings.getter(UserSettings::customFileSystemConfigs)).setter(UserSettings.setter(Builder::customFileSystemConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomFileSystemConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomFileSystemConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StudioWebPortalSettings> STUDIO_WEB_PORTAL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StudioWebPortalSettings").getter(UserSettings.getter(UserSettings::studioWebPortalSettings)).setter(UserSettings.setter(Builder::studioWebPortalSettings)).constructor(StudioWebPortalSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioWebPortalSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ROLE_FIELD, SECURITY_GROUPS_FIELD, SHARING_SETTINGS_FIELD, JUPYTER_SERVER_APP_SETTINGS_FIELD, KERNEL_GATEWAY_APP_SETTINGS_FIELD, TENSOR_BOARD_APP_SETTINGS_FIELD, R_STUDIO_SERVER_PRO_APP_SETTINGS_FIELD, R_SESSION_APP_SETTINGS_FIELD, CANVAS_APP_SETTINGS_FIELD, CODE_EDITOR_APP_SETTINGS_FIELD, JUPYTER_LAB_APP_SETTINGS_FIELD, SPACE_STORAGE_SETTINGS_FIELD, DEFAULT_LANDING_URI_FIELD, STUDIO_WEB_PORTAL_FIELD, CUSTOM_POSIX_USER_CONFIG_FIELD, CUSTOM_FILE_SYSTEM_CONFIGS_FIELD, STUDIO_WEB_PORTAL_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String executionRole;
    private final List<String> securityGroups;
    private final SharingSettings sharingSettings;
    private final JupyterServerAppSettings jupyterServerAppSettings;
    private final KernelGatewayAppSettings kernelGatewayAppSettings;
    private final TensorBoardAppSettings tensorBoardAppSettings;
    private final RStudioServerProAppSettings rStudioServerProAppSettings;
    private final RSessionAppSettings rSessionAppSettings;
    private final CanvasAppSettings canvasAppSettings;
    private final CodeEditorAppSettings codeEditorAppSettings;
    private final JupyterLabAppSettings jupyterLabAppSettings;
    private final DefaultSpaceStorageSettings spaceStorageSettings;
    private final String defaultLandingUri;
    private final String studioWebPortal;
    private final CustomPosixUserConfig customPosixUserConfig;
    private final List<CustomFileSystemConfig> customFileSystemConfigs;
    private final StudioWebPortalSettings studioWebPortalSettings;

    private UserSettings(BuilderImpl builder) {
        this.executionRole = builder.executionRole;
        this.securityGroups = builder.securityGroups;
        this.sharingSettings = builder.sharingSettings;
        this.jupyterServerAppSettings = builder.jupyterServerAppSettings;
        this.kernelGatewayAppSettings = builder.kernelGatewayAppSettings;
        this.tensorBoardAppSettings = builder.tensorBoardAppSettings;
        this.rStudioServerProAppSettings = builder.rStudioServerProAppSettings;
        this.rSessionAppSettings = builder.rSessionAppSettings;
        this.canvasAppSettings = builder.canvasAppSettings;
        this.codeEditorAppSettings = builder.codeEditorAppSettings;
        this.jupyterLabAppSettings = builder.jupyterLabAppSettings;
        this.spaceStorageSettings = builder.spaceStorageSettings;
        this.defaultLandingUri = builder.defaultLandingUri;
        this.studioWebPortal = builder.studioWebPortal;
        this.customPosixUserConfig = builder.customPosixUserConfig;
        this.customFileSystemConfigs = builder.customFileSystemConfigs;
        this.studioWebPortalSettings = builder.studioWebPortalSettings;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final SharingSettings sharingSettings() {
        return this.sharingSettings;
    }

    public final JupyterServerAppSettings jupyterServerAppSettings() {
        return this.jupyterServerAppSettings;
    }

    public final KernelGatewayAppSettings kernelGatewayAppSettings() {
        return this.kernelGatewayAppSettings;
    }

    public final TensorBoardAppSettings tensorBoardAppSettings() {
        return this.tensorBoardAppSettings;
    }

    public final RStudioServerProAppSettings rStudioServerProAppSettings() {
        return this.rStudioServerProAppSettings;
    }

    public final RSessionAppSettings rSessionAppSettings() {
        return this.rSessionAppSettings;
    }

    public final CanvasAppSettings canvasAppSettings() {
        return this.canvasAppSettings;
    }

    public final CodeEditorAppSettings codeEditorAppSettings() {
        return this.codeEditorAppSettings;
    }

    public final JupyterLabAppSettings jupyterLabAppSettings() {
        return this.jupyterLabAppSettings;
    }

    public final DefaultSpaceStorageSettings spaceStorageSettings() {
        return this.spaceStorageSettings;
    }

    public final String defaultLandingUri() {
        return this.defaultLandingUri;
    }

    public final StudioWebPortal studioWebPortal() {
        return StudioWebPortal.fromValue(this.studioWebPortal);
    }

    public final String studioWebPortalAsString() {
        return this.studioWebPortal;
    }

    public final CustomPosixUserConfig customPosixUserConfig() {
        return this.customPosixUserConfig;
    }

    public final boolean hasCustomFileSystemConfigs() {
        return this.customFileSystemConfigs != null && !(this.customFileSystemConfigs instanceof SdkAutoConstructList);
    }

    public final List<CustomFileSystemConfig> customFileSystemConfigs() {
        return this.customFileSystemConfigs;
    }

    public final StudioWebPortalSettings studioWebPortalSettings() {
        return this.studioWebPortalSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sharingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.jupyterServerAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelGatewayAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.tensorBoardAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.rStudioServerProAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.rSessionAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.canvasAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeEditorAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.jupyterLabAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceStorageSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultLandingUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioWebPortalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPosixUserConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomFileSystemConfigs() ? this.customFileSystemConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.studioWebPortalSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSettings)) {
            return false;
        }
        UserSettings other = (UserSettings)obj;
        return Objects.equals(this.executionRole(), other.executionRole()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.sharingSettings(), other.sharingSettings()) && Objects.equals(this.jupyterServerAppSettings(), other.jupyterServerAppSettings()) && Objects.equals(this.kernelGatewayAppSettings(), other.kernelGatewayAppSettings()) && Objects.equals(this.tensorBoardAppSettings(), other.tensorBoardAppSettings()) && Objects.equals(this.rStudioServerProAppSettings(), other.rStudioServerProAppSettings()) && Objects.equals(this.rSessionAppSettings(), other.rSessionAppSettings()) && Objects.equals(this.canvasAppSettings(), other.canvasAppSettings()) && Objects.equals(this.codeEditorAppSettings(), other.codeEditorAppSettings()) && Objects.equals(this.jupyterLabAppSettings(), other.jupyterLabAppSettings()) && Objects.equals(this.spaceStorageSettings(), other.spaceStorageSettings()) && Objects.equals(this.defaultLandingUri(), other.defaultLandingUri()) && Objects.equals(this.studioWebPortalAsString(), other.studioWebPortalAsString()) && Objects.equals(this.customPosixUserConfig(), other.customPosixUserConfig()) && this.hasCustomFileSystemConfigs() == other.hasCustomFileSystemConfigs() && Objects.equals(this.customFileSystemConfigs(), other.customFileSystemConfigs()) && Objects.equals(this.studioWebPortalSettings(), other.studioWebPortalSettings());
    }

    public final String toString() {
        return ToString.builder((String)"UserSettings").add("ExecutionRole", (Object)this.executionRole()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("SharingSettings", (Object)this.sharingSettings()).add("JupyterServerAppSettings", (Object)this.jupyterServerAppSettings()).add("KernelGatewayAppSettings", (Object)this.kernelGatewayAppSettings()).add("TensorBoardAppSettings", (Object)this.tensorBoardAppSettings()).add("RStudioServerProAppSettings", (Object)this.rStudioServerProAppSettings()).add("RSessionAppSettings", (Object)this.rSessionAppSettings()).add("CanvasAppSettings", (Object)this.canvasAppSettings()).add("CodeEditorAppSettings", (Object)this.codeEditorAppSettings()).add("JupyterLabAppSettings", (Object)this.jupyterLabAppSettings()).add("SpaceStorageSettings", (Object)this.spaceStorageSettings()).add("DefaultLandingUri", (Object)this.defaultLandingUri()).add("StudioWebPortal", (Object)this.studioWebPortalAsString()).add("CustomPosixUserConfig", (Object)this.customPosixUserConfig()).add("CustomFileSystemConfigs", this.hasCustomFileSystemConfigs() ? this.customFileSystemConfigs() : null).add("StudioWebPortalSettings", (Object)this.studioWebPortalSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "SharingSettings": {
                return Optional.ofNullable(clazz.cast(this.sharingSettings()));
            }
            case "JupyterServerAppSettings": {
                return Optional.ofNullable(clazz.cast(this.jupyterServerAppSettings()));
            }
            case "KernelGatewayAppSettings": {
                return Optional.ofNullable(clazz.cast(this.kernelGatewayAppSettings()));
            }
            case "TensorBoardAppSettings": {
                return Optional.ofNullable(clazz.cast(this.tensorBoardAppSettings()));
            }
            case "RStudioServerProAppSettings": {
                return Optional.ofNullable(clazz.cast(this.rStudioServerProAppSettings()));
            }
            case "RSessionAppSettings": {
                return Optional.ofNullable(clazz.cast(this.rSessionAppSettings()));
            }
            case "CanvasAppSettings": {
                return Optional.ofNullable(clazz.cast(this.canvasAppSettings()));
            }
            case "CodeEditorAppSettings": {
                return Optional.ofNullable(clazz.cast(this.codeEditorAppSettings()));
            }
            case "JupyterLabAppSettings": {
                return Optional.ofNullable(clazz.cast(this.jupyterLabAppSettings()));
            }
            case "SpaceStorageSettings": {
                return Optional.ofNullable(clazz.cast(this.spaceStorageSettings()));
            }
            case "DefaultLandingUri": {
                return Optional.ofNullable(clazz.cast(this.defaultLandingUri()));
            }
            case "StudioWebPortal": {
                return Optional.ofNullable(clazz.cast(this.studioWebPortalAsString()));
            }
            case "CustomPosixUserConfig": {
                return Optional.ofNullable(clazz.cast(this.customPosixUserConfig()));
            }
            case "CustomFileSystemConfigs": {
                return Optional.ofNullable(clazz.cast(this.customFileSystemConfigs()));
            }
            case "StudioWebPortalSettings": {
                return Optional.ofNullable(clazz.cast(this.studioWebPortalSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserSettings, T> g) {
        return obj -> g.apply((UserSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionRole;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private SharingSettings sharingSettings;
        private JupyterServerAppSettings jupyterServerAppSettings;
        private KernelGatewayAppSettings kernelGatewayAppSettings;
        private TensorBoardAppSettings tensorBoardAppSettings;
        private RStudioServerProAppSettings rStudioServerProAppSettings;
        private RSessionAppSettings rSessionAppSettings;
        private CanvasAppSettings canvasAppSettings;
        private CodeEditorAppSettings codeEditorAppSettings;
        private JupyterLabAppSettings jupyterLabAppSettings;
        private DefaultSpaceStorageSettings spaceStorageSettings;
        private String defaultLandingUri;
        private String studioWebPortal;
        private CustomPosixUserConfig customPosixUserConfig;
        private List<CustomFileSystemConfig> customFileSystemConfigs = DefaultSdkAutoConstructList.getInstance();
        private StudioWebPortalSettings studioWebPortalSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSettings model) {
            this.executionRole(model.executionRole);
            this.securityGroups(model.securityGroups);
            this.sharingSettings(model.sharingSettings);
            this.jupyterServerAppSettings(model.jupyterServerAppSettings);
            this.kernelGatewayAppSettings(model.kernelGatewayAppSettings);
            this.tensorBoardAppSettings(model.tensorBoardAppSettings);
            this.rStudioServerProAppSettings(model.rStudioServerProAppSettings);
            this.rSessionAppSettings(model.rSessionAppSettings);
            this.canvasAppSettings(model.canvasAppSettings);
            this.codeEditorAppSettings(model.codeEditorAppSettings);
            this.jupyterLabAppSettings(model.jupyterLabAppSettings);
            this.spaceStorageSettings(model.spaceStorageSettings);
            this.defaultLandingUri(model.defaultLandingUri);
            this.studioWebPortal(model.studioWebPortal);
            this.customPosixUserConfig(model.customPosixUserConfig);
            this.customFileSystemConfigs(model.customFileSystemConfigs);
            this.studioWebPortalSettings(model.studioWebPortalSettings);
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final SharingSettings.Builder getSharingSettings() {
            return this.sharingSettings != null ? this.sharingSettings.toBuilder() : null;
        }

        public final void setSharingSettings(SharingSettings.BuilderImpl sharingSettings) {
            this.sharingSettings = sharingSettings != null ? sharingSettings.build() : null;
        }

        @Override
        public final Builder sharingSettings(SharingSettings sharingSettings) {
            this.sharingSettings = sharingSettings;
            return this;
        }

        public final JupyterServerAppSettings.Builder getJupyterServerAppSettings() {
            return this.jupyterServerAppSettings != null ? this.jupyterServerAppSettings.toBuilder() : null;
        }

        public final void setJupyterServerAppSettings(JupyterServerAppSettings.BuilderImpl jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings != null ? jupyterServerAppSettings.build() : null;
        }

        @Override
        public final Builder jupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings;
            return this;
        }

        public final KernelGatewayAppSettings.Builder getKernelGatewayAppSettings() {
            return this.kernelGatewayAppSettings != null ? this.kernelGatewayAppSettings.toBuilder() : null;
        }

        public final void setKernelGatewayAppSettings(KernelGatewayAppSettings.BuilderImpl kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings != null ? kernelGatewayAppSettings.build() : null;
        }

        @Override
        public final Builder kernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings;
            return this;
        }

        public final TensorBoardAppSettings.Builder getTensorBoardAppSettings() {
            return this.tensorBoardAppSettings != null ? this.tensorBoardAppSettings.toBuilder() : null;
        }

        public final void setTensorBoardAppSettings(TensorBoardAppSettings.BuilderImpl tensorBoardAppSettings) {
            this.tensorBoardAppSettings = tensorBoardAppSettings != null ? tensorBoardAppSettings.build() : null;
        }

        @Override
        public final Builder tensorBoardAppSettings(TensorBoardAppSettings tensorBoardAppSettings) {
            this.tensorBoardAppSettings = tensorBoardAppSettings;
            return this;
        }

        public final RStudioServerProAppSettings.Builder getRStudioServerProAppSettings() {
            return this.rStudioServerProAppSettings != null ? this.rStudioServerProAppSettings.toBuilder() : null;
        }

        public final void setRStudioServerProAppSettings(RStudioServerProAppSettings.BuilderImpl rStudioServerProAppSettings) {
            this.rStudioServerProAppSettings = rStudioServerProAppSettings != null ? rStudioServerProAppSettings.build() : null;
        }

        @Override
        public final Builder rStudioServerProAppSettings(RStudioServerProAppSettings rStudioServerProAppSettings) {
            this.rStudioServerProAppSettings = rStudioServerProAppSettings;
            return this;
        }

        public final RSessionAppSettings.Builder getRSessionAppSettings() {
            return this.rSessionAppSettings != null ? this.rSessionAppSettings.toBuilder() : null;
        }

        public final void setRSessionAppSettings(RSessionAppSettings.BuilderImpl rSessionAppSettings) {
            this.rSessionAppSettings = rSessionAppSettings != null ? rSessionAppSettings.build() : null;
        }

        @Override
        public final Builder rSessionAppSettings(RSessionAppSettings rSessionAppSettings) {
            this.rSessionAppSettings = rSessionAppSettings;
            return this;
        }

        public final CanvasAppSettings.Builder getCanvasAppSettings() {
            return this.canvasAppSettings != null ? this.canvasAppSettings.toBuilder() : null;
        }

        public final void setCanvasAppSettings(CanvasAppSettings.BuilderImpl canvasAppSettings) {
            this.canvasAppSettings = canvasAppSettings != null ? canvasAppSettings.build() : null;
        }

        @Override
        public final Builder canvasAppSettings(CanvasAppSettings canvasAppSettings) {
            this.canvasAppSettings = canvasAppSettings;
            return this;
        }

        public final CodeEditorAppSettings.Builder getCodeEditorAppSettings() {
            return this.codeEditorAppSettings != null ? this.codeEditorAppSettings.toBuilder() : null;
        }

        public final void setCodeEditorAppSettings(CodeEditorAppSettings.BuilderImpl codeEditorAppSettings) {
            this.codeEditorAppSettings = codeEditorAppSettings != null ? codeEditorAppSettings.build() : null;
        }

        @Override
        public final Builder codeEditorAppSettings(CodeEditorAppSettings codeEditorAppSettings) {
            this.codeEditorAppSettings = codeEditorAppSettings;
            return this;
        }

        public final JupyterLabAppSettings.Builder getJupyterLabAppSettings() {
            return this.jupyterLabAppSettings != null ? this.jupyterLabAppSettings.toBuilder() : null;
        }

        public final void setJupyterLabAppSettings(JupyterLabAppSettings.BuilderImpl jupyterLabAppSettings) {
            this.jupyterLabAppSettings = jupyterLabAppSettings != null ? jupyterLabAppSettings.build() : null;
        }

        @Override
        public final Builder jupyterLabAppSettings(JupyterLabAppSettings jupyterLabAppSettings) {
            this.jupyterLabAppSettings = jupyterLabAppSettings;
            return this;
        }

        public final DefaultSpaceStorageSettings.Builder getSpaceStorageSettings() {
            return this.spaceStorageSettings != null ? this.spaceStorageSettings.toBuilder() : null;
        }

        public final void setSpaceStorageSettings(DefaultSpaceStorageSettings.BuilderImpl spaceStorageSettings) {
            this.spaceStorageSettings = spaceStorageSettings != null ? spaceStorageSettings.build() : null;
        }

        @Override
        public final Builder spaceStorageSettings(DefaultSpaceStorageSettings spaceStorageSettings) {
            this.spaceStorageSettings = spaceStorageSettings;
            return this;
        }

        public final String getDefaultLandingUri() {
            return this.defaultLandingUri;
        }

        public final void setDefaultLandingUri(String defaultLandingUri) {
            this.defaultLandingUri = defaultLandingUri;
        }

        @Override
        public final Builder defaultLandingUri(String defaultLandingUri) {
            this.defaultLandingUri = defaultLandingUri;
            return this;
        }

        public final String getStudioWebPortal() {
            return this.studioWebPortal;
        }

        public final void setStudioWebPortal(String studioWebPortal) {
            this.studioWebPortal = studioWebPortal;
        }

        @Override
        public final Builder studioWebPortal(String studioWebPortal) {
            this.studioWebPortal = studioWebPortal;
            return this;
        }

        @Override
        public final Builder studioWebPortal(StudioWebPortal studioWebPortal) {
            this.studioWebPortal(studioWebPortal == null ? null : studioWebPortal.toString());
            return this;
        }

        public final CustomPosixUserConfig.Builder getCustomPosixUserConfig() {
            return this.customPosixUserConfig != null ? this.customPosixUserConfig.toBuilder() : null;
        }

        public final void setCustomPosixUserConfig(CustomPosixUserConfig.BuilderImpl customPosixUserConfig) {
            this.customPosixUserConfig = customPosixUserConfig != null ? customPosixUserConfig.build() : null;
        }

        @Override
        public final Builder customPosixUserConfig(CustomPosixUserConfig customPosixUserConfig) {
            this.customPosixUserConfig = customPosixUserConfig;
            return this;
        }

        public final List<CustomFileSystemConfig.Builder> getCustomFileSystemConfigs() {
            List<CustomFileSystemConfig.Builder> result = CustomFileSystemConfigsCopier.copyToBuilder(this.customFileSystemConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomFileSystemConfigs(Collection<CustomFileSystemConfig.BuilderImpl> customFileSystemConfigs) {
            this.customFileSystemConfigs = CustomFileSystemConfigsCopier.copyFromBuilder(customFileSystemConfigs);
        }

        @Override
        public final Builder customFileSystemConfigs(Collection<CustomFileSystemConfig> customFileSystemConfigs) {
            this.customFileSystemConfigs = CustomFileSystemConfigsCopier.copy(customFileSystemConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFileSystemConfigs(CustomFileSystemConfig ... customFileSystemConfigs) {
            this.customFileSystemConfigs(Arrays.asList(customFileSystemConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFileSystemConfigs(Consumer<CustomFileSystemConfig.Builder> ... customFileSystemConfigs) {
            this.customFileSystemConfigs(Stream.of(customFileSystemConfigs).map(c -> (CustomFileSystemConfig)((CustomFileSystemConfig.Builder)CustomFileSystemConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StudioWebPortalSettings.Builder getStudioWebPortalSettings() {
            return this.studioWebPortalSettings != null ? this.studioWebPortalSettings.toBuilder() : null;
        }

        public final void setStudioWebPortalSettings(StudioWebPortalSettings.BuilderImpl studioWebPortalSettings) {
            this.studioWebPortalSettings = studioWebPortalSettings != null ? studioWebPortalSettings.build() : null;
        }

        @Override
        public final Builder studioWebPortalSettings(StudioWebPortalSettings studioWebPortalSettings) {
            this.studioWebPortalSettings = studioWebPortalSettings;
            return this;
        }

        public UserSettings build() {
            return new UserSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserSettings> {
        public Builder executionRole(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder sharingSettings(SharingSettings var1);

        default public Builder sharingSettings(Consumer<SharingSettings.Builder> sharingSettings) {
            return this.sharingSettings((SharingSettings)((SharingSettings.Builder)SharingSettings.builder().applyMutation(sharingSettings)).build());
        }

        public Builder jupyterServerAppSettings(JupyterServerAppSettings var1);

        default public Builder jupyterServerAppSettings(Consumer<JupyterServerAppSettings.Builder> jupyterServerAppSettings) {
            return this.jupyterServerAppSettings((JupyterServerAppSettings)((JupyterServerAppSettings.Builder)JupyterServerAppSettings.builder().applyMutation(jupyterServerAppSettings)).build());
        }

        public Builder kernelGatewayAppSettings(KernelGatewayAppSettings var1);

        default public Builder kernelGatewayAppSettings(Consumer<KernelGatewayAppSettings.Builder> kernelGatewayAppSettings) {
            return this.kernelGatewayAppSettings((KernelGatewayAppSettings)((KernelGatewayAppSettings.Builder)KernelGatewayAppSettings.builder().applyMutation(kernelGatewayAppSettings)).build());
        }

        public Builder tensorBoardAppSettings(TensorBoardAppSettings var1);

        default public Builder tensorBoardAppSettings(Consumer<TensorBoardAppSettings.Builder> tensorBoardAppSettings) {
            return this.tensorBoardAppSettings((TensorBoardAppSettings)((TensorBoardAppSettings.Builder)TensorBoardAppSettings.builder().applyMutation(tensorBoardAppSettings)).build());
        }

        public Builder rStudioServerProAppSettings(RStudioServerProAppSettings var1);

        default public Builder rStudioServerProAppSettings(Consumer<RStudioServerProAppSettings.Builder> rStudioServerProAppSettings) {
            return this.rStudioServerProAppSettings((RStudioServerProAppSettings)((RStudioServerProAppSettings.Builder)RStudioServerProAppSettings.builder().applyMutation(rStudioServerProAppSettings)).build());
        }

        public Builder rSessionAppSettings(RSessionAppSettings var1);

        default public Builder rSessionAppSettings(Consumer<RSessionAppSettings.Builder> rSessionAppSettings) {
            return this.rSessionAppSettings((RSessionAppSettings)((RSessionAppSettings.Builder)RSessionAppSettings.builder().applyMutation(rSessionAppSettings)).build());
        }

        public Builder canvasAppSettings(CanvasAppSettings var1);

        default public Builder canvasAppSettings(Consumer<CanvasAppSettings.Builder> canvasAppSettings) {
            return this.canvasAppSettings((CanvasAppSettings)((CanvasAppSettings.Builder)CanvasAppSettings.builder().applyMutation(canvasAppSettings)).build());
        }

        public Builder codeEditorAppSettings(CodeEditorAppSettings var1);

        default public Builder codeEditorAppSettings(Consumer<CodeEditorAppSettings.Builder> codeEditorAppSettings) {
            return this.codeEditorAppSettings((CodeEditorAppSettings)((CodeEditorAppSettings.Builder)CodeEditorAppSettings.builder().applyMutation(codeEditorAppSettings)).build());
        }

        public Builder jupyterLabAppSettings(JupyterLabAppSettings var1);

        default public Builder jupyterLabAppSettings(Consumer<JupyterLabAppSettings.Builder> jupyterLabAppSettings) {
            return this.jupyterLabAppSettings((JupyterLabAppSettings)((JupyterLabAppSettings.Builder)JupyterLabAppSettings.builder().applyMutation(jupyterLabAppSettings)).build());
        }

        public Builder spaceStorageSettings(DefaultSpaceStorageSettings var1);

        default public Builder spaceStorageSettings(Consumer<DefaultSpaceStorageSettings.Builder> spaceStorageSettings) {
            return this.spaceStorageSettings((DefaultSpaceStorageSettings)((DefaultSpaceStorageSettings.Builder)DefaultSpaceStorageSettings.builder().applyMutation(spaceStorageSettings)).build());
        }

        public Builder defaultLandingUri(String var1);

        public Builder studioWebPortal(String var1);

        public Builder studioWebPortal(StudioWebPortal var1);

        public Builder customPosixUserConfig(CustomPosixUserConfig var1);

        default public Builder customPosixUserConfig(Consumer<CustomPosixUserConfig.Builder> customPosixUserConfig) {
            return this.customPosixUserConfig((CustomPosixUserConfig)((CustomPosixUserConfig.Builder)CustomPosixUserConfig.builder().applyMutation(customPosixUserConfig)).build());
        }

        public Builder customFileSystemConfigs(Collection<CustomFileSystemConfig> var1);

        public Builder customFileSystemConfigs(CustomFileSystemConfig ... var1);

        public Builder customFileSystemConfigs(Consumer<CustomFileSystemConfig.Builder> ... var1);

        public Builder studioWebPortalSettings(StudioWebPortalSettings var1);

        default public Builder studioWebPortalSettings(Consumer<StudioWebPortalSettings.Builder> studioWebPortalSettings) {
            return this.studioWebPortalSettings((StudioWebPortalSettings)((StudioWebPortalSettings.Builder)StudioWebPortalSettings.builder().applyMutation(studioWebPortalSettings)).build());
        }
    }
}

