/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShadowModelVariantConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShadowModelVariantConfig> {
    private static final SdkField<String> SHADOW_MODEL_VARIANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShadowModelVariantName").getter(ShadowModelVariantConfig.getter(ShadowModelVariantConfig::shadowModelVariantName)).setter(ShadowModelVariantConfig.setter(Builder::shadowModelVariantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShadowModelVariantName").build()}).build();
    private static final SdkField<Integer> SAMPLING_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SamplingPercentage").getter(ShadowModelVariantConfig.getter(ShadowModelVariantConfig::samplingPercentage)).setter(ShadowModelVariantConfig.setter(Builder::samplingPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHADOW_MODEL_VARIANT_NAME_FIELD, SAMPLING_PERCENTAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String shadowModelVariantName;
    private final Integer samplingPercentage;

    private ShadowModelVariantConfig(BuilderImpl builder) {
        this.shadowModelVariantName = builder.shadowModelVariantName;
        this.samplingPercentage = builder.samplingPercentage;
    }

    public final String shadowModelVariantName() {
        return this.shadowModelVariantName;
    }

    public final Integer samplingPercentage() {
        return this.samplingPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowModelVariantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShadowModelVariantConfig)) {
            return false;
        }
        ShadowModelVariantConfig other = (ShadowModelVariantConfig)obj;
        return Objects.equals(this.shadowModelVariantName(), other.shadowModelVariantName()) && Objects.equals(this.samplingPercentage(), other.samplingPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"ShadowModelVariantConfig").add("ShadowModelVariantName", (Object)this.shadowModelVariantName()).add("SamplingPercentage", (Object)this.samplingPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShadowModelVariantName": {
                return Optional.ofNullable(clazz.cast(this.shadowModelVariantName()));
            }
            case "SamplingPercentage": {
                return Optional.ofNullable(clazz.cast(this.samplingPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShadowModelVariantConfig, T> g) {
        return obj -> g.apply((ShadowModelVariantConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String shadowModelVariantName;
        private Integer samplingPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(ShadowModelVariantConfig model) {
            this.shadowModelVariantName(model.shadowModelVariantName);
            this.samplingPercentage(model.samplingPercentage);
        }

        public final String getShadowModelVariantName() {
            return this.shadowModelVariantName;
        }

        public final void setShadowModelVariantName(String shadowModelVariantName) {
            this.shadowModelVariantName = shadowModelVariantName;
        }

        @Override
        public final Builder shadowModelVariantName(String shadowModelVariantName) {
            this.shadowModelVariantName = shadowModelVariantName;
            return this;
        }

        public final Integer getSamplingPercentage() {
            return this.samplingPercentage;
        }

        public final void setSamplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
        }

        @Override
        public final Builder samplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
            return this;
        }

        public ShadowModelVariantConfig build() {
            return new ShadowModelVariantConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShadowModelVariantConfig> {
        public Builder shadowModelVariantName(String var1);

        public Builder samplingPercentage(Integer var1);
    }
}

