/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobS3DataSource;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobSnsDataSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelingJobDataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LabelingJobDataSource> {
    private static final SdkField<LabelingJobS3DataSource> S3_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3DataSource").getter(LabelingJobDataSource.getter(LabelingJobDataSource::s3DataSource)).setter(LabelingJobDataSource.setter(Builder::s3DataSource)).constructor(LabelingJobS3DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataSource").build()}).build();
    private static final SdkField<LabelingJobSnsDataSource> SNS_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnsDataSource").getter(LabelingJobDataSource.getter(LabelingJobDataSource::snsDataSource)).setter(LabelingJobDataSource.setter(Builder::snsDataSource)).constructor(LabelingJobSnsDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsDataSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_SOURCE_FIELD, SNS_DATA_SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final LabelingJobS3DataSource s3DataSource;
    private final LabelingJobSnsDataSource snsDataSource;

    private LabelingJobDataSource(BuilderImpl builder) {
        this.s3DataSource = builder.s3DataSource;
        this.snsDataSource = builder.snsDataSource;
    }

    public final LabelingJobS3DataSource s3DataSource() {
        return this.s3DataSource;
    }

    public final LabelingJobSnsDataSource snsDataSource() {
        return this.snsDataSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsDataSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobDataSource)) {
            return false;
        }
        LabelingJobDataSource other = (LabelingJobDataSource)obj;
        return Objects.equals(this.s3DataSource(), other.s3DataSource()) && Objects.equals(this.snsDataSource(), other.snsDataSource());
    }

    public final String toString() {
        return ToString.builder((String)"LabelingJobDataSource").add("S3DataSource", (Object)this.s3DataSource()).add("SnsDataSource", (Object)this.snsDataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3DataSource": {
                return Optional.ofNullable(clazz.cast(this.s3DataSource()));
            }
            case "SnsDataSource": {
                return Optional.ofNullable(clazz.cast(this.snsDataSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobDataSource, T> g) {
        return obj -> g.apply((LabelingJobDataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LabelingJobS3DataSource s3DataSource;
        private LabelingJobSnsDataSource snsDataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobDataSource model) {
            this.s3DataSource(model.s3DataSource);
            this.snsDataSource(model.snsDataSource);
        }

        public final LabelingJobS3DataSource.Builder getS3DataSource() {
            return this.s3DataSource != null ? this.s3DataSource.toBuilder() : null;
        }

        public final void setS3DataSource(LabelingJobS3DataSource.BuilderImpl s3DataSource) {
            this.s3DataSource = s3DataSource != null ? s3DataSource.build() : null;
        }

        @Override
        public final Builder s3DataSource(LabelingJobS3DataSource s3DataSource) {
            this.s3DataSource = s3DataSource;
            return this;
        }

        public final LabelingJobSnsDataSource.Builder getSnsDataSource() {
            return this.snsDataSource != null ? this.snsDataSource.toBuilder() : null;
        }

        public final void setSnsDataSource(LabelingJobSnsDataSource.BuilderImpl snsDataSource) {
            this.snsDataSource = snsDataSource != null ? snsDataSource.build() : null;
        }

        @Override
        public final Builder snsDataSource(LabelingJobSnsDataSource snsDataSource) {
            this.snsDataSource = snsDataSource;
            return this;
        }

        public LabelingJobDataSource build() {
            return new LabelingJobDataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LabelingJobDataSource> {
        public Builder s3DataSource(LabelingJobS3DataSource var1);

        default public Builder s3DataSource(Consumer<LabelingJobS3DataSource.Builder> s3DataSource) {
            return this.s3DataSource((LabelingJobS3DataSource)((LabelingJobS3DataSource.Builder)LabelingJobS3DataSource.builder().applyMutation(s3DataSource)).build());
        }

        public Builder snsDataSource(LabelingJobSnsDataSource var1);

        default public Builder snsDataSource(Consumer<LabelingJobSnsDataSource.Builder> snsDataSource) {
            return this.snsDataSource((LabelingJobSnsDataSource)((LabelingJobSnsDataSource.Builder)LabelingJobSnsDataSource.builder().applyMutation(snsDataSource)).build());
        }
    }
}

