/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.ImageClassificationJobConfig;
import software.amazon.awssdk.services.sagemaker.model.TabularJobConfig;
import software.amazon.awssdk.services.sagemaker.model.TextClassificationJobConfig;
import software.amazon.awssdk.services.sagemaker.model.TextGenerationJobConfig;
import software.amazon.awssdk.services.sagemaker.model.TimeSeriesForecastingJobConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoMLProblemTypeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoMLProblemTypeConfig> {
    private static final SdkField<ImageClassificationJobConfig> IMAGE_CLASSIFICATION_JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageClassificationJobConfig").getter(AutoMLProblemTypeConfig.getter(AutoMLProblemTypeConfig::imageClassificationJobConfig)).setter(AutoMLProblemTypeConfig.setter(Builder::imageClassificationJobConfig)).constructor(ImageClassificationJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageClassificationJobConfig").build()}).build();
    private static final SdkField<TextClassificationJobConfig> TEXT_CLASSIFICATION_JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TextClassificationJobConfig").getter(AutoMLProblemTypeConfig.getter(AutoMLProblemTypeConfig::textClassificationJobConfig)).setter(AutoMLProblemTypeConfig.setter(Builder::textClassificationJobConfig)).constructor(TextClassificationJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextClassificationJobConfig").build()}).build();
    private static final SdkField<TimeSeriesForecastingJobConfig> TIME_SERIES_FORECASTING_JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeSeriesForecastingJobConfig").getter(AutoMLProblemTypeConfig.getter(AutoMLProblemTypeConfig::timeSeriesForecastingJobConfig)).setter(AutoMLProblemTypeConfig.setter(Builder::timeSeriesForecastingJobConfig)).constructor(TimeSeriesForecastingJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesForecastingJobConfig").build()}).build();
    private static final SdkField<TabularJobConfig> TABULAR_JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TabularJobConfig").getter(AutoMLProblemTypeConfig.getter(AutoMLProblemTypeConfig::tabularJobConfig)).setter(AutoMLProblemTypeConfig.setter(Builder::tabularJobConfig)).constructor(TabularJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TabularJobConfig").build()}).build();
    private static final SdkField<TextGenerationJobConfig> TEXT_GENERATION_JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TextGenerationJobConfig").getter(AutoMLProblemTypeConfig.getter(AutoMLProblemTypeConfig::textGenerationJobConfig)).setter(AutoMLProblemTypeConfig.setter(Builder::textGenerationJobConfig)).constructor(TextGenerationJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextGenerationJobConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_CLASSIFICATION_JOB_CONFIG_FIELD, TEXT_CLASSIFICATION_JOB_CONFIG_FIELD, TIME_SERIES_FORECASTING_JOB_CONFIG_FIELD, TABULAR_JOB_CONFIG_FIELD, TEXT_GENERATION_JOB_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final ImageClassificationJobConfig imageClassificationJobConfig;
    private final TextClassificationJobConfig textClassificationJobConfig;
    private final TimeSeriesForecastingJobConfig timeSeriesForecastingJobConfig;
    private final TabularJobConfig tabularJobConfig;
    private final TextGenerationJobConfig textGenerationJobConfig;
    private final Type type;

    private AutoMLProblemTypeConfig(BuilderImpl builder) {
        this.imageClassificationJobConfig = builder.imageClassificationJobConfig;
        this.textClassificationJobConfig = builder.textClassificationJobConfig;
        this.timeSeriesForecastingJobConfig = builder.timeSeriesForecastingJobConfig;
        this.tabularJobConfig = builder.tabularJobConfig;
        this.textGenerationJobConfig = builder.textGenerationJobConfig;
        this.type = builder.type;
    }

    public final ImageClassificationJobConfig imageClassificationJobConfig() {
        return this.imageClassificationJobConfig;
    }

    public final TextClassificationJobConfig textClassificationJobConfig() {
        return this.textClassificationJobConfig;
    }

    public final TimeSeriesForecastingJobConfig timeSeriesForecastingJobConfig() {
        return this.timeSeriesForecastingJobConfig;
    }

    public final TabularJobConfig tabularJobConfig() {
        return this.tabularJobConfig;
    }

    public final TextGenerationJobConfig textGenerationJobConfig() {
        return this.textGenerationJobConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageClassificationJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.textClassificationJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSeriesForecastingJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.tabularJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.textGenerationJobConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLProblemTypeConfig)) {
            return false;
        }
        AutoMLProblemTypeConfig other = (AutoMLProblemTypeConfig)obj;
        return Objects.equals(this.imageClassificationJobConfig(), other.imageClassificationJobConfig()) && Objects.equals(this.textClassificationJobConfig(), other.textClassificationJobConfig()) && Objects.equals(this.timeSeriesForecastingJobConfig(), other.timeSeriesForecastingJobConfig()) && Objects.equals(this.tabularJobConfig(), other.tabularJobConfig()) && Objects.equals(this.textGenerationJobConfig(), other.textGenerationJobConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AutoMLProblemTypeConfig").add("ImageClassificationJobConfig", (Object)this.imageClassificationJobConfig()).add("TextClassificationJobConfig", (Object)this.textClassificationJobConfig()).add("TimeSeriesForecastingJobConfig", (Object)this.timeSeriesForecastingJobConfig()).add("TabularJobConfig", (Object)this.tabularJobConfig()).add("TextGenerationJobConfig", (Object)this.textGenerationJobConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageClassificationJobConfig": {
                return Optional.ofNullable(clazz.cast(this.imageClassificationJobConfig()));
            }
            case "TextClassificationJobConfig": {
                return Optional.ofNullable(clazz.cast(this.textClassificationJobConfig()));
            }
            case "TimeSeriesForecastingJobConfig": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesForecastingJobConfig()));
            }
            case "TabularJobConfig": {
                return Optional.ofNullable(clazz.cast(this.tabularJobConfig()));
            }
            case "TextGenerationJobConfig": {
                return Optional.ofNullable(clazz.cast(this.textGenerationJobConfig()));
            }
        }
        return Optional.empty();
    }

    public static AutoMLProblemTypeConfig fromImageClassificationJobConfig(ImageClassificationJobConfig imageClassificationJobConfig) {
        return (AutoMLProblemTypeConfig)AutoMLProblemTypeConfig.builder().imageClassificationJobConfig(imageClassificationJobConfig).build();
    }

    public static AutoMLProblemTypeConfig fromImageClassificationJobConfig(Consumer<ImageClassificationJobConfig.Builder> imageClassificationJobConfig) {
        ImageClassificationJobConfig.Builder builder = ImageClassificationJobConfig.builder();
        imageClassificationJobConfig.accept(builder);
        return AutoMLProblemTypeConfig.fromImageClassificationJobConfig((ImageClassificationJobConfig)builder.build());
    }

    public static AutoMLProblemTypeConfig fromTextClassificationJobConfig(TextClassificationJobConfig textClassificationJobConfig) {
        return (AutoMLProblemTypeConfig)AutoMLProblemTypeConfig.builder().textClassificationJobConfig(textClassificationJobConfig).build();
    }

    public static AutoMLProblemTypeConfig fromTextClassificationJobConfig(Consumer<TextClassificationJobConfig.Builder> textClassificationJobConfig) {
        TextClassificationJobConfig.Builder builder = TextClassificationJobConfig.builder();
        textClassificationJobConfig.accept(builder);
        return AutoMLProblemTypeConfig.fromTextClassificationJobConfig((TextClassificationJobConfig)builder.build());
    }

    public static AutoMLProblemTypeConfig fromTimeSeriesForecastingJobConfig(TimeSeriesForecastingJobConfig timeSeriesForecastingJobConfig) {
        return (AutoMLProblemTypeConfig)AutoMLProblemTypeConfig.builder().timeSeriesForecastingJobConfig(timeSeriesForecastingJobConfig).build();
    }

    public static AutoMLProblemTypeConfig fromTimeSeriesForecastingJobConfig(Consumer<TimeSeriesForecastingJobConfig.Builder> timeSeriesForecastingJobConfig) {
        TimeSeriesForecastingJobConfig.Builder builder = TimeSeriesForecastingJobConfig.builder();
        timeSeriesForecastingJobConfig.accept(builder);
        return AutoMLProblemTypeConfig.fromTimeSeriesForecastingJobConfig((TimeSeriesForecastingJobConfig)builder.build());
    }

    public static AutoMLProblemTypeConfig fromTabularJobConfig(TabularJobConfig tabularJobConfig) {
        return (AutoMLProblemTypeConfig)AutoMLProblemTypeConfig.builder().tabularJobConfig(tabularJobConfig).build();
    }

    public static AutoMLProblemTypeConfig fromTabularJobConfig(Consumer<TabularJobConfig.Builder> tabularJobConfig) {
        TabularJobConfig.Builder builder = TabularJobConfig.builder();
        tabularJobConfig.accept(builder);
        return AutoMLProblemTypeConfig.fromTabularJobConfig((TabularJobConfig)builder.build());
    }

    public static AutoMLProblemTypeConfig fromTextGenerationJobConfig(TextGenerationJobConfig textGenerationJobConfig) {
        return (AutoMLProblemTypeConfig)AutoMLProblemTypeConfig.builder().textGenerationJobConfig(textGenerationJobConfig).build();
    }

    public static AutoMLProblemTypeConfig fromTextGenerationJobConfig(Consumer<TextGenerationJobConfig.Builder> textGenerationJobConfig) {
        TextGenerationJobConfig.Builder builder = TextGenerationJobConfig.builder();
        textGenerationJobConfig.accept(builder);
        return AutoMLProblemTypeConfig.fromTextGenerationJobConfig((TextGenerationJobConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLProblemTypeConfig, T> g) {
        return obj -> g.apply((AutoMLProblemTypeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        IMAGE_CLASSIFICATION_JOB_CONFIG,
        TEXT_CLASSIFICATION_JOB_CONFIG,
        TIME_SERIES_FORECASTING_JOB_CONFIG,
        TABULAR_JOB_CONFIG,
        TEXT_GENERATION_JOB_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ImageClassificationJobConfig imageClassificationJobConfig;
        private TextClassificationJobConfig textClassificationJobConfig;
        private TimeSeriesForecastingJobConfig timeSeriesForecastingJobConfig;
        private TabularJobConfig tabularJobConfig;
        private TextGenerationJobConfig textGenerationJobConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLProblemTypeConfig model) {
            this.imageClassificationJobConfig(model.imageClassificationJobConfig);
            this.textClassificationJobConfig(model.textClassificationJobConfig);
            this.timeSeriesForecastingJobConfig(model.timeSeriesForecastingJobConfig);
            this.tabularJobConfig(model.tabularJobConfig);
            this.textGenerationJobConfig(model.textGenerationJobConfig);
        }

        public final ImageClassificationJobConfig.Builder getImageClassificationJobConfig() {
            return this.imageClassificationJobConfig != null ? this.imageClassificationJobConfig.toBuilder() : null;
        }

        public final void setImageClassificationJobConfig(ImageClassificationJobConfig.BuilderImpl imageClassificationJobConfig) {
            ImageClassificationJobConfig oldValue = this.imageClassificationJobConfig;
            this.imageClassificationJobConfig = imageClassificationJobConfig != null ? imageClassificationJobConfig.build() : null;
            this.handleUnionValueChange(Type.IMAGE_CLASSIFICATION_JOB_CONFIG, oldValue, this.imageClassificationJobConfig);
        }

        @Override
        public final Builder imageClassificationJobConfig(ImageClassificationJobConfig imageClassificationJobConfig) {
            ImageClassificationJobConfig oldValue = this.imageClassificationJobConfig;
            this.imageClassificationJobConfig = imageClassificationJobConfig;
            this.handleUnionValueChange(Type.IMAGE_CLASSIFICATION_JOB_CONFIG, oldValue, this.imageClassificationJobConfig);
            return this;
        }

        public final TextClassificationJobConfig.Builder getTextClassificationJobConfig() {
            return this.textClassificationJobConfig != null ? this.textClassificationJobConfig.toBuilder() : null;
        }

        public final void setTextClassificationJobConfig(TextClassificationJobConfig.BuilderImpl textClassificationJobConfig) {
            TextClassificationJobConfig oldValue = this.textClassificationJobConfig;
            this.textClassificationJobConfig = textClassificationJobConfig != null ? textClassificationJobConfig.build() : null;
            this.handleUnionValueChange(Type.TEXT_CLASSIFICATION_JOB_CONFIG, oldValue, this.textClassificationJobConfig);
        }

        @Override
        public final Builder textClassificationJobConfig(TextClassificationJobConfig textClassificationJobConfig) {
            TextClassificationJobConfig oldValue = this.textClassificationJobConfig;
            this.textClassificationJobConfig = textClassificationJobConfig;
            this.handleUnionValueChange(Type.TEXT_CLASSIFICATION_JOB_CONFIG, oldValue, this.textClassificationJobConfig);
            return this;
        }

        public final TimeSeriesForecastingJobConfig.Builder getTimeSeriesForecastingJobConfig() {
            return this.timeSeriesForecastingJobConfig != null ? this.timeSeriesForecastingJobConfig.toBuilder() : null;
        }

        public final void setTimeSeriesForecastingJobConfig(TimeSeriesForecastingJobConfig.BuilderImpl timeSeriesForecastingJobConfig) {
            TimeSeriesForecastingJobConfig oldValue = this.timeSeriesForecastingJobConfig;
            this.timeSeriesForecastingJobConfig = timeSeriesForecastingJobConfig != null ? timeSeriesForecastingJobConfig.build() : null;
            this.handleUnionValueChange(Type.TIME_SERIES_FORECASTING_JOB_CONFIG, oldValue, this.timeSeriesForecastingJobConfig);
        }

        @Override
        public final Builder timeSeriesForecastingJobConfig(TimeSeriesForecastingJobConfig timeSeriesForecastingJobConfig) {
            TimeSeriesForecastingJobConfig oldValue = this.timeSeriesForecastingJobConfig;
            this.timeSeriesForecastingJobConfig = timeSeriesForecastingJobConfig;
            this.handleUnionValueChange(Type.TIME_SERIES_FORECASTING_JOB_CONFIG, oldValue, this.timeSeriesForecastingJobConfig);
            return this;
        }

        public final TabularJobConfig.Builder getTabularJobConfig() {
            return this.tabularJobConfig != null ? this.tabularJobConfig.toBuilder() : null;
        }

        public final void setTabularJobConfig(TabularJobConfig.BuilderImpl tabularJobConfig) {
            TabularJobConfig oldValue = this.tabularJobConfig;
            this.tabularJobConfig = tabularJobConfig != null ? tabularJobConfig.build() : null;
            this.handleUnionValueChange(Type.TABULAR_JOB_CONFIG, oldValue, this.tabularJobConfig);
        }

        @Override
        public final Builder tabularJobConfig(TabularJobConfig tabularJobConfig) {
            TabularJobConfig oldValue = this.tabularJobConfig;
            this.tabularJobConfig = tabularJobConfig;
            this.handleUnionValueChange(Type.TABULAR_JOB_CONFIG, oldValue, this.tabularJobConfig);
            return this;
        }

        public final TextGenerationJobConfig.Builder getTextGenerationJobConfig() {
            return this.textGenerationJobConfig != null ? this.textGenerationJobConfig.toBuilder() : null;
        }

        public final void setTextGenerationJobConfig(TextGenerationJobConfig.BuilderImpl textGenerationJobConfig) {
            TextGenerationJobConfig oldValue = this.textGenerationJobConfig;
            this.textGenerationJobConfig = textGenerationJobConfig != null ? textGenerationJobConfig.build() : null;
            this.handleUnionValueChange(Type.TEXT_GENERATION_JOB_CONFIG, oldValue, this.textGenerationJobConfig);
        }

        @Override
        public final Builder textGenerationJobConfig(TextGenerationJobConfig textGenerationJobConfig) {
            TextGenerationJobConfig oldValue = this.textGenerationJobConfig;
            this.textGenerationJobConfig = textGenerationJobConfig;
            this.handleUnionValueChange(Type.TEXT_GENERATION_JOB_CONFIG, oldValue, this.textGenerationJobConfig);
            return this;
        }

        public AutoMLProblemTypeConfig build() {
            return new AutoMLProblemTypeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoMLProblemTypeConfig> {
        public Builder imageClassificationJobConfig(ImageClassificationJobConfig var1);

        default public Builder imageClassificationJobConfig(Consumer<ImageClassificationJobConfig.Builder> imageClassificationJobConfig) {
            return this.imageClassificationJobConfig((ImageClassificationJobConfig)((ImageClassificationJobConfig.Builder)ImageClassificationJobConfig.builder().applyMutation(imageClassificationJobConfig)).build());
        }

        public Builder textClassificationJobConfig(TextClassificationJobConfig var1);

        default public Builder textClassificationJobConfig(Consumer<TextClassificationJobConfig.Builder> textClassificationJobConfig) {
            return this.textClassificationJobConfig((TextClassificationJobConfig)((TextClassificationJobConfig.Builder)TextClassificationJobConfig.builder().applyMutation(textClassificationJobConfig)).build());
        }

        public Builder timeSeriesForecastingJobConfig(TimeSeriesForecastingJobConfig var1);

        default public Builder timeSeriesForecastingJobConfig(Consumer<TimeSeriesForecastingJobConfig.Builder> timeSeriesForecastingJobConfig) {
            return this.timeSeriesForecastingJobConfig((TimeSeriesForecastingJobConfig)((TimeSeriesForecastingJobConfig.Builder)TimeSeriesForecastingJobConfig.builder().applyMutation(timeSeriesForecastingJobConfig)).build());
        }

        public Builder tabularJobConfig(TabularJobConfig var1);

        default public Builder tabularJobConfig(Consumer<TabularJobConfig.Builder> tabularJobConfig) {
            return this.tabularJobConfig((TabularJobConfig)((TabularJobConfig.Builder)TabularJobConfig.builder().applyMutation(tabularJobConfig)).build());
        }

        public Builder textGenerationJobConfig(TextGenerationJobConfig var1);

        default public Builder textGenerationJobConfig(Consumer<TextGenerationJobConfig.Builder> textGenerationJobConfig) {
            return this.textGenerationJobConfig((TextGenerationJobConfig)((TextGenerationJobConfig.Builder)TextGenerationJobConfig.builder().applyMutation(textGenerationJobConfig)).build());
        }
    }
}

