/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VariantStatus {
    CREATING("Creating"),
    UPDATING("Updating"),
    DELETING("Deleting"),
    ACTIVATING_TRAFFIC("ActivatingTraffic"),
    BAKING("Baking"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VariantStatus> VALUE_MAP;
    private final String value;

    private VariantStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VariantStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VariantStatus> knownValues() {
        EnumSet<VariantStatus> knownValues = EnumSet.allOf(VariantStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VariantStatus.class, VariantStatus::toString);
    }
}

