/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AppSpecification;
import software.amazon.awssdk.services.sagemaker.model.ExperimentConfig;
import software.amazon.awssdk.services.sagemaker.model.NetworkConfig;
import software.amazon.awssdk.services.sagemaker.model.ProcessingEnvironmentMapCopier;
import software.amazon.awssdk.services.sagemaker.model.ProcessingInput;
import software.amazon.awssdk.services.sagemaker.model.ProcessingInputsCopier;
import software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus;
import software.amazon.awssdk.services.sagemaker.model.ProcessingOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.ProcessingResources;
import software.amazon.awssdk.services.sagemaker.model.ProcessingStoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProcessingJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProcessingJob> {
    private static final SdkField<List<ProcessingInput>> PROCESSING_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessingInputs").getter(ProcessingJob.getter(ProcessingJob::processingInputs)).setter(ProcessingJob.setter(Builder::processingInputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingInputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProcessingInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProcessingOutputConfig> PROCESSING_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingOutputConfig").getter(ProcessingJob.getter(ProcessingJob::processingOutputConfig)).setter(ProcessingJob.setter(Builder::processingOutputConfig)).constructor(ProcessingOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingOutputConfig").build()}).build();
    private static final SdkField<String> PROCESSING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcessingJobName").getter(ProcessingJob.getter(ProcessingJob::processingJobName)).setter(ProcessingJob.setter(Builder::processingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobName").build()}).build();
    private static final SdkField<ProcessingResources> PROCESSING_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingResources").getter(ProcessingJob.getter(ProcessingJob::processingResources)).setter(ProcessingJob.setter(Builder::processingResources)).constructor(ProcessingResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingResources").build()}).build();
    private static final SdkField<ProcessingStoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(ProcessingJob.getter(ProcessingJob::stoppingCondition)).setter(ProcessingJob.setter(Builder::stoppingCondition)).constructor(ProcessingStoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<AppSpecification> APP_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppSpecification").getter(ProcessingJob.getter(ProcessingJob::appSpecification)).setter(ProcessingJob.setter(Builder::appSpecification)).constructor(AppSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppSpecification").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Environment").getter(ProcessingJob.getter(ProcessingJob::environment)).setter(ProcessingJob.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<NetworkConfig> NETWORK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfig").getter(ProcessingJob.getter(ProcessingJob::networkConfig)).setter(ProcessingJob.setter(Builder::networkConfig)).constructor(NetworkConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(ProcessingJob.getter(ProcessingJob::roleArn)).setter(ProcessingJob.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<ExperimentConfig> EXPERIMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExperimentConfig").getter(ProcessingJob.getter(ProcessingJob::experimentConfig)).setter(ProcessingJob.setter(Builder::experimentConfig)).constructor(ExperimentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentConfig").build()}).build();
    private static final SdkField<String> PROCESSING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcessingJobArn").getter(ProcessingJob.getter(ProcessingJob::processingJobArn)).setter(ProcessingJob.setter(Builder::processingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobArn").build()}).build();
    private static final SdkField<String> PROCESSING_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcessingJobStatus").getter(ProcessingJob.getter(ProcessingJob::processingJobStatusAsString)).setter(ProcessingJob.setter(Builder::processingJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobStatus").build()}).build();
    private static final SdkField<String> EXIT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExitMessage").getter(ProcessingJob.getter(ProcessingJob::exitMessage)).setter(ProcessingJob.setter(Builder::exitMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExitMessage").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(ProcessingJob.getter(ProcessingJob::failureReason)).setter(ProcessingJob.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<Instant> PROCESSING_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ProcessingEndTime").getter(ProcessingJob.getter(ProcessingJob::processingEndTime)).setter(ProcessingJob.setter(Builder::processingEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingEndTime").build()}).build();
    private static final SdkField<Instant> PROCESSING_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ProcessingStartTime").getter(ProcessingJob.getter(ProcessingJob::processingStartTime)).setter(ProcessingJob.setter(Builder::processingStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingStartTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ProcessingJob.getter(ProcessingJob::lastModifiedTime)).setter(ProcessingJob.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ProcessingJob.getter(ProcessingJob::creationTime)).setter(ProcessingJob.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> MONITORING_SCHEDULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringScheduleArn").getter(ProcessingJob.getter(ProcessingJob::monitoringScheduleArn)).setter(ProcessingJob.setter(Builder::monitoringScheduleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleArn").build()}).build();
    private static final SdkField<String> AUTO_ML_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLJobArn").getter(ProcessingJob.getter(ProcessingJob::autoMLJobArn)).setter(ProcessingJob.setter(Builder::autoMLJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArn").build()}).build();
    private static final SdkField<String> TRAINING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingJobArn").getter(ProcessingJob.getter(ProcessingJob::trainingJobArn)).setter(ProcessingJob.setter(Builder::trainingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ProcessingJob.getter(ProcessingJob::tags)).setter(ProcessingJob.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSING_INPUTS_FIELD, PROCESSING_OUTPUT_CONFIG_FIELD, PROCESSING_JOB_NAME_FIELD, PROCESSING_RESOURCES_FIELD, STOPPING_CONDITION_FIELD, APP_SPECIFICATION_FIELD, ENVIRONMENT_FIELD, NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD, EXPERIMENT_CONFIG_FIELD, PROCESSING_JOB_ARN_FIELD, PROCESSING_JOB_STATUS_FIELD, EXIT_MESSAGE_FIELD, FAILURE_REASON_FIELD, PROCESSING_END_TIME_FIELD, PROCESSING_START_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, CREATION_TIME_FIELD, MONITORING_SCHEDULE_ARN_FIELD, AUTO_ML_JOB_ARN_FIELD, TRAINING_JOB_ARN_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ProcessingInput> processingInputs;
    private final ProcessingOutputConfig processingOutputConfig;
    private final String processingJobName;
    private final ProcessingResources processingResources;
    private final ProcessingStoppingCondition stoppingCondition;
    private final AppSpecification appSpecification;
    private final Map<String, String> environment;
    private final NetworkConfig networkConfig;
    private final String roleArn;
    private final ExperimentConfig experimentConfig;
    private final String processingJobArn;
    private final String processingJobStatus;
    private final String exitMessage;
    private final String failureReason;
    private final Instant processingEndTime;
    private final Instant processingStartTime;
    private final Instant lastModifiedTime;
    private final Instant creationTime;
    private final String monitoringScheduleArn;
    private final String autoMLJobArn;
    private final String trainingJobArn;
    private final List<Tag> tags;

    private ProcessingJob(BuilderImpl builder) {
        this.processingInputs = builder.processingInputs;
        this.processingOutputConfig = builder.processingOutputConfig;
        this.processingJobName = builder.processingJobName;
        this.processingResources = builder.processingResources;
        this.stoppingCondition = builder.stoppingCondition;
        this.appSpecification = builder.appSpecification;
        this.environment = builder.environment;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.experimentConfig = builder.experimentConfig;
        this.processingJobArn = builder.processingJobArn;
        this.processingJobStatus = builder.processingJobStatus;
        this.exitMessage = builder.exitMessage;
        this.failureReason = builder.failureReason;
        this.processingEndTime = builder.processingEndTime;
        this.processingStartTime = builder.processingStartTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.creationTime = builder.creationTime;
        this.monitoringScheduleArn = builder.monitoringScheduleArn;
        this.autoMLJobArn = builder.autoMLJobArn;
        this.trainingJobArn = builder.trainingJobArn;
        this.tags = builder.tags;
    }

    public final boolean hasProcessingInputs() {
        return this.processingInputs != null && !(this.processingInputs instanceof SdkAutoConstructList);
    }

    public final List<ProcessingInput> processingInputs() {
        return this.processingInputs;
    }

    public final ProcessingOutputConfig processingOutputConfig() {
        return this.processingOutputConfig;
    }

    public final String processingJobName() {
        return this.processingJobName;
    }

    public final ProcessingResources processingResources() {
        return this.processingResources;
    }

    public final ProcessingStoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public final AppSpecification appSpecification() {
        return this.appSpecification;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environment() {
        return this.environment;
    }

    public final NetworkConfig networkConfig() {
        return this.networkConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ExperimentConfig experimentConfig() {
        return this.experimentConfig;
    }

    public final String processingJobArn() {
        return this.processingJobArn;
    }

    public final ProcessingJobStatus processingJobStatus() {
        return ProcessingJobStatus.fromValue(this.processingJobStatus);
    }

    public final String processingJobStatusAsString() {
        return this.processingJobStatus;
    }

    public final String exitMessage() {
        return this.exitMessage;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final Instant processingEndTime() {
        return this.processingEndTime;
    }

    public final Instant processingStartTime() {
        return this.processingStartTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String monitoringScheduleArn() {
        return this.monitoringScheduleArn;
    }

    public final String autoMLJobArn() {
        return this.autoMLJobArn;
    }

    public final String trainingJobArn() {
        return this.trainingJobArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessingInputs() ? this.processingInputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.processingOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.appSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringScheduleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingJob)) {
            return false;
        }
        ProcessingJob other = (ProcessingJob)obj;
        return this.hasProcessingInputs() == other.hasProcessingInputs() && Objects.equals(this.processingInputs(), other.processingInputs()) && Objects.equals(this.processingOutputConfig(), other.processingOutputConfig()) && Objects.equals(this.processingJobName(), other.processingJobName()) && Objects.equals(this.processingResources(), other.processingResources()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && Objects.equals(this.appSpecification(), other.appSpecification()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.networkConfig(), other.networkConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.experimentConfig(), other.experimentConfig()) && Objects.equals(this.processingJobArn(), other.processingJobArn()) && Objects.equals(this.processingJobStatusAsString(), other.processingJobStatusAsString()) && Objects.equals(this.exitMessage(), other.exitMessage()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.processingEndTime(), other.processingEndTime()) && Objects.equals(this.processingStartTime(), other.processingStartTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.monitoringScheduleArn(), other.monitoringScheduleArn()) && Objects.equals(this.autoMLJobArn(), other.autoMLJobArn()) && Objects.equals(this.trainingJobArn(), other.trainingJobArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ProcessingJob").add("ProcessingInputs", this.hasProcessingInputs() ? this.processingInputs() : null).add("ProcessingOutputConfig", (Object)this.processingOutputConfig()).add("ProcessingJobName", (Object)this.processingJobName()).add("ProcessingResources", (Object)this.processingResources()).add("StoppingCondition", (Object)this.stoppingCondition()).add("AppSpecification", (Object)this.appSpecification()).add("Environment", this.hasEnvironment() ? this.environment() : null).add("NetworkConfig", (Object)this.networkConfig()).add("RoleArn", (Object)this.roleArn()).add("ExperimentConfig", (Object)this.experimentConfig()).add("ProcessingJobArn", (Object)this.processingJobArn()).add("ProcessingJobStatus", (Object)this.processingJobStatusAsString()).add("ExitMessage", (Object)this.exitMessage()).add("FailureReason", (Object)this.failureReason()).add("ProcessingEndTime", (Object)this.processingEndTime()).add("ProcessingStartTime", (Object)this.processingStartTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("CreationTime", (Object)this.creationTime()).add("MonitoringScheduleArn", (Object)this.monitoringScheduleArn()).add("AutoMLJobArn", (Object)this.autoMLJobArn()).add("TrainingJobArn", (Object)this.trainingJobArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProcessingInputs": {
                return Optional.ofNullable(clazz.cast(this.processingInputs()));
            }
            case "ProcessingOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.processingOutputConfig()));
            }
            case "ProcessingJobName": {
                return Optional.ofNullable(clazz.cast(this.processingJobName()));
            }
            case "ProcessingResources": {
                return Optional.ofNullable(clazz.cast(this.processingResources()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "AppSpecification": {
                return Optional.ofNullable(clazz.cast(this.appSpecification()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "NetworkConfig": {
                return Optional.ofNullable(clazz.cast(this.networkConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ExperimentConfig": {
                return Optional.ofNullable(clazz.cast(this.experimentConfig()));
            }
            case "ProcessingJobArn": {
                return Optional.ofNullable(clazz.cast(this.processingJobArn()));
            }
            case "ProcessingJobStatus": {
                return Optional.ofNullable(clazz.cast(this.processingJobStatusAsString()));
            }
            case "ExitMessage": {
                return Optional.ofNullable(clazz.cast(this.exitMessage()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ProcessingEndTime": {
                return Optional.ofNullable(clazz.cast(this.processingEndTime()));
            }
            case "ProcessingStartTime": {
                return Optional.ofNullable(clazz.cast(this.processingStartTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "MonitoringScheduleArn": {
                return Optional.ofNullable(clazz.cast(this.monitoringScheduleArn()));
            }
            case "AutoMLJobArn": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobArn()));
            }
            case "TrainingJobArn": {
                return Optional.ofNullable(clazz.cast(this.trainingJobArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingJob, T> g) {
        return obj -> g.apply((ProcessingJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ProcessingInput> processingInputs = DefaultSdkAutoConstructList.getInstance();
        private ProcessingOutputConfig processingOutputConfig;
        private String processingJobName;
        private ProcessingResources processingResources;
        private ProcessingStoppingCondition stoppingCondition;
        private AppSpecification appSpecification;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();
        private NetworkConfig networkConfig;
        private String roleArn;
        private ExperimentConfig experimentConfig;
        private String processingJobArn;
        private String processingJobStatus;
        private String exitMessage;
        private String failureReason;
        private Instant processingEndTime;
        private Instant processingStartTime;
        private Instant lastModifiedTime;
        private Instant creationTime;
        private String monitoringScheduleArn;
        private String autoMLJobArn;
        private String trainingJobArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingJob model) {
            this.processingInputs(model.processingInputs);
            this.processingOutputConfig(model.processingOutputConfig);
            this.processingJobName(model.processingJobName);
            this.processingResources(model.processingResources);
            this.stoppingCondition(model.stoppingCondition);
            this.appSpecification(model.appSpecification);
            this.environment(model.environment);
            this.networkConfig(model.networkConfig);
            this.roleArn(model.roleArn);
            this.experimentConfig(model.experimentConfig);
            this.processingJobArn(model.processingJobArn);
            this.processingJobStatus(model.processingJobStatus);
            this.exitMessage(model.exitMessage);
            this.failureReason(model.failureReason);
            this.processingEndTime(model.processingEndTime);
            this.processingStartTime(model.processingStartTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.creationTime(model.creationTime);
            this.monitoringScheduleArn(model.monitoringScheduleArn);
            this.autoMLJobArn(model.autoMLJobArn);
            this.trainingJobArn(model.trainingJobArn);
            this.tags(model.tags);
        }

        public final List<ProcessingInput.Builder> getProcessingInputs() {
            List<ProcessingInput.Builder> result = ProcessingInputsCopier.copyToBuilder(this.processingInputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessingInputs(Collection<ProcessingInput.BuilderImpl> processingInputs) {
            this.processingInputs = ProcessingInputsCopier.copyFromBuilder(processingInputs);
        }

        @Override
        public final Builder processingInputs(Collection<ProcessingInput> processingInputs) {
            this.processingInputs = ProcessingInputsCopier.copy(processingInputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingInputs(ProcessingInput ... processingInputs) {
            this.processingInputs(Arrays.asList(processingInputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingInputs(Consumer<ProcessingInput.Builder> ... processingInputs) {
            this.processingInputs(Stream.of(processingInputs).map(c -> (ProcessingInput)((ProcessingInput.Builder)ProcessingInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProcessingOutputConfig.Builder getProcessingOutputConfig() {
            return this.processingOutputConfig != null ? this.processingOutputConfig.toBuilder() : null;
        }

        public final void setProcessingOutputConfig(ProcessingOutputConfig.BuilderImpl processingOutputConfig) {
            this.processingOutputConfig = processingOutputConfig != null ? processingOutputConfig.build() : null;
        }

        @Override
        public final Builder processingOutputConfig(ProcessingOutputConfig processingOutputConfig) {
            this.processingOutputConfig = processingOutputConfig;
            return this;
        }

        public final String getProcessingJobName() {
            return this.processingJobName;
        }

        public final void setProcessingJobName(String processingJobName) {
            this.processingJobName = processingJobName;
        }

        @Override
        public final Builder processingJobName(String processingJobName) {
            this.processingJobName = processingJobName;
            return this;
        }

        public final ProcessingResources.Builder getProcessingResources() {
            return this.processingResources != null ? this.processingResources.toBuilder() : null;
        }

        public final void setProcessingResources(ProcessingResources.BuilderImpl processingResources) {
            this.processingResources = processingResources != null ? processingResources.build() : null;
        }

        @Override
        public final Builder processingResources(ProcessingResources processingResources) {
            this.processingResources = processingResources;
            return this;
        }

        public final ProcessingStoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(ProcessingStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(ProcessingStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final AppSpecification.Builder getAppSpecification() {
            return this.appSpecification != null ? this.appSpecification.toBuilder() : null;
        }

        public final void setAppSpecification(AppSpecification.BuilderImpl appSpecification) {
            this.appSpecification = appSpecification != null ? appSpecification.build() : null;
        }

        @Override
        public final Builder appSpecification(AppSpecification appSpecification) {
            this.appSpecification = appSpecification;
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (this.environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = ProcessingEnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = ProcessingEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final NetworkConfig.Builder getNetworkConfig() {
            return this.networkConfig != null ? this.networkConfig.toBuilder() : null;
        }

        public final void setNetworkConfig(NetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        @Override
        public final Builder networkConfig(NetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ExperimentConfig.Builder getExperimentConfig() {
            return this.experimentConfig != null ? this.experimentConfig.toBuilder() : null;
        }

        public final void setExperimentConfig(ExperimentConfig.BuilderImpl experimentConfig) {
            this.experimentConfig = experimentConfig != null ? experimentConfig.build() : null;
        }

        @Override
        public final Builder experimentConfig(ExperimentConfig experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        public final String getProcessingJobArn() {
            return this.processingJobArn;
        }

        public final void setProcessingJobArn(String processingJobArn) {
            this.processingJobArn = processingJobArn;
        }

        @Override
        public final Builder processingJobArn(String processingJobArn) {
            this.processingJobArn = processingJobArn;
            return this;
        }

        public final String getProcessingJobStatus() {
            return this.processingJobStatus;
        }

        public final void setProcessingJobStatus(String processingJobStatus) {
            this.processingJobStatus = processingJobStatus;
        }

        @Override
        public final Builder processingJobStatus(String processingJobStatus) {
            this.processingJobStatus = processingJobStatus;
            return this;
        }

        @Override
        public final Builder processingJobStatus(ProcessingJobStatus processingJobStatus) {
            this.processingJobStatus(processingJobStatus == null ? null : processingJobStatus.toString());
            return this;
        }

        public final String getExitMessage() {
            return this.exitMessage;
        }

        public final void setExitMessage(String exitMessage) {
            this.exitMessage = exitMessage;
        }

        @Override
        public final Builder exitMessage(String exitMessage) {
            this.exitMessage = exitMessage;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getProcessingEndTime() {
            return this.processingEndTime;
        }

        public final void setProcessingEndTime(Instant processingEndTime) {
            this.processingEndTime = processingEndTime;
        }

        @Override
        public final Builder processingEndTime(Instant processingEndTime) {
            this.processingEndTime = processingEndTime;
            return this;
        }

        public final Instant getProcessingStartTime() {
            return this.processingStartTime;
        }

        public final void setProcessingStartTime(Instant processingStartTime) {
            this.processingStartTime = processingStartTime;
        }

        @Override
        public final Builder processingStartTime(Instant processingStartTime) {
            this.processingStartTime = processingStartTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getMonitoringScheduleArn() {
            return this.monitoringScheduleArn;
        }

        public final void setMonitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
        }

        @Override
        public final Builder monitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
            return this;
        }

        public final String getAutoMLJobArn() {
            return this.autoMLJobArn;
        }

        public final void setAutoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
        }

        @Override
        public final Builder autoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
            return this;
        }

        public final String getTrainingJobArn() {
            return this.trainingJobArn;
        }

        public final void setTrainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
        }

        @Override
        public final Builder trainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ProcessingJob build() {
            return new ProcessingJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProcessingJob> {
        public Builder processingInputs(Collection<ProcessingInput> var1);

        public Builder processingInputs(ProcessingInput ... var1);

        public Builder processingInputs(Consumer<ProcessingInput.Builder> ... var1);

        public Builder processingOutputConfig(ProcessingOutputConfig var1);

        default public Builder processingOutputConfig(Consumer<ProcessingOutputConfig.Builder> processingOutputConfig) {
            return this.processingOutputConfig((ProcessingOutputConfig)((ProcessingOutputConfig.Builder)ProcessingOutputConfig.builder().applyMutation(processingOutputConfig)).build());
        }

        public Builder processingJobName(String var1);

        public Builder processingResources(ProcessingResources var1);

        default public Builder processingResources(Consumer<ProcessingResources.Builder> processingResources) {
            return this.processingResources((ProcessingResources)((ProcessingResources.Builder)ProcessingResources.builder().applyMutation(processingResources)).build());
        }

        public Builder stoppingCondition(ProcessingStoppingCondition var1);

        default public Builder stoppingCondition(Consumer<ProcessingStoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((ProcessingStoppingCondition)((ProcessingStoppingCondition.Builder)ProcessingStoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder appSpecification(AppSpecification var1);

        default public Builder appSpecification(Consumer<AppSpecification.Builder> appSpecification) {
            return this.appSpecification((AppSpecification)((AppSpecification.Builder)AppSpecification.builder().applyMutation(appSpecification)).build());
        }

        public Builder environment(Map<String, String> var1);

        public Builder networkConfig(NetworkConfig var1);

        default public Builder networkConfig(Consumer<NetworkConfig.Builder> networkConfig) {
            return this.networkConfig((NetworkConfig)((NetworkConfig.Builder)NetworkConfig.builder().applyMutation(networkConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder experimentConfig(ExperimentConfig var1);

        default public Builder experimentConfig(Consumer<ExperimentConfig.Builder> experimentConfig) {
            return this.experimentConfig((ExperimentConfig)((ExperimentConfig.Builder)ExperimentConfig.builder().applyMutation(experimentConfig)).build());
        }

        public Builder processingJobArn(String var1);

        public Builder processingJobStatus(String var1);

        public Builder processingJobStatus(ProcessingJobStatus var1);

        public Builder exitMessage(String var1);

        public Builder failureReason(String var1);

        public Builder processingEndTime(Instant var1);

        public Builder processingStartTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder monitoringScheduleArn(String var1);

        public Builder autoMLJobArn(String var1);

        public Builder trainingJobArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

