/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoMLJobCompletionCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoMLJobCompletionCriteria> {
    private static final SdkField<Integer> MAX_CANDIDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCandidates").getter(AutoMLJobCompletionCriteria.getter(AutoMLJobCompletionCriteria::maxCandidates)).setter(AutoMLJobCompletionCriteria.setter(Builder::maxCandidates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCandidates").build()}).build();
    private static final SdkField<Integer> MAX_RUNTIME_PER_TRAINING_JOB_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRuntimePerTrainingJobInSeconds").getter(AutoMLJobCompletionCriteria.getter(AutoMLJobCompletionCriteria::maxRuntimePerTrainingJobInSeconds)).setter(AutoMLJobCompletionCriteria.setter(Builder::maxRuntimePerTrainingJobInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRuntimePerTrainingJobInSeconds").build()}).build();
    private static final SdkField<Integer> MAX_AUTO_ML_JOB_RUNTIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAutoMLJobRuntimeInSeconds").getter(AutoMLJobCompletionCriteria.getter(AutoMLJobCompletionCriteria::maxAutoMLJobRuntimeInSeconds)).setter(AutoMLJobCompletionCriteria.setter(Builder::maxAutoMLJobRuntimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAutoMLJobRuntimeInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_CANDIDATES_FIELD, MAX_RUNTIME_PER_TRAINING_JOB_IN_SECONDS_FIELD, MAX_AUTO_ML_JOB_RUNTIME_IN_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maxCandidates;
    private final Integer maxRuntimePerTrainingJobInSeconds;
    private final Integer maxAutoMLJobRuntimeInSeconds;

    private AutoMLJobCompletionCriteria(BuilderImpl builder) {
        this.maxCandidates = builder.maxCandidates;
        this.maxRuntimePerTrainingJobInSeconds = builder.maxRuntimePerTrainingJobInSeconds;
        this.maxAutoMLJobRuntimeInSeconds = builder.maxAutoMLJobRuntimeInSeconds;
    }

    public final Integer maxCandidates() {
        return this.maxCandidates;
    }

    public final Integer maxRuntimePerTrainingJobInSeconds() {
        return this.maxRuntimePerTrainingJobInSeconds;
    }

    public final Integer maxAutoMLJobRuntimeInSeconds() {
        return this.maxAutoMLJobRuntimeInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCandidates());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRuntimePerTrainingJobInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAutoMLJobRuntimeInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLJobCompletionCriteria)) {
            return false;
        }
        AutoMLJobCompletionCriteria other = (AutoMLJobCompletionCriteria)obj;
        return Objects.equals(this.maxCandidates(), other.maxCandidates()) && Objects.equals(this.maxRuntimePerTrainingJobInSeconds(), other.maxRuntimePerTrainingJobInSeconds()) && Objects.equals(this.maxAutoMLJobRuntimeInSeconds(), other.maxAutoMLJobRuntimeInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"AutoMLJobCompletionCriteria").add("MaxCandidates", (Object)this.maxCandidates()).add("MaxRuntimePerTrainingJobInSeconds", (Object)this.maxRuntimePerTrainingJobInSeconds()).add("MaxAutoMLJobRuntimeInSeconds", (Object)this.maxAutoMLJobRuntimeInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxCandidates": {
                return Optional.ofNullable(clazz.cast(this.maxCandidates()));
            }
            case "MaxRuntimePerTrainingJobInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxRuntimePerTrainingJobInSeconds()));
            }
            case "MaxAutoMLJobRuntimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxAutoMLJobRuntimeInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLJobCompletionCriteria, T> g) {
        return obj -> g.apply((AutoMLJobCompletionCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxCandidates;
        private Integer maxRuntimePerTrainingJobInSeconds;
        private Integer maxAutoMLJobRuntimeInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLJobCompletionCriteria model) {
            this.maxCandidates(model.maxCandidates);
            this.maxRuntimePerTrainingJobInSeconds(model.maxRuntimePerTrainingJobInSeconds);
            this.maxAutoMLJobRuntimeInSeconds(model.maxAutoMLJobRuntimeInSeconds);
        }

        public final Integer getMaxCandidates() {
            return this.maxCandidates;
        }

        public final void setMaxCandidates(Integer maxCandidates) {
            this.maxCandidates = maxCandidates;
        }

        @Override
        public final Builder maxCandidates(Integer maxCandidates) {
            this.maxCandidates = maxCandidates;
            return this;
        }

        public final Integer getMaxRuntimePerTrainingJobInSeconds() {
            return this.maxRuntimePerTrainingJobInSeconds;
        }

        public final void setMaxRuntimePerTrainingJobInSeconds(Integer maxRuntimePerTrainingJobInSeconds) {
            this.maxRuntimePerTrainingJobInSeconds = maxRuntimePerTrainingJobInSeconds;
        }

        @Override
        public final Builder maxRuntimePerTrainingJobInSeconds(Integer maxRuntimePerTrainingJobInSeconds) {
            this.maxRuntimePerTrainingJobInSeconds = maxRuntimePerTrainingJobInSeconds;
            return this;
        }

        public final Integer getMaxAutoMLJobRuntimeInSeconds() {
            return this.maxAutoMLJobRuntimeInSeconds;
        }

        public final void setMaxAutoMLJobRuntimeInSeconds(Integer maxAutoMLJobRuntimeInSeconds) {
            this.maxAutoMLJobRuntimeInSeconds = maxAutoMLJobRuntimeInSeconds;
        }

        @Override
        public final Builder maxAutoMLJobRuntimeInSeconds(Integer maxAutoMLJobRuntimeInSeconds) {
            this.maxAutoMLJobRuntimeInSeconds = maxAutoMLJobRuntimeInSeconds;
            return this;
        }

        public AutoMLJobCompletionCriteria build() {
            return new AutoMLJobCompletionCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoMLJobCompletionCriteria> {
        public Builder maxCandidates(Integer var1);

        public Builder maxRuntimePerTrainingJobInSeconds(Integer var1);

        public Builder maxAutoMLJobRuntimeInSeconds(Integer var1);
    }
}

