/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.LineageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Vertex
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Vertex> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Vertex.getter(Vertex::arn)).setter(Vertex.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Vertex.getter(Vertex::type)).setter(Vertex.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> LINEAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LineageType").getter(Vertex.getter(Vertex::lineageTypeAsString)).setter(Vertex.setter(Builder::lineageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TYPE_FIELD, LINEAGE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String type;
    private final String lineageType;

    private Vertex(BuilderImpl builder) {
        this.arn = builder.arn;
        this.type = builder.type;
        this.lineageType = builder.lineageType;
    }

    public final String arn() {
        return this.arn;
    }

    public final String type() {
        return this.type;
    }

    public final LineageType lineageType() {
        return LineageType.fromValue(this.lineageType);
    }

    public final String lineageTypeAsString() {
        return this.lineageType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineageTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vertex)) {
            return false;
        }
        Vertex other = (Vertex)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.lineageTypeAsString(), other.lineageTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Vertex").add("Arn", (Object)this.arn()).add("Type", (Object)this.type()).add("LineageType", (Object)this.lineageTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "LineageType": {
                return Optional.ofNullable(clazz.cast(this.lineageTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Vertex, T> g) {
        return obj -> g.apply((Vertex)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String type;
        private String lineageType;

        private BuilderImpl() {
        }

        private BuilderImpl(Vertex model) {
            this.arn(model.arn);
            this.type(model.type);
            this.lineageType(model.lineageType);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getLineageType() {
            return this.lineageType;
        }

        public final void setLineageType(String lineageType) {
            this.lineageType = lineageType;
        }

        @Override
        public final Builder lineageType(String lineageType) {
            this.lineageType = lineageType;
            return this;
        }

        @Override
        public final Builder lineageType(LineageType lineageType) {
            this.lineageType(lineageType == null ? null : lineageType.toString());
            return this;
        }

        public Vertex build() {
            return new Vertex(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Vertex> {
        public Builder arn(String var1);

        public Builder type(String var1);

        public Builder lineageType(String var1);

        public Builder lineageType(LineageType var1);
    }
}

