/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.InstanceGroup;
import software.amazon.awssdk.services.sagemaker.model.InstanceGroupsCopier;
import software.amazon.awssdk.services.sagemaker.model.TrainingInstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceConfig> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ResourceConfig.getter(ResourceConfig::instanceTypeAsString)).setter(ResourceConfig.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(ResourceConfig.getter(ResourceConfig::instanceCount)).setter(ResourceConfig.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeSizeInGB").getter(ResourceConfig.getter(ResourceConfig::volumeSizeInGB)).setter(ResourceConfig.setter(Builder::volumeSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()}).build();
    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeKmsKeyId").getter(ResourceConfig.getter(ResourceConfig::volumeKmsKeyId)).setter(ResourceConfig.setter(Builder::volumeKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()}).build();
    private static final SdkField<Integer> KEEP_ALIVE_PERIOD_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("KeepAlivePeriodInSeconds").getter(ResourceConfig.getter(ResourceConfig::keepAlivePeriodInSeconds)).setter(ResourceConfig.setter(Builder::keepAlivePeriodInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeepAlivePeriodInSeconds").build()}).build();
    private static final SdkField<List<InstanceGroup>> INSTANCE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceGroups").getter(ResourceConfig.getter(ResourceConfig::instanceGroups)).setter(ResourceConfig.setter(Builder::instanceGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, INSTANCE_COUNT_FIELD, VOLUME_SIZE_IN_GB_FIELD, VOLUME_KMS_KEY_ID_FIELD, KEEP_ALIVE_PERIOD_IN_SECONDS_FIELD, INSTANCE_GROUPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final Integer instanceCount;
    private final Integer volumeSizeInGB;
    private final String volumeKmsKeyId;
    private final Integer keepAlivePeriodInSeconds;
    private final List<InstanceGroup> instanceGroups;

    private ResourceConfig(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
        this.keepAlivePeriodInSeconds = builder.keepAlivePeriodInSeconds;
        this.instanceGroups = builder.instanceGroups;
    }

    public final TrainingInstanceType instanceType() {
        return TrainingInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final Integer volumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public final String volumeKmsKeyId() {
        return this.volumeKmsKeyId;
    }

    public final Integer keepAlivePeriodInSeconds() {
        return this.keepAlivePeriodInSeconds;
    }

    public final boolean hasInstanceGroups() {
        return this.instanceGroups != null && !(this.instanceGroups instanceof SdkAutoConstructList);
    }

    public final List<InstanceGroup> instanceGroups() {
        return this.instanceGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keepAlivePeriodInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceGroups() ? this.instanceGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceConfig)) {
            return false;
        }
        ResourceConfig other = (ResourceConfig)obj;
        return Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.volumeSizeInGB(), other.volumeSizeInGB()) && Objects.equals(this.volumeKmsKeyId(), other.volumeKmsKeyId()) && Objects.equals(this.keepAlivePeriodInSeconds(), other.keepAlivePeriodInSeconds()) && this.hasInstanceGroups() == other.hasInstanceGroups() && Objects.equals(this.instanceGroups(), other.instanceGroups());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceConfig").add("InstanceType", (Object)this.instanceTypeAsString()).add("InstanceCount", (Object)this.instanceCount()).add("VolumeSizeInGB", (Object)this.volumeSizeInGB()).add("VolumeKmsKeyId", (Object)this.volumeKmsKeyId()).add("KeepAlivePeriodInSeconds", (Object)this.keepAlivePeriodInSeconds()).add("InstanceGroups", this.hasInstanceGroups() ? this.instanceGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "VolumeSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeInGB()));
            }
            case "VolumeKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.volumeKmsKeyId()));
            }
            case "KeepAlivePeriodInSeconds": {
                return Optional.ofNullable(clazz.cast(this.keepAlivePeriodInSeconds()));
            }
            case "InstanceGroups": {
                return Optional.ofNullable(clazz.cast(this.instanceGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceConfig, T> g) {
        return obj -> g.apply((ResourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private Integer instanceCount;
        private Integer volumeSizeInGB;
        private String volumeKmsKeyId;
        private Integer keepAlivePeriodInSeconds;
        private List<InstanceGroup> instanceGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceConfig model) {
            this.instanceType(model.instanceType);
            this.instanceCount(model.instanceCount);
            this.volumeSizeInGB(model.volumeSizeInGB);
            this.volumeKmsKeyId(model.volumeKmsKeyId);
            this.keepAlivePeriodInSeconds(model.keepAlivePeriodInSeconds);
            this.instanceGroups(model.instanceGroups);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(TrainingInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Integer getVolumeSizeInGB() {
            return this.volumeSizeInGB;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final String getVolumeKmsKeyId() {
            return this.volumeKmsKeyId;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        @Override
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final Integer getKeepAlivePeriodInSeconds() {
            return this.keepAlivePeriodInSeconds;
        }

        public final void setKeepAlivePeriodInSeconds(Integer keepAlivePeriodInSeconds) {
            this.keepAlivePeriodInSeconds = keepAlivePeriodInSeconds;
        }

        @Override
        public final Builder keepAlivePeriodInSeconds(Integer keepAlivePeriodInSeconds) {
            this.keepAlivePeriodInSeconds = keepAlivePeriodInSeconds;
            return this;
        }

        public final List<InstanceGroup.Builder> getInstanceGroups() {
            List<InstanceGroup.Builder> result = InstanceGroupsCopier.copyToBuilder(this.instanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceGroups(Collection<InstanceGroup.BuilderImpl> instanceGroups) {
            this.instanceGroups = InstanceGroupsCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        public final Builder instanceGroups(Collection<InstanceGroup> instanceGroups) {
            this.instanceGroups = InstanceGroupsCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroup ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<InstanceGroup.Builder> ... instanceGroups) {
            this.instanceGroups(Stream.of(instanceGroups).map(c -> (InstanceGroup)((InstanceGroup.Builder)InstanceGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ResourceConfig build() {
            return new ResourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceConfig> {
        public Builder instanceType(String var1);

        public Builder instanceType(TrainingInstanceType var1);

        public Builder instanceCount(Integer var1);

        public Builder volumeSizeInGB(Integer var1);

        public Builder volumeKmsKeyId(String var1);

        public Builder keepAlivePeriodInSeconds(Integer var1);

        public Builder instanceGroups(Collection<InstanceGroup> var1);

        public Builder instanceGroups(InstanceGroup ... var1);

        public Builder instanceGroups(Consumer<InstanceGroup.Builder> ... var1);
    }
}

