/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ManagedInstanceScalingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductionVariantManagedInstanceScaling
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductionVariantManagedInstanceScaling> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProductionVariantManagedInstanceScaling.getter(ProductionVariantManagedInstanceScaling::statusAsString)).setter(ProductionVariantManagedInstanceScaling.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> MIN_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinInstanceCount").getter(ProductionVariantManagedInstanceScaling.getter(ProductionVariantManagedInstanceScaling::minInstanceCount)).setter(ProductionVariantManagedInstanceScaling.setter(Builder::minInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinInstanceCount").build()}).build();
    private static final SdkField<Integer> MAX_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxInstanceCount").getter(ProductionVariantManagedInstanceScaling.getter(ProductionVariantManagedInstanceScaling::maxInstanceCount)).setter(ProductionVariantManagedInstanceScaling.setter(Builder::maxInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInstanceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, MIN_INSTANCE_COUNT_FIELD, MAX_INSTANCE_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Integer minInstanceCount;
    private final Integer maxInstanceCount;

    private ProductionVariantManagedInstanceScaling(BuilderImpl builder) {
        this.status = builder.status;
        this.minInstanceCount = builder.minInstanceCount;
        this.maxInstanceCount = builder.maxInstanceCount;
    }

    public final ManagedInstanceScalingStatus status() {
        return ManagedInstanceScalingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer minInstanceCount() {
        return this.minInstanceCount;
    }

    public final Integer maxInstanceCount() {
        return this.maxInstanceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxInstanceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariantManagedInstanceScaling)) {
            return false;
        }
        ProductionVariantManagedInstanceScaling other = (ProductionVariantManagedInstanceScaling)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.minInstanceCount(), other.minInstanceCount()) && Objects.equals(this.maxInstanceCount(), other.maxInstanceCount());
    }

    public final String toString() {
        return ToString.builder((String)"ProductionVariantManagedInstanceScaling").add("Status", (Object)this.statusAsString()).add("MinInstanceCount", (Object)this.minInstanceCount()).add("MaxInstanceCount", (Object)this.maxInstanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "MinInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.minInstanceCount()));
            }
            case "MaxInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.maxInstanceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductionVariantManagedInstanceScaling, T> g) {
        return obj -> g.apply((ProductionVariantManagedInstanceScaling)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Integer minInstanceCount;
        private Integer maxInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariantManagedInstanceScaling model) {
            this.status(model.status);
            this.minInstanceCount(model.minInstanceCount);
            this.maxInstanceCount(model.maxInstanceCount);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ManagedInstanceScalingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getMinInstanceCount() {
            return this.minInstanceCount;
        }

        public final void setMinInstanceCount(Integer minInstanceCount) {
            this.minInstanceCount = minInstanceCount;
        }

        @Override
        public final Builder minInstanceCount(Integer minInstanceCount) {
            this.minInstanceCount = minInstanceCount;
            return this;
        }

        public final Integer getMaxInstanceCount() {
            return this.maxInstanceCount;
        }

        public final void setMaxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
        }

        @Override
        public final Builder maxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
            return this;
        }

        public ProductionVariantManagedInstanceScaling build() {
            return new ProductionVariantManagedInstanceScaling(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductionVariantManagedInstanceScaling> {
        public Builder status(String var1);

        public Builder status(ManagedInstanceScalingStatus var1);

        public Builder minInstanceCount(Integer var1);

        public Builder maxInstanceCount(Integer var1);
    }
}

