/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VariantPropertyType {
    DESIRED_INSTANCE_COUNT("DesiredInstanceCount"),
    DESIRED_WEIGHT("DesiredWeight"),
    DATA_CAPTURE_CONFIG("DataCaptureConfig"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VariantPropertyType> VALUE_MAP;
    private final String value;

    private VariantPropertyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VariantPropertyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VariantPropertyType> knownValues() {
        EnumSet<VariantPropertyType> knownValues = EnumSet.allOf(VariantPropertyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VariantPropertyType.class, VariantPropertyType::toString);
    }
}

