/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJobStep;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsResponse;

public class ListInferenceRecommendationsJobStepsIterable
implements SdkIterable<ListInferenceRecommendationsJobStepsResponse> {
    private final SageMakerClient client;
    private final ListInferenceRecommendationsJobStepsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInferenceRecommendationsJobStepsIterable(SageMakerClient client, ListInferenceRecommendationsJobStepsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInferenceRecommendationsJobStepsResponseFetcher();
    }

    public Iterator<ListInferenceRecommendationsJobStepsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InferenceRecommendationsJobStep> steps() {
        Function<ListInferenceRecommendationsJobStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.steps() != null) {
                return response.steps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInferenceRecommendationsJobStepsResponseFetcher
    implements SyncPageFetcher<ListInferenceRecommendationsJobStepsResponse> {
        private ListInferenceRecommendationsJobStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceRecommendationsJobStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInferenceRecommendationsJobStepsResponse nextPage(ListInferenceRecommendationsJobStepsResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceRecommendationsJobStepsIterable.this.client.listInferenceRecommendationsJobSteps(ListInferenceRecommendationsJobStepsIterable.this.firstRequest);
            }
            return ListInferenceRecommendationsJobStepsIterable.this.client.listInferenceRecommendationsJobSteps((ListInferenceRecommendationsJobStepsRequest)((Object)ListInferenceRecommendationsJobStepsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

