/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.OnlineStoreSecurityConfig;
import software.amazon.awssdk.services.sagemaker.model.StorageType;
import software.amazon.awssdk.services.sagemaker.model.TtlDuration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OnlineStoreConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OnlineStoreConfig> {
    private static final SdkField<OnlineStoreSecurityConfig> SECURITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityConfig").getter(OnlineStoreConfig.getter(OnlineStoreConfig::securityConfig)).setter(OnlineStoreConfig.setter(Builder::securityConfig)).constructor(OnlineStoreSecurityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfig").build()}).build();
    private static final SdkField<Boolean> ENABLE_ONLINE_STORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableOnlineStore").getter(OnlineStoreConfig.getter(OnlineStoreConfig::enableOnlineStore)).setter(OnlineStoreConfig.setter(Builder::enableOnlineStore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableOnlineStore").build()}).build();
    private static final SdkField<TtlDuration> TTL_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TtlDuration").getter(OnlineStoreConfig.getter(OnlineStoreConfig::ttlDuration)).setter(OnlineStoreConfig.setter(Builder::ttlDuration)).constructor(TtlDuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TtlDuration").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(OnlineStoreConfig.getter(OnlineStoreConfig::storageTypeAsString)).setter(OnlineStoreConfig.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONFIG_FIELD, ENABLE_ONLINE_STORE_FIELD, TTL_DURATION_FIELD, STORAGE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final OnlineStoreSecurityConfig securityConfig;
    private final Boolean enableOnlineStore;
    private final TtlDuration ttlDuration;
    private final String storageType;

    private OnlineStoreConfig(BuilderImpl builder) {
        this.securityConfig = builder.securityConfig;
        this.enableOnlineStore = builder.enableOnlineStore;
        this.ttlDuration = builder.ttlDuration;
        this.storageType = builder.storageType;
    }

    public final OnlineStoreSecurityConfig securityConfig() {
        return this.securityConfig;
    }

    public final Boolean enableOnlineStore() {
        return this.enableOnlineStore;
    }

    public final TtlDuration ttlDuration() {
        return this.ttlDuration;
    }

    public final StorageType storageType() {
        return StorageType.fromValue(this.storageType);
    }

    public final String storageTypeAsString() {
        return this.storageType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableOnlineStore());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttlDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnlineStoreConfig)) {
            return false;
        }
        OnlineStoreConfig other = (OnlineStoreConfig)obj;
        return Objects.equals(this.securityConfig(), other.securityConfig()) && Objects.equals(this.enableOnlineStore(), other.enableOnlineStore()) && Objects.equals(this.ttlDuration(), other.ttlDuration()) && Objects.equals(this.storageTypeAsString(), other.storageTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OnlineStoreConfig").add("SecurityConfig", (Object)this.securityConfig()).add("EnableOnlineStore", (Object)this.enableOnlineStore()).add("TtlDuration", (Object)this.ttlDuration()).add("StorageType", (Object)this.storageTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityConfig": {
                return Optional.ofNullable(clazz.cast(this.securityConfig()));
            }
            case "EnableOnlineStore": {
                return Optional.ofNullable(clazz.cast(this.enableOnlineStore()));
            }
            case "TtlDuration": {
                return Optional.ofNullable(clazz.cast(this.ttlDuration()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnlineStoreConfig, T> g) {
        return obj -> g.apply((OnlineStoreConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OnlineStoreSecurityConfig securityConfig;
        private Boolean enableOnlineStore;
        private TtlDuration ttlDuration;
        private String storageType;

        private BuilderImpl() {
        }

        private BuilderImpl(OnlineStoreConfig model) {
            this.securityConfig(model.securityConfig);
            this.enableOnlineStore(model.enableOnlineStore);
            this.ttlDuration(model.ttlDuration);
            this.storageType(model.storageType);
        }

        public final OnlineStoreSecurityConfig.Builder getSecurityConfig() {
            return this.securityConfig != null ? this.securityConfig.toBuilder() : null;
        }

        public final void setSecurityConfig(OnlineStoreSecurityConfig.BuilderImpl securityConfig) {
            this.securityConfig = securityConfig != null ? securityConfig.build() : null;
        }

        @Override
        public final Builder securityConfig(OnlineStoreSecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        public final Boolean getEnableOnlineStore() {
            return this.enableOnlineStore;
        }

        public final void setEnableOnlineStore(Boolean enableOnlineStore) {
            this.enableOnlineStore = enableOnlineStore;
        }

        @Override
        public final Builder enableOnlineStore(Boolean enableOnlineStore) {
            this.enableOnlineStore = enableOnlineStore;
            return this;
        }

        public final TtlDuration.Builder getTtlDuration() {
            return this.ttlDuration != null ? this.ttlDuration.toBuilder() : null;
        }

        public final void setTtlDuration(TtlDuration.BuilderImpl ttlDuration) {
            this.ttlDuration = ttlDuration != null ? ttlDuration.build() : null;
        }

        @Override
        public final Builder ttlDuration(TtlDuration ttlDuration) {
            this.ttlDuration = ttlDuration;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public OnlineStoreConfig build() {
            return new OnlineStoreConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OnlineStoreConfig> {
        public Builder securityConfig(OnlineStoreSecurityConfig var1);

        default public Builder securityConfig(Consumer<OnlineStoreSecurityConfig.Builder> securityConfig) {
            return this.securityConfig((OnlineStoreSecurityConfig)((OnlineStoreSecurityConfig.Builder)OnlineStoreSecurityConfig.builder().applyMutation(securityConfig)).build());
        }

        public Builder enableOnlineStore(Boolean var1);

        public Builder ttlDuration(TtlDuration var1);

        default public Builder ttlDuration(Consumer<TtlDuration.Builder> ttlDuration) {
            return this.ttlDuration((TtlDuration)((TtlDuration.Builder)TtlDuration.builder().applyMutation(ttlDuration)).build());
        }

        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);
    }
}

