/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListUserProfilesResponse;
import software.amazon.awssdk.services.sagemaker.model.UserProfileDetails;

public class ListUserProfilesPublisher
implements SdkPublisher<ListUserProfilesResponse> {
    private final SageMakerAsyncClient client;
    private final ListUserProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUserProfilesPublisher(SageMakerAsyncClient client, ListUserProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUserProfilesPublisher(SageMakerAsyncClient client, ListUserProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUserProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUserProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UserProfileDetails> userProfiles() {
        Function<ListUserProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.userProfiles() != null) {
                return response.userProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUserProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUserProfilesResponseFetcher
    implements AsyncPageFetcher<ListUserProfilesResponse> {
        private ListUserProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListUserProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUserProfilesResponse> nextPage(ListUserProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListUserProfilesPublisher.this.client.listUserProfiles(ListUserProfilesPublisher.this.firstRequest);
            }
            return ListUserProfilesPublisher.this.client.listUserProfiles((ListUserProfilesRequest)((Object)ListUserProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

