/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinitionSummary;

public class ListModelExplainabilityJobDefinitionsIterable
implements SdkIterable<ListModelExplainabilityJobDefinitionsResponse> {
    private final SageMakerClient client;
    private final ListModelExplainabilityJobDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelExplainabilityJobDefinitionsIterable(SageMakerClient client, ListModelExplainabilityJobDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListModelExplainabilityJobDefinitionsResponseFetcher();
    }

    public Iterator<ListModelExplainabilityJobDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MonitoringJobDefinitionSummary> jobDefinitionSummaries() {
        Function<ListModelExplainabilityJobDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobDefinitionSummaries() != null) {
                return response.jobDefinitionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelExplainabilityJobDefinitionsResponseFetcher
    implements SyncPageFetcher<ListModelExplainabilityJobDefinitionsResponse> {
        private ListModelExplainabilityJobDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelExplainabilityJobDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelExplainabilityJobDefinitionsResponse nextPage(ListModelExplainabilityJobDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListModelExplainabilityJobDefinitionsIterable.this.client.listModelExplainabilityJobDefinitions(ListModelExplainabilityJobDefinitionsIterable.this.firstRequest);
            }
            return ListModelExplainabilityJobDefinitionsIterable.this.client.listModelExplainabilityJobDefinitions((ListModelExplainabilityJobDefinitionsRequest)((Object)ListModelExplainabilityJobDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

