/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.waiters.SageMakerWaiter;
import software.amazon.awssdk.services.sagemaker.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultSageMakerWaiter
implements SageMakerWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final SageMakerClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeNotebookInstanceResponse> notebookInstanceInServiceWaiter;
    private final Waiter<DescribeNotebookInstanceResponse> notebookInstanceStoppedWaiter;
    private final Waiter<DescribeNotebookInstanceResponse> notebookInstanceDeletedWaiter;
    private final Waiter<DescribeTrainingJobResponse> trainingJobCompletedOrStoppedWaiter;
    private final Waiter<DescribeEndpointResponse> endpointInServiceWaiter;
    private final Waiter<DescribeEndpointResponse> endpointDeletedWaiter;
    private final Waiter<DescribeTransformJobResponse> transformJobCompletedOrStoppedWaiter;
    private final Waiter<DescribeProcessingJobResponse> processingJobCompletedOrStoppedWaiter;
    private final Waiter<DescribeImageResponse> imageCreatedWaiter;
    private final Waiter<DescribeImageResponse> imageUpdatedWaiter;
    private final Waiter<DescribeImageResponse> imageDeletedWaiter;
    private final Waiter<DescribeImageVersionResponse> imageVersionCreatedWaiter;
    private final Waiter<DescribeImageVersionResponse> imageVersionDeletedWaiter;

    private DefaultSageMakerWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (SageMakerClient)SageMakerClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.notebookInstanceInServiceWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeNotebookInstanceResponse.class).acceptors(DefaultSageMakerWaiter.notebookInstanceInServiceWaiterAcceptors())).overrideConfiguration(DefaultSageMakerWaiter.notebookInstanceInServiceWaiterConfig(builder.overrideConfiguration))).build();
        this.notebookInstanceStoppedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeNotebookInstanceResponse.class).acceptors(DefaultSageMakerWaiter.notebookInstanceStoppedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerWaiter.notebookInstanceStoppedWaiterConfig(builder.overrideConfiguration))).build();
        this.notebookInstanceDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeNotebookInstanceResponse.class).acceptors(DefaultSageMakerWaiter.notebookInstanceDeletedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerWaiter.notebookInstanceDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.trainingJobCompletedOrStoppedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeTrainingJobResponse.class).acceptors(DefaultSageMakerWaiter.trainingJobCompletedOrStoppedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerWaiter.trainingJobCompletedOrStoppedWaiterConfig(builder.overrideConfiguration))).build();
        this.endpointInServiceWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeEndpointResponse.class).acceptors(DefaultSageMakerWaiter.endpointInServiceWaiterAcceptors())).overrideConfiguration(DefaultSageMakerWaiter.endpointInServiceWaiterConfig(builder.overrideConfiguration))).build();
        this.endpointDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeEndpointResponse.class).acceptors(DefaultSageMakerWaiter.endpointDeletedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerWaiter.endpointDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.transformJobCompletedOrStoppedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeTransformJobResponse.class).acceptors(DefaultSageMakerWaiter.transformJobCompletedOrStoppedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerWaiter.transformJobCompletedOrStoppedWaiterConfig(builder.overrideConfiguration))).build();
        this.processingJobCompletedOrStoppedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeProcessingJobResponse.class).acceptors(DefaultSageMakerWaiter.processingJobCompletedOrStoppedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerWaiter.processingJobCompletedOrStoppedWaiterConfig(builder.overrideConfiguration))).build();
        this.imageCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeImageResponse.class).acceptors(DefaultSageMakerWaiter.imageCreatedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerWaiter.imageCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.imageUpdatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeImageResponse.class).acceptors(DefaultSageMakerWaiter.imageUpdatedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerWaiter.imageUpdatedWaiterConfig(builder.overrideConfiguration))).build();
        this.imageDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeImageResponse.class).acceptors(DefaultSageMakerWaiter.imageDeletedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerWaiter.imageDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.imageVersionCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeImageVersionResponse.class).acceptors(DefaultSageMakerWaiter.imageVersionCreatedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerWaiter.imageVersionCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.imageVersionDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeImageVersionResponse.class).acceptors(DefaultSageMakerWaiter.imageVersionDeletedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerWaiter.imageVersionDeletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeEndpointResponse> waitUntilEndpointDeleted(DescribeEndpointRequest describeEndpointRequest) {
        return this.endpointDeletedWaiter.run(() -> this.client.describeEndpoint(this.applyWaitersUserAgent(describeEndpointRequest)));
    }

    @Override
    public WaiterResponse<DescribeEndpointResponse> waitUntilEndpointDeleted(DescribeEndpointRequest describeEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.endpointDeletedWaiter.run(() -> this.client.describeEndpoint(this.applyWaitersUserAgent(describeEndpointRequest)), DefaultSageMakerWaiter.endpointDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeEndpointResponse> waitUntilEndpointInService(DescribeEndpointRequest describeEndpointRequest) {
        return this.endpointInServiceWaiter.run(() -> this.client.describeEndpoint(this.applyWaitersUserAgent(describeEndpointRequest)));
    }

    @Override
    public WaiterResponse<DescribeEndpointResponse> waitUntilEndpointInService(DescribeEndpointRequest describeEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.endpointInServiceWaiter.run(() -> this.client.describeEndpoint(this.applyWaitersUserAgent(describeEndpointRequest)), DefaultSageMakerWaiter.endpointInServiceWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeImageResponse> waitUntilImageCreated(DescribeImageRequest describeImageRequest) {
        return this.imageCreatedWaiter.run(() -> this.client.describeImage(this.applyWaitersUserAgent(describeImageRequest)));
    }

    @Override
    public WaiterResponse<DescribeImageResponse> waitUntilImageCreated(DescribeImageRequest describeImageRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageCreatedWaiter.run(() -> this.client.describeImage(this.applyWaitersUserAgent(describeImageRequest)), DefaultSageMakerWaiter.imageCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeImageResponse> waitUntilImageDeleted(DescribeImageRequest describeImageRequest) {
        return this.imageDeletedWaiter.run(() -> this.client.describeImage(this.applyWaitersUserAgent(describeImageRequest)));
    }

    @Override
    public WaiterResponse<DescribeImageResponse> waitUntilImageDeleted(DescribeImageRequest describeImageRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageDeletedWaiter.run(() -> this.client.describeImage(this.applyWaitersUserAgent(describeImageRequest)), DefaultSageMakerWaiter.imageDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeImageResponse> waitUntilImageUpdated(DescribeImageRequest describeImageRequest) {
        return this.imageUpdatedWaiter.run(() -> this.client.describeImage(this.applyWaitersUserAgent(describeImageRequest)));
    }

    @Override
    public WaiterResponse<DescribeImageResponse> waitUntilImageUpdated(DescribeImageRequest describeImageRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageUpdatedWaiter.run(() -> this.client.describeImage(this.applyWaitersUserAgent(describeImageRequest)), DefaultSageMakerWaiter.imageUpdatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeImageVersionResponse> waitUntilImageVersionCreated(DescribeImageVersionRequest describeImageVersionRequest) {
        return this.imageVersionCreatedWaiter.run(() -> this.client.describeImageVersion(this.applyWaitersUserAgent(describeImageVersionRequest)));
    }

    @Override
    public WaiterResponse<DescribeImageVersionResponse> waitUntilImageVersionCreated(DescribeImageVersionRequest describeImageVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageVersionCreatedWaiter.run(() -> this.client.describeImageVersion(this.applyWaitersUserAgent(describeImageVersionRequest)), DefaultSageMakerWaiter.imageVersionCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeImageVersionResponse> waitUntilImageVersionDeleted(DescribeImageVersionRequest describeImageVersionRequest) {
        return this.imageVersionDeletedWaiter.run(() -> this.client.describeImageVersion(this.applyWaitersUserAgent(describeImageVersionRequest)));
    }

    @Override
    public WaiterResponse<DescribeImageVersionResponse> waitUntilImageVersionDeleted(DescribeImageVersionRequest describeImageVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageVersionDeletedWaiter.run(() -> this.client.describeImageVersion(this.applyWaitersUserAgent(describeImageVersionRequest)), DefaultSageMakerWaiter.imageVersionDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeNotebookInstanceResponse> waitUntilNotebookInstanceDeleted(DescribeNotebookInstanceRequest describeNotebookInstanceRequest) {
        return this.notebookInstanceDeletedWaiter.run(() -> this.client.describeNotebookInstance(this.applyWaitersUserAgent(describeNotebookInstanceRequest)));
    }

    @Override
    public WaiterResponse<DescribeNotebookInstanceResponse> waitUntilNotebookInstanceDeleted(DescribeNotebookInstanceRequest describeNotebookInstanceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.notebookInstanceDeletedWaiter.run(() -> this.client.describeNotebookInstance(this.applyWaitersUserAgent(describeNotebookInstanceRequest)), DefaultSageMakerWaiter.notebookInstanceDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeNotebookInstanceResponse> waitUntilNotebookInstanceInService(DescribeNotebookInstanceRequest describeNotebookInstanceRequest) {
        return this.notebookInstanceInServiceWaiter.run(() -> this.client.describeNotebookInstance(this.applyWaitersUserAgent(describeNotebookInstanceRequest)));
    }

    @Override
    public WaiterResponse<DescribeNotebookInstanceResponse> waitUntilNotebookInstanceInService(DescribeNotebookInstanceRequest describeNotebookInstanceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.notebookInstanceInServiceWaiter.run(() -> this.client.describeNotebookInstance(this.applyWaitersUserAgent(describeNotebookInstanceRequest)), DefaultSageMakerWaiter.notebookInstanceInServiceWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeNotebookInstanceResponse> waitUntilNotebookInstanceStopped(DescribeNotebookInstanceRequest describeNotebookInstanceRequest) {
        return this.notebookInstanceStoppedWaiter.run(() -> this.client.describeNotebookInstance(this.applyWaitersUserAgent(describeNotebookInstanceRequest)));
    }

    @Override
    public WaiterResponse<DescribeNotebookInstanceResponse> waitUntilNotebookInstanceStopped(DescribeNotebookInstanceRequest describeNotebookInstanceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.notebookInstanceStoppedWaiter.run(() -> this.client.describeNotebookInstance(this.applyWaitersUserAgent(describeNotebookInstanceRequest)), DefaultSageMakerWaiter.notebookInstanceStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeProcessingJobResponse> waitUntilProcessingJobCompletedOrStopped(DescribeProcessingJobRequest describeProcessingJobRequest) {
        return this.processingJobCompletedOrStoppedWaiter.run(() -> this.client.describeProcessingJob(this.applyWaitersUserAgent(describeProcessingJobRequest)));
    }

    @Override
    public WaiterResponse<DescribeProcessingJobResponse> waitUntilProcessingJobCompletedOrStopped(DescribeProcessingJobRequest describeProcessingJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.processingJobCompletedOrStoppedWaiter.run(() -> this.client.describeProcessingJob(this.applyWaitersUserAgent(describeProcessingJobRequest)), DefaultSageMakerWaiter.processingJobCompletedOrStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeTrainingJobResponse> waitUntilTrainingJobCompletedOrStopped(DescribeTrainingJobRequest describeTrainingJobRequest) {
        return this.trainingJobCompletedOrStoppedWaiter.run(() -> this.client.describeTrainingJob(this.applyWaitersUserAgent(describeTrainingJobRequest)));
    }

    @Override
    public WaiterResponse<DescribeTrainingJobResponse> waitUntilTrainingJobCompletedOrStopped(DescribeTrainingJobRequest describeTrainingJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.trainingJobCompletedOrStoppedWaiter.run(() -> this.client.describeTrainingJob(this.applyWaitersUserAgent(describeTrainingJobRequest)), DefaultSageMakerWaiter.trainingJobCompletedOrStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeTransformJobResponse> waitUntilTransformJobCompletedOrStopped(DescribeTransformJobRequest describeTransformJobRequest) {
        return this.transformJobCompletedOrStoppedWaiter.run(() -> this.client.describeTransformJob(this.applyWaitersUserAgent(describeTransformJobRequest)));
    }

    @Override
    public WaiterResponse<DescribeTransformJobResponse> waitUntilTransformJobCompletedOrStopped(DescribeTransformJobRequest describeTransformJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.transformJobCompletedOrStoppedWaiter.run(() -> this.client.describeTransformJob(this.applyWaitersUserAgent(describeTransformJobRequest)), DefaultSageMakerWaiter.transformJobCompletedOrStoppedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeNotebookInstanceResponse>> notebookInstanceInServiceWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNotebookInstanceResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNotebookInstanceResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("NotebookInstanceStatus").value(), "InService");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("NotebookInstanceStatus").value(), "Failed");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNotebookInstanceResponse>> notebookInstanceStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNotebookInstanceResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNotebookInstanceResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("NotebookInstanceStatus").value(), "Stopped");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("NotebookInstanceStatus").value(), "Failed");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNotebookInstanceResponse>> notebookInstanceDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNotebookInstanceResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNotebookInstanceResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerWaiter.errorCode(error), "ValidationException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("NotebookInstanceStatus").value(), "Failed");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTrainingJobResponse>> trainingJobCompletedOrStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTrainingJobResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTrainingJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("TrainingJobStatus").value(), "Completed");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("TrainingJobStatus").value(), "Stopped");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("TrainingJobStatus").value(), "Failed");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeEndpointResponse>> endpointInServiceWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeEndpointResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeEndpointResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("EndpointStatus").value(), "InService");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("EndpointStatus").value(), "Failed");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeEndpointResponse>> endpointDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeEndpointResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeEndpointResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerWaiter.errorCode(error), "ValidationException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("EndpointStatus").value(), "Failed");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTransformJobResponse>> transformJobCompletedOrStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTransformJobResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTransformJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("TransformJobStatus").value(), "Completed");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("TransformJobStatus").value(), "Stopped");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("TransformJobStatus").value(), "Failed");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeProcessingJobResponse>> processingJobCompletedOrStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeProcessingJobResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeProcessingJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ProcessingJobStatus").value(), "Completed");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ProcessingJobStatus").value(), "Stopped");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ProcessingJobStatus").value(), "Failed");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImageResponse>> imageCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImageResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImageResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageStatus").value(), "CREATED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageStatus").value(), "CREATE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImageResponse>> imageUpdatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImageResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImageResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageStatus").value(), "CREATED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageStatus").value(), "UPDATE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImageResponse>> imageDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImageResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImageResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageStatus").value(), "DELETE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImageVersionResponse>> imageVersionCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImageVersionResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImageVersionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageVersionStatus").value(), "CREATED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageVersionStatus").value(), "CREATE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImageVersionResponse>> imageVersionDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImageVersionResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImageVersionResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageVersionStatus").value(), "DELETE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration notebookInstanceInServiceWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration notebookInstanceStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration notebookInstanceDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration trainingJobCompletedOrStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(120L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration endpointInServiceWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration endpointDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration transformJobCompletedOrStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration processingJobCompletedOrStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageUpdatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageVersionCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageVersionDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static SageMakerWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends SageMakerRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SageMakerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements SageMakerWaiter.Builder {
        private SageMakerClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public SageMakerWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public SageMakerWaiter.Builder client(SageMakerClient client) {
            this.client = client;
            return this;
        }

        @Override
        public SageMakerWaiter build() {
            return new DefaultSageMakerWaiter(this);
        }
    }
}

