/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobSummary;

public class ListTrainingJobsPublisher
implements SdkPublisher<ListTrainingJobsResponse> {
    private final SageMakerAsyncClient client;
    private final ListTrainingJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrainingJobsPublisher(SageMakerAsyncClient client, ListTrainingJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrainingJobsPublisher(SageMakerAsyncClient client, ListTrainingJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrainingJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrainingJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrainingJobSummary> trainingJobSummaries() {
        Function<ListTrainingJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trainingJobSummaries() != null) {
                return response.trainingJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTrainingJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTrainingJobsResponseFetcher
    implements AsyncPageFetcher<ListTrainingJobsResponse> {
        private ListTrainingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrainingJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrainingJobsResponse> nextPage(ListTrainingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTrainingJobsPublisher.this.client.listTrainingJobs(ListTrainingJobsPublisher.this.firstRequest);
            }
            return ListTrainingJobsPublisher.this.client.listTrainingJobs((ListTrainingJobsRequest)((Object)ListTrainingJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

