/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProcessingS3DataType {
    MANIFEST_FILE("ManifestFile"),
    S3_PREFIX("S3Prefix"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProcessingS3DataType> VALUE_MAP;
    private final String value;

    private ProcessingS3DataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProcessingS3DataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProcessingS3DataType> knownValues() {
        EnumSet<ProcessingS3DataType> knownValues = EnumSet.allOf(ProcessingS3DataType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProcessingS3DataType.class, ProcessingS3DataType::toString);
    }
}

