/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoParameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AutoParameter.getter(AutoParameter::name)).setter(AutoParameter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VALUE_HINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueHint").getter(AutoParameter.getter(AutoParameter::valueHint)).setter(AutoParameter.setter(Builder::valueHint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueHint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_HINT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String valueHint;

    private AutoParameter(BuilderImpl builder) {
        this.name = builder.name;
        this.valueHint = builder.valueHint;
    }

    public final String name() {
        return this.name;
    }

    public final String valueHint() {
        return this.valueHint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueHint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoParameter)) {
            return false;
        }
        AutoParameter other = (AutoParameter)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.valueHint(), other.valueHint());
    }

    public final String toString() {
        return ToString.builder((String)"AutoParameter").add("Name", (Object)this.name()).add("ValueHint", (Object)this.valueHint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ValueHint": {
                return Optional.ofNullable(clazz.cast(this.valueHint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoParameter, T> g) {
        return obj -> g.apply((AutoParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String valueHint;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoParameter model) {
            this.name(model.name);
            this.valueHint(model.valueHint);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValueHint() {
            return this.valueHint;
        }

        public final void setValueHint(String valueHint) {
            this.valueHint = valueHint;
        }

        @Override
        public final Builder valueHint(String valueHint) {
            this.valueHint = valueHint;
            return this;
        }

        public AutoParameter build() {
            return new AutoParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoParameter> {
        public Builder name(String var1);

        public Builder valueHint(String var1);
    }
}

