/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metrics for an existing endpoint compared in an Inference Recommender job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceMetrics.Builder, InferenceMetrics> {
    private static final SdkField<Integer> MAX_INVOCATIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxInvocations").getter(getter(InferenceMetrics::maxInvocations))
            .setter(setter(Builder::maxInvocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInvocations").build()).build();

    private static final SdkField<Integer> MODEL_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ModelLatency").getter(getter(InferenceMetrics::modelLatency)).setter(setter(Builder::modelLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelLatency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_INVOCATIONS_FIELD,
            MODEL_LATENCY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxInvocations;

    private final Integer modelLatency;

    private InferenceMetrics(BuilderImpl builder) {
        this.maxInvocations = builder.maxInvocations;
        this.modelLatency = builder.modelLatency;
    }

    /**
     * <p>
     * The expected maximum number of requests per minute for the instance.
     * </p>
     * 
     * @return The expected maximum number of requests per minute for the instance.
     */
    public final Integer maxInvocations() {
        return maxInvocations;
    }

    /**
     * <p>
     * The expected model latency at maximum invocations per minute for the instance.
     * </p>
     * 
     * @return The expected model latency at maximum invocations per minute for the instance.
     */
    public final Integer modelLatency() {
        return modelLatency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxInvocations());
        hashCode = 31 * hashCode + Objects.hashCode(modelLatency());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceMetrics)) {
            return false;
        }
        InferenceMetrics other = (InferenceMetrics) obj;
        return Objects.equals(maxInvocations(), other.maxInvocations()) && Objects.equals(modelLatency(), other.modelLatency());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceMetrics").add("MaxInvocations", maxInvocations()).add("ModelLatency", modelLatency())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxInvocations":
            return Optional.ofNullable(clazz.cast(maxInvocations()));
        case "ModelLatency":
            return Optional.ofNullable(clazz.cast(modelLatency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceMetrics, T> g) {
        return obj -> g.apply((InferenceMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceMetrics> {
        /**
         * <p>
         * The expected maximum number of requests per minute for the instance.
         * </p>
         * 
         * @param maxInvocations
         *        The expected maximum number of requests per minute for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxInvocations(Integer maxInvocations);

        /**
         * <p>
         * The expected model latency at maximum invocations per minute for the instance.
         * </p>
         * 
         * @param modelLatency
         *        The expected model latency at maximum invocations per minute for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelLatency(Integer modelLatency);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxInvocations;

        private Integer modelLatency;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceMetrics model) {
            maxInvocations(model.maxInvocations);
            modelLatency(model.modelLatency);
        }

        public final Integer getMaxInvocations() {
            return maxInvocations;
        }

        public final void setMaxInvocations(Integer maxInvocations) {
            this.maxInvocations = maxInvocations;
        }

        @Override
        public final Builder maxInvocations(Integer maxInvocations) {
            this.maxInvocations = maxInvocations;
            return this;
        }

        public final Integer getModelLatency() {
            return modelLatency;
        }

        public final void setModelLatency(Integer modelLatency) {
            this.modelLatency = modelLatency;
        }

        @Override
        public final Builder modelLatency(Integer modelLatency) {
            this.modelLatency = modelLatency;
            return this;
        }

        @Override
        public InferenceMetrics build() {
            return new InferenceMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
