/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SageMaker Canvas application settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanvasAppSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<CanvasAppSettings.Builder, CanvasAppSettings> {
    private static final SdkField<TimeSeriesForecastingSettings> TIME_SERIES_FORECASTING_SETTINGS_FIELD = SdkField
            .<TimeSeriesForecastingSettings> builder(MarshallingType.SDK_POJO)
            .memberName("TimeSeriesForecastingSettings")
            .getter(getter(CanvasAppSettings::timeSeriesForecastingSettings))
            .setter(setter(Builder::timeSeriesForecastingSettings))
            .constructor(TimeSeriesForecastingSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesForecastingSettings")
                    .build()).build();

    private static final SdkField<ModelRegisterSettings> MODEL_REGISTER_SETTINGS_FIELD = SdkField
            .<ModelRegisterSettings> builder(MarshallingType.SDK_POJO).memberName("ModelRegisterSettings")
            .getter(getter(CanvasAppSettings::modelRegisterSettings)).setter(setter(Builder::modelRegisterSettings))
            .constructor(ModelRegisterSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelRegisterSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TIME_SERIES_FORECASTING_SETTINGS_FIELD, MODEL_REGISTER_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final TimeSeriesForecastingSettings timeSeriesForecastingSettings;

    private final ModelRegisterSettings modelRegisterSettings;

    private CanvasAppSettings(BuilderImpl builder) {
        this.timeSeriesForecastingSettings = builder.timeSeriesForecastingSettings;
        this.modelRegisterSettings = builder.modelRegisterSettings;
    }

    /**
     * <p>
     * Time series forecast settings for the Canvas application.
     * </p>
     * 
     * @return Time series forecast settings for the Canvas application.
     */
    public final TimeSeriesForecastingSettings timeSeriesForecastingSettings() {
        return timeSeriesForecastingSettings;
    }

    /**
     * <p>
     * The model registry settings for the SageMaker Canvas application.
     * </p>
     * 
     * @return The model registry settings for the SageMaker Canvas application.
     */
    public final ModelRegisterSettings modelRegisterSettings() {
        return modelRegisterSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesForecastingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(modelRegisterSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanvasAppSettings)) {
            return false;
        }
        CanvasAppSettings other = (CanvasAppSettings) obj;
        return Objects.equals(timeSeriesForecastingSettings(), other.timeSeriesForecastingSettings())
                && Objects.equals(modelRegisterSettings(), other.modelRegisterSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanvasAppSettings").add("TimeSeriesForecastingSettings", timeSeriesForecastingSettings())
                .add("ModelRegisterSettings", modelRegisterSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeSeriesForecastingSettings":
            return Optional.ofNullable(clazz.cast(timeSeriesForecastingSettings()));
        case "ModelRegisterSettings":
            return Optional.ofNullable(clazz.cast(modelRegisterSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanvasAppSettings, T> g) {
        return obj -> g.apply((CanvasAppSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanvasAppSettings> {
        /**
         * <p>
         * Time series forecast settings for the Canvas application.
         * </p>
         * 
         * @param timeSeriesForecastingSettings
         *        Time series forecast settings for the Canvas application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesForecastingSettings(TimeSeriesForecastingSettings timeSeriesForecastingSettings);

        /**
         * <p>
         * Time series forecast settings for the Canvas application.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeSeriesForecastingSettings.Builder}
         * avoiding the need to create one manually via {@link TimeSeriesForecastingSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeSeriesForecastingSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #timeSeriesForecastingSettings(TimeSeriesForecastingSettings)}.
         * 
         * @param timeSeriesForecastingSettings
         *        a consumer that will call methods on {@link TimeSeriesForecastingSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesForecastingSettings(TimeSeriesForecastingSettings)
         */
        default Builder timeSeriesForecastingSettings(
                Consumer<TimeSeriesForecastingSettings.Builder> timeSeriesForecastingSettings) {
            return timeSeriesForecastingSettings(TimeSeriesForecastingSettings.builder()
                    .applyMutation(timeSeriesForecastingSettings).build());
        }

        /**
         * <p>
         * The model registry settings for the SageMaker Canvas application.
         * </p>
         * 
         * @param modelRegisterSettings
         *        The model registry settings for the SageMaker Canvas application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelRegisterSettings(ModelRegisterSettings modelRegisterSettings);

        /**
         * <p>
         * The model registry settings for the SageMaker Canvas application.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelRegisterSettings.Builder} avoiding
         * the need to create one manually via {@link ModelRegisterSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelRegisterSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #modelRegisterSettings(ModelRegisterSettings)}.
         * 
         * @param modelRegisterSettings
         *        a consumer that will call methods on {@link ModelRegisterSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelRegisterSettings(ModelRegisterSettings)
         */
        default Builder modelRegisterSettings(Consumer<ModelRegisterSettings.Builder> modelRegisterSettings) {
            return modelRegisterSettings(ModelRegisterSettings.builder().applyMutation(modelRegisterSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TimeSeriesForecastingSettings timeSeriesForecastingSettings;

        private ModelRegisterSettings modelRegisterSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CanvasAppSettings model) {
            timeSeriesForecastingSettings(model.timeSeriesForecastingSettings);
            modelRegisterSettings(model.modelRegisterSettings);
        }

        public final TimeSeriesForecastingSettings.Builder getTimeSeriesForecastingSettings() {
            return timeSeriesForecastingSettings != null ? timeSeriesForecastingSettings.toBuilder() : null;
        }

        public final void setTimeSeriesForecastingSettings(TimeSeriesForecastingSettings.BuilderImpl timeSeriesForecastingSettings) {
            this.timeSeriesForecastingSettings = timeSeriesForecastingSettings != null ? timeSeriesForecastingSettings.build()
                    : null;
        }

        @Override
        public final Builder timeSeriesForecastingSettings(TimeSeriesForecastingSettings timeSeriesForecastingSettings) {
            this.timeSeriesForecastingSettings = timeSeriesForecastingSettings;
            return this;
        }

        public final ModelRegisterSettings.Builder getModelRegisterSettings() {
            return modelRegisterSettings != null ? modelRegisterSettings.toBuilder() : null;
        }

        public final void setModelRegisterSettings(ModelRegisterSettings.BuilderImpl modelRegisterSettings) {
            this.modelRegisterSettings = modelRegisterSettings != null ? modelRegisterSettings.build() : null;
        }

        @Override
        public final Builder modelRegisterSettings(ModelRegisterSettings modelRegisterSettings) {
            this.modelRegisterSettings = modelRegisterSettings;
            return this;
        }

        @Override
        public CanvasAppSettings build() {
            return new CanvasAppSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
