/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoMLJobSecondaryStatus {
    STARTING("Starting"),
    ANALYZING_DATA("AnalyzingData"),
    FEATURE_ENGINEERING("FeatureEngineering"),
    MODEL_TUNING("ModelTuning"),
    MAX_CANDIDATES_REACHED("MaxCandidatesReached"),
    FAILED("Failed"),
    STOPPED("Stopped"),
    MAX_AUTO_ML_JOB_RUNTIME_REACHED("MaxAutoMLJobRuntimeReached"),
    STOPPING("Stopping"),
    CANDIDATE_DEFINITIONS_GENERATED("CandidateDefinitionsGenerated"),
    GENERATING_EXPLAINABILITY_REPORT("GeneratingExplainabilityReport"),
    COMPLETED("Completed"),
    EXPLAINABILITY_ERROR("ExplainabilityError"),
    DEPLOYING_MODEL("DeployingModel"),
    MODEL_DEPLOYMENT_ERROR("ModelDeploymentError"),
    GENERATING_MODEL_INSIGHTS_REPORT("GeneratingModelInsightsReport"),
    MODEL_INSIGHTS_ERROR("ModelInsightsError"),
    TRAINING_MODELS("TrainingModels"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoMLJobSecondaryStatus> VALUE_MAP;
    private final String value;

    private AutoMLJobSecondaryStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoMLJobSecondaryStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoMLJobSecondaryStatus> knownValues() {
        EnumSet<AutoMLJobSecondaryStatus> knownValues = EnumSet.allOf(AutoMLJobSecondaryStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoMLJobSecondaryStatus.class, AutoMLJobSecondaryStatus::toString);
    }
}

