/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SortOrder;
import software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigAppType;
import software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigSortKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStudioLifecycleConfigsRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListStudioLifecycleConfigsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListStudioLifecycleConfigsRequest.getter(ListStudioLifecycleConfigsRequest::maxResults)).setter(ListStudioLifecycleConfigsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStudioLifecycleConfigsRequest.getter(ListStudioLifecycleConfigsRequest::nextToken)).setter(ListStudioLifecycleConfigsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NameContains").getter(ListStudioLifecycleConfigsRequest.getter(ListStudioLifecycleConfigsRequest::nameContains)).setter(ListStudioLifecycleConfigsRequest.setter(Builder::nameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()}).build();
    private static final SdkField<String> APP_TYPE_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppTypeEquals").getter(ListStudioLifecycleConfigsRequest.getter(ListStudioLifecycleConfigsRequest::appTypeEqualsAsString)).setter(ListStudioLifecycleConfigsRequest.setter(Builder::appTypeEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppTypeEquals").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeBefore").getter(ListStudioLifecycleConfigsRequest.getter(ListStudioLifecycleConfigsRequest::creationTimeBefore)).setter(ListStudioLifecycleConfigsRequest.setter(Builder::creationTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeAfter").getter(ListStudioLifecycleConfigsRequest.getter(ListStudioLifecycleConfigsRequest::creationTimeAfter)).setter(ListStudioLifecycleConfigsRequest.setter(Builder::creationTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()}).build();
    private static final SdkField<Instant> MODIFIED_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedTimeBefore").getter(ListStudioLifecycleConfigsRequest.getter(ListStudioLifecycleConfigsRequest::modifiedTimeBefore)).setter(ListStudioLifecycleConfigsRequest.setter(Builder::modifiedTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedTimeBefore").build()}).build();
    private static final SdkField<Instant> MODIFIED_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedTimeAfter").getter(ListStudioLifecycleConfigsRequest.getter(ListStudioLifecycleConfigsRequest::modifiedTimeAfter)).setter(ListStudioLifecycleConfigsRequest.setter(Builder::modifiedTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedTimeAfter").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListStudioLifecycleConfigsRequest.getter(ListStudioLifecycleConfigsRequest::sortByAsString)).setter(ListStudioLifecycleConfigsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListStudioLifecycleConfigsRequest.getter(ListStudioLifecycleConfigsRequest::sortOrderAsString)).setter(ListStudioLifecycleConfigsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, NAME_CONTAINS_FIELD, APP_TYPE_EQUALS_FIELD, CREATION_TIME_BEFORE_FIELD, CREATION_TIME_AFTER_FIELD, MODIFIED_TIME_BEFORE_FIELD, MODIFIED_TIME_AFTER_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));
    private final Integer maxResults;
    private final String nextToken;
    private final String nameContains;
    private final String appTypeEquals;
    private final Instant creationTimeBefore;
    private final Instant creationTimeAfter;
    private final Instant modifiedTimeBefore;
    private final Instant modifiedTimeAfter;
    private final String sortBy;
    private final String sortOrder;

    private ListStudioLifecycleConfigsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.nameContains = builder.nameContains;
        this.appTypeEquals = builder.appTypeEquals;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.modifiedTimeBefore = builder.modifiedTimeBefore;
        this.modifiedTimeAfter = builder.modifiedTimeAfter;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String nameContains() {
        return this.nameContains;
    }

    public final StudioLifecycleConfigAppType appTypeEquals() {
        return StudioLifecycleConfigAppType.fromValue(this.appTypeEquals);
    }

    public final String appTypeEqualsAsString() {
        return this.appTypeEquals;
    }

    public final Instant creationTimeBefore() {
        return this.creationTimeBefore;
    }

    public final Instant creationTimeAfter() {
        return this.creationTimeAfter;
    }

    public final Instant modifiedTimeBefore() {
        return this.modifiedTimeBefore;
    }

    public final Instant modifiedTimeAfter() {
        return this.modifiedTimeAfter;
    }

    public final StudioLifecycleConfigSortKey sortBy() {
        return StudioLifecycleConfigSortKey.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.appTypeEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStudioLifecycleConfigsRequest)) {
            return false;
        }
        ListStudioLifecycleConfigsRequest other = (ListStudioLifecycleConfigsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.nameContains(), other.nameContains()) && Objects.equals(this.appTypeEqualsAsString(), other.appTypeEqualsAsString()) && Objects.equals(this.creationTimeBefore(), other.creationTimeBefore()) && Objects.equals(this.creationTimeAfter(), other.creationTimeAfter()) && Objects.equals(this.modifiedTimeBefore(), other.modifiedTimeBefore()) && Objects.equals(this.modifiedTimeAfter(), other.modifiedTimeAfter()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListStudioLifecycleConfigsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("NameContains", (Object)this.nameContains()).add("AppTypeEquals", (Object)this.appTypeEqualsAsString()).add("CreationTimeBefore", (Object)this.creationTimeBefore()).add("CreationTimeAfter", (Object)this.creationTimeAfter()).add("ModifiedTimeBefore", (Object)this.modifiedTimeBefore()).add("ModifiedTimeAfter", (Object)this.modifiedTimeAfter()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "NameContains": {
                return Optional.ofNullable(clazz.cast(this.nameContains()));
            }
            case "AppTypeEquals": {
                return Optional.ofNullable(clazz.cast(this.appTypeEqualsAsString()));
            }
            case "CreationTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.creationTimeBefore()));
            }
            case "CreationTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.creationTimeAfter()));
            }
            case "ModifiedTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.modifiedTimeBefore()));
            }
            case "ModifiedTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.modifiedTimeAfter()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStudioLifecycleConfigsRequest, T> g) {
        return obj -> g.apply((ListStudioLifecycleConfigsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String nameContains;
        private String appTypeEquals;
        private Instant creationTimeBefore;
        private Instant creationTimeAfter;
        private Instant modifiedTimeBefore;
        private Instant modifiedTimeAfter;
        private String sortBy;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStudioLifecycleConfigsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.nameContains(model.nameContains);
            this.appTypeEquals(model.appTypeEquals);
            this.creationTimeBefore(model.creationTimeBefore);
            this.creationTimeAfter(model.creationTimeAfter);
            this.modifiedTimeBefore(model.modifiedTimeBefore);
            this.modifiedTimeAfter(model.modifiedTimeAfter);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getNameContains() {
            return this.nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final String getAppTypeEquals() {
            return this.appTypeEquals;
        }

        public final void setAppTypeEquals(String appTypeEquals) {
            this.appTypeEquals = appTypeEquals;
        }

        @Override
        public final Builder appTypeEquals(String appTypeEquals) {
            this.appTypeEquals = appTypeEquals;
            return this;
        }

        @Override
        public final Builder appTypeEquals(StudioLifecycleConfigAppType appTypeEquals) {
            this.appTypeEquals(appTypeEquals == null ? null : appTypeEquals.toString());
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return this.creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return this.creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getModifiedTimeBefore() {
            return this.modifiedTimeBefore;
        }

        public final void setModifiedTimeBefore(Instant modifiedTimeBefore) {
            this.modifiedTimeBefore = modifiedTimeBefore;
        }

        @Override
        public final Builder modifiedTimeBefore(Instant modifiedTimeBefore) {
            this.modifiedTimeBefore = modifiedTimeBefore;
            return this;
        }

        public final Instant getModifiedTimeAfter() {
            return this.modifiedTimeAfter;
        }

        public final void setModifiedTimeAfter(Instant modifiedTimeAfter) {
            this.modifiedTimeAfter = modifiedTimeAfter;
        }

        @Override
        public final Builder modifiedTimeAfter(Instant modifiedTimeAfter) {
            this.modifiedTimeAfter = modifiedTimeAfter;
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(StudioLifecycleConfigSortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStudioLifecycleConfigsRequest build() {
            return new ListStudioLifecycleConfigsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStudioLifecycleConfigsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder nameContains(String var1);

        public Builder appTypeEquals(String var1);

        public Builder appTypeEquals(StudioLifecycleConfigAppType var1);

        public Builder creationTimeBefore(Instant var1);

        public Builder creationTimeAfter(Instant var1);

        public Builder modifiedTimeBefore(Instant var1);

        public Builder modifiedTimeAfter(Instant var1);

        public Builder sortBy(String var1);

        public Builder sortBy(StudioLifecycleConfigSortKey var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

